<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/dashboard">{{ __('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="/promo">{{ __('Promo') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        @if ($add)
                            {{ __('Add Promo') }}
                        @else
                            {{ __('Edit Promo') }}
                        @endif
                    </li>
                    <li>
                    </li>
                </ol>
                {{-- <div>
                    @if ($add)
                    <button wire:click="create" type="button" class="btn btn-primary btn-sm" >{{ __('Create') }}</button>
                    @else
                    <button wire:click="create" type="button" class="btn btn-primary btn-sm" >{{ __('Update') }}</button>
                    @endif
                    <a href="/promo" type="button" class="btn btn-secondary btn-sm">{{ __('Close') }}</a>
                </div> --}}
            </div>
        </nav>

        <div class="" id=cashier>
            <div class="button-top-right">
                @if ($add)
                    <button wire:click="create" type="button"
                        class="btn btn-primary btn-sm">{{ __('Create') }}</button>
                @else
                    <button wire:click="create" type="button"
                        class="btn btn-primary btn-sm">{{ __('Update') }}</button>
                @endif
                <a href="/promo" type="button" class="btn btn-secondary btn-sm">{{ __('Close') }}</a>
            </div>
            <div class="d-flex gap-3">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                <h4 class="card-title">{{ __('Promo Header') }}</h6>
                            </div>

                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="tipe" class="form-label">{{ __('Promo Type') }}</label>
                                    <select wire:model.live="tipe"
                                        class="form-select @error('tipe') is-invalid @enderror form-select-sm"
                                        id="tipe" @if ($flag || $flagImport) disabled @else @endif>
                                        <option value="">-- {{ __('Select Promo Type') }} --</option>
                                        <option value="1">{{ __('Discount (%)') }} </option>
                                        <option value="2">{{ __('Special Price') }}</option>
                                        <option value="3">{{ __('Bundling') }}</option>
                                        <option value="4">{{ __('Gift With Purchase by Qty') }}</option>
                                        <option value="5">{{ __('Gift With Purchase by Value') }}</option>
                                        <option value="6">{{ __('Voucher') }}</option>
                                        <option value="7">{{ __('Unlimited Bundling') }}</option>
                                    </select>
                                    @error('tipe')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($tipe == 3 || $tipe == 4)
                                        <label for="qty_pack" class="form-label">Qty Pack</label>
                                        <input type="number" wire:model.live="qty_pack"
                                            class="form-control @error('qty_pack') is-invalid @enderror form-control-sm"
                                            id="qty_pack" min="0"
                                            @if ($flag || $flagImport) disabled @endif>
                                        @error('qty_pack')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    @elseif ($tipe == 5)
                                        <div class="col">
                                            <label for="value_pack" class="form-label">Total Value</label>
                                            <input type="number" wire:model.live="value_pack"
                                                class="form-control @error('value_pack') is-invalid @enderror form-control-sm"
                                                id="value_pack" min="0"
                                                @if ($flag || $flagImport) disabled @endif>
                                            @error('value_pack')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @if ($tipe != '')
                                <div class="mb-3">
                                    <label for="name" class="form-label">{{ __('Promo Name') }}</label>
                                    <input wire:model.live="name" type="text"
                                        class="form-control @error('name') is-invalid @enderror form-control-sm"
                                        name="name" id="name">
                                    @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="from_date">Start Date</label>
                                        <input wire:model.live="from_date" type="date"
                                            class="form-control @error('from_date') is-invalid @enderror form-control-sm"
                                            id="from_date">
                                        @error('from_date')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col">
                                        <label for="to_date">End Date</label>
                                        <input wire:model.live="to_date" type="date"
                                            class="form-control @error('to_date') is-invalid @enderror form-control-sm"
                                            id="to_date">
                                        @error('to_date')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="pricelist_code" class="form-label">{{ __('Pricelist') }}</label>
                                        <select wire:model.live="pricelist_code"
                                            class="form-select @error('pricelist_code') is-invalid @enderror form-select-sm"
                                            name="pricelist_code" id="pricelist_code"
                                            @if ($flag || $flagImport) disabled @endif>
                                            <option value="">-- {{ __('Select Pricelist') }} --</option>
                                            @if ($tipe != 1 && $tipe != 2)
                                                <option value="0">All Pricelist</option>
                                            @endif
                                            @foreach ($pricelist as $pl)
                                                <option value="{{ $pl->code }}">{{ $pl->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('pricelist_code')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col"></div>
                                </div>
                                @if ($pricelist_code != '')
                                    <div class="mb-3 form-group row">
                                        <div class="col">
                                            <div x-data="{ open: false, allChecked: false, search: '' }" class="col" @click.away="open = false">
                                                <label for="warehouse" class="form-label">{{ __('Store') }}</label>
                                                @if ($flagWhs)
                                                    @if ($add)
                                                        <button class="form-select form-select-sm"
                                                            x-on:click.prevent="open = !open"
                                                            x-text="(allChecked ? 'All Selected' : '-- Select Store --')">
                                                            -- Select Store --
                                                        </button>
                                                    @else
                                                        <button class="form-select form-select-sm"
                                                            x-on:click.prevent="open = !open"
                                                            x-text="(allChecked ? 'All Selected' : '-- Edit Store --')">
                                                            -- Edit Store --
                                                        </button>
                                                    @endif
                                                @else
                                                    @if ($add)
                                                        <button class="form-select form-select-sm border border-danger"
                                                            x-on:click.prevent="open = !open"
                                                            x-text="(allChecked ? 'All Selected' : '-- Select Store --')">
                                                            -- Select Store --
                                                        </button>
                                                        <span class="text-danger">Store must be filled.</span>
                                                    @else
                                                        <button class="form-select form-select-sm border border-danger"
                                                            x-on:click.prevent="open = !open"
                                                            x-text="(allChecked ? 'All Selected' : '-- Edit Store --')">
                                                            -- Edit Store --
                                                        </button>
                                                        <span class="text-danger">Store must be filled.</span>
                                                    @endif
                                                @endif

                                                <div x-show.important="open" x-transition
                                                    class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                    <div class="mt-2 ms-2 mb-2">
                                                        <input type="checkbox" id="whsSelectAll" name="whsSelectAll"
                                                            x-model="allChecked" wire:model.live="whsSelectAll">
                                                        <label for="selectAllCheckbox" class="ms-2">Select
                                                            All</label>
                                                    </div>
                                                    <input type="text" x-model="search"
                                                        class="form-control form-control-sm mb-2"
                                                        placeholder="Search Store">
                                                    @foreach ($whs as $wh)
                                                        <div class="ms-4"
                                                            x-show="containsIgnoreCase('{{ $wh->name }}', search)">
                                                            <input
                                                                x:checked="allChecked && whsCheckboxes.{{ $wh->code }}"
                                                                x-bind:hidden="allChecked" type="checkbox"
                                                                id="whsCheckboxes{{ $wh->code }}"
                                                                name="whsCheckboxes{{ $wh->code }}"
                                                                wire:model="whsCheckboxes.{{ $wh->code }}"
                                                                x-on:change.live="updateWhsCheckboxes('{{ $wh->code }}')">
                                                            <label x-bind:hidden="allChecked" class="ms-2"
                                                                for="whsCheckboxes{{ $wh->code }}">{{ $wh->name }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col"></div>
                                    </div>
                                @endif

                                @if ($tipe == 3)
                                    <div class="mb-3 form-group row">
                                        <div class="col">
                                            <label for="bundling_benefit"
                                                class="form-label">{{ __('Benefit Type') }}</label>
                                            <select wire:model.live="bundling_benefit"
                                                class="form-control @error('bundling_benefit') is-invalid @enderror form-select-sm"
                                                id="bundling_benefit">
                                                <option value="">-- {{ __('Select Benefit Type') }} --</option>
                                                <option value="1">{{ __('Discount (%)') }}</option>
                                                <option value="2">{{ __('Special Price') }}</option>
                                            </select>
                                            @error('bundling_benefit')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col">
                                            {{-- Bundling Discount Fields --}}
                                            @if ($this->shouldShowBundlingDiscountFields())
                                                <label for="bundling_benefit_disc" class="form-label">Discount
                                                    (%)</label>
                                                <input type="number" wire:model.live="bundling_benefit_disc"
                                                    class="form-control @error('bundling_benefit_disc') is-invalid @enderror form-control-sm"
                                                    id="bundling_benefit_disc" max="100" min="1">
                                                @error('bundling_benefit_disc')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            @endif
                                            
                                            {{-- Bundling Special Price Fields --}}
                                            @if ($this->shouldShowBundlingPriceFields())
                                                <label for="bundling_benefit_price" class="form-label">Special
                                                    Price</label>
                                                <input type="number" wire:model.live="bundling_benefit_price"
                                                    class="form-control @error('bundling_benefit_price') is-invalid @enderror form-control-sm"
                                                    id="bundling_benefit_price" min="1">
                                                @error('bundling_benefit_price')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            @endif
                                        </div>
                                    </div>
                                @elseif ($tipe == 4 || $tipe == 5)
                                    <div class="mb-3 form-group row">
                                        <div class="col">
                                            <label for="gwp_benefit"
                                                class="form-label">{{ __('Benefit Type') }}</label>
                                            <select wire:model.live="gwp_benefit"
                                                class="form-control @error('gwp_benefit') is-invalid @enderror form-select-sm"
                                                id="gwp_benefit" @if ($flag || $flagImport) disabled @endif>
                                                <option value="">-- {{ __('Select Benefit Type') }} --</option>
                                                <option value="1">{{ __('Item') }}</option>
                                                <option value="2">{{ __('Free Cheapest Item') }}</option>
                                                <option value="3">{{ __('Cashback') }}</option>
                                            </select>
                                            @error('gwp_benefit')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col">
                                            {{-- Item Benefit Fields --}}
                                            @if ($this->shouldShowItemFields())
                                                <div class="mb-3 form-group row" x-data="{ selectedIndex: null }"
                                                    x-init="selectedIndex = -1">
                                                    <div class="col">
                                                        <label class="form-label">Search</label>
                                                        <div class="input-group">
                                                            @if ($gwp_search_by == 1)
                                                                @if ($errorDetail == '')
                                                                    <input type="text"
                                                                        wire:model.live="searchProducts"
                                                                        class="form-control form-control-sm"
                                                                        @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                                                        @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                                                        x-on:keydown.enter="
                                        if(selectedIndex == -1) {
                                            $wire.searchGWPItem();
                                        } else {
                                            $wire.selectProduct(selectedIndex);
                                            selectedIndex = -1; 
                                        }"
                                                                        x-on:keydown.tab.prevent="
                                        selectedIndex = Math.min(selectedIndex + 1, {{ count($products) - 1 }});
                                        event.preventDefault();
                                    "
                                                                        autocomplete="off">
                                                                @else
                                                                    <input type="text"
                                                                        wire:model.live="gwp_item_code"
                                                                        class="form-control form-control-sm is-invalid">
                                                                @endif
                                                            @else
                                                                <input type="text" wire:model.live="gwp_item_code"
                                                                        class="form-control form-control-sm" disabled>
                                                            @endif
                                                        </div>
                                                        @if ($gwp_search_by == 1 && $errorDetail != '')
                                                            <span class="text-danger">{{ $errorDetail }}</span>
                                                        @endif
                                                        @if ($gwp_search_by == 1 && sizeof($products) > 0 && $selectedItem === null)
                                                            @if ($searchProducts != '')
                                                                <div class="dropdown-menu d-block py-0 mt-1 ">
                                                                    @foreach ($products as $index => $product)
                                                                        <div class="px-2 py-1 border-bottom"
                                                                            :class="{
                                                                                'bg-primary': selectedIndex ===
                                                                                    {{ $index }}
                                                                            }">
                                                                            <div class="d-flex flex-column ml-3">
                                                                                <button type="button"
                                                                                    class="btn btn-link"
                                                                                    wire:click="selectProductGWPByClick('{{ $product->code }}')"
                                                                                    :class="{
                                                                                        'text-white': selectedIndex ===
                                                                                            {{ $index }}
                                                                                    }">
                                                                                    {{ $product->code }} ||
                                                                                    {{ $product->name }}
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                        @endif
                                                    </div>
                                                </div>
                                            @endif
                                            
                                            {{-- Cashback Benefit Fields --}}
                                            @if ($this->shouldShowCashbackFields())
                                                <label for="gwp_benefit_voucher" class="form-label">Cashback
                                                    Value</label>
                                                <input type="number" wire:model.live="gwp_benefit_voucher"
                                                    class="form-control @error('gwp_benefit_voucher') is-invalid @enderror form-control-sm"
                                                    id="gwp_benefit_voucher" min="0">
                                                @error('gwp_benefit_voucher')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            @endif
                                        </div>
                                    </div>

                                    {{-- Item Benefit Detailed Fields --}}
                                    @if ($this->shouldShowItemFields())
                                        <div class="mb-3 form-group row" x-data="{ selectedIndex: null }"
                                            x-init="selectedIndex = -1">
                                            <div class="col">
                                                <label class="form-label">ItemCode</label>
                                                <div class="input-group">
                                                    @if ($gwp_search_by == 1)
                                                        @if ($errorDetail == '')
                                                            <input type="text" wire:model.live="item_code"
                                                                class="form-control form-control-sm"
                                                                autocomplete="off" disabled>
                                                        @else
                                                            <input type="text" wire:model.live="gwp_item_code"
                                                                class="form-control form-control-sm is-invalid">
                                                        @endif
                                                    @else
                                                        <input type="text" wire:model.live="gwp_item_code"
                                                            class="form-control form-control-sm" disabled>
                                                    @endif
                                                </div>
                                                @if ($gwp_search_by == 1 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif
                                            </div>
                                            <div class="col">
                                                <label for="gwp_item_barcode" class="form-label">CodeBars</label>
                                                <div class="input-group">
                                                    @if ($gwp_search_by == 2)
                                                        @if ($errorDetail == '')
                                                            <input type="text" wire:model.live="item_barcode"
                                                                class="form-control form-control-sm"
                                                                autocomplete="off">
                                                        @else
                                                            <input type="text" wire:model.live="gwp_item_barcode"
                                                                class="form-control form-control-sm is-invalid">
                                                        @endif
                                                    @else
                                                        <input type="text" wire:model.live="gwp_item_barcode"
                                                            class="form-control form-control-sm" disabled>
                                                    @endif
                                                </div>
                                                @if ($gwp_search_by == 2 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                <label for="gwp_item_name" class="form-label">ItemName</label>
                                                <input type="text" wire:model.live="gwp_item_name"
                                                    class="form-control form-control-sm" disabled>
                                            </div>
                                            <div class="col"></div>
                                        </div>
                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                <label class="form-label">{{ __('Discount Type') }}</label>
                                                <select wire:model.live="gwp_disc_by"
                                                    class="form-control form-select-sm">
                                                    <option value="1">{{ __('Discount (%)') }}</option>
                                                    <option value="2">{{ __('Special Price') }}</option>
                                                </select>
                                            </div>
                                            <div class="col">
                                                @if ($gwp_disc_by == 1)
                                                    <label class="form-label">Discount (%)</label>
                                                    <div class="input-group">
                                                        <input type="number" wire:model.live="gwp_item_disc"
                                                            class="form-control form-control-sm">
                                                        <button class="btn btn-primary btn-sm"
                                                            wire:click.prevent="addGwp">Add Item</button>
                                                    </div>
                                                @else
                                                    <label class="form-label">Special Price</label>
                                                    <div class="input-group">
                                                        <input type="number" wire:model.live="gwp_item_price"
                                                            class="form-control form-control-sm">
                                                        <button class="btn btn-primary btn-sm"
                                                            wire:click.prevent="addGwp">Add Item</button>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                        <livewire:promo.promo-gwp-item :tipe="$tipe" />
                                    @endif
                                    
                                    {{-- Cashback Benefit Date Fields --}}
                                    @if ($this->shouldShowVoucherFields())
                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                <label for="voucher_from_date">Cashback Start Date</label>
                                                <input wire:model.live="voucher_from_date" type="date"
                                                    class="form-control @error('voucher_from_date') is-invalid @enderror form-control-sm"
                                                    id="voucher_from_date">
                                                @error('voucher_from_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="col">
                                                <label for="voucher_to_date">Cashback End Date</label>
                                                <input wire:model.live="voucher_to_date" type="date"
                                                    class="form-control @error('voucher_to_date') is-invalid @enderror form-control-sm"
                                                    id="voucher_to_date">
                                                @error('voucher_to_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    @endif
                                @elseif ($tipe == 7)
                                    <div class="mb-3">
                                        @if ($errorBundlingQty == '')
                                            <label for="bundling_benefit_qty" class="form-label">Discount (%) by
                                                Qty</label>
                                        @else
                                            <label for="bundling_benefit_qty" class="form-label">Discount (%) by
                                                Qty</label>
                                            <span class="text-danger">{{ $errorBundlingQty }}</span>
                                        @endif

                                    </div>

                                    <div class="mb-3">
                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                <label for="bundling_qty_qty" class="form-label">Qty</label>
                                                <div class="input-group">
                                                    <input wire:model.live="bundling_qty_qty"
                                                        class="form-control form-control-sm" id="item_bundling_qty"
                                                        x-mask:dynamic="$money($input, '.')">
                                                    @error('bundling_qty_qty')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col">
                                                <label for="bundling_qty_disc" class="form-label">Discount (%)</label>
                                                <div class="input-group">
                                                    <input wire:model.live="bundling_qty_disc"
                                                        class="form-control form-control-sm" id="bundling_qty_disc"
                                                        x-mask:dynamic="$money($input, '.')">
                                                    @error('bundling_qty_disc')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                    <a type="button" class="btn btn-primary btn-sm"
                                                        wire:click.prevent="addBundlingQty">Add</a>
                                                </div>
                                            </div>
                                        </div>
                                        <livewire:promo.promo-add-bundling-qty />
                                    </div>
                                @endif

                                @if ($tipe != 5)
                                    @if ($add && $flag == false && $flagImport == false)
                                        @if ($tipe == 6)
                                            <a type="button" class="btn btn-primary btn-sm mt-3"
                                                wire:click.prevent="detail">Input Voucher</a>
                                            <a type="button" class="btn btn-success btn-sm mt-3"
                                                wire:click.prevent="detailImport">Import Voucher</a>
                                        @else
                                            <a type="button" class="btn btn-primary btn-sm mt-3"
                                                wire:click.prevent="detail">Input Item Promo</a>
                                            <a type="button" class="btn btn-success btn-sm mt-3"
                                                wire:click.prevent="detailImport">Import Item Promo</a>
                                        @endif
                                    @endif
                                @endif
                            @endif
                        </div>
                    </div>
                </div>

                @if ($flag)
                    @if ($tipe != 5)
                        @if ($tipe == 6)
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div
                                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                            <h4 class="card-title">{{ __('Input Voucher') }}</h6>
                                        </div>

                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                <label for="create_by"
                                                    class="form-label">{{ __('Create by') }}</label>
                                                <select wire:model.live="create_by"
                                                    class="form-control form-select-sm" id="create_by">
                                                    <option value="1">{{ __('Voucher') }}</option>
                                                    <option value="2">{{ __('Batch') }}</option>
                                                </select>
                                            </div>
                                            <div class="col"></div>
                                        </div>

                                        <div class="mb-3 form-group row">
                                            <div class="col">
                                                @if ($create_by == 1)
                                                    <label for="create_by_voucher_no" class="form-label">Voucher
                                                        No</label>
                                                    @if ($errorDetail == '')
                                                        <input type="text" wire:model.live="create_by_voucher_no"
                                                            class="form-control form-control-sm @error('create_by_voucher_no') is-invalid @enderror"
                                                            id="create_by_voucher_no"
                                                            @if ($editItem) disabled @endif>
                                                        @error('create_by_voucher_no')
                                                            <span class=" text-danger">{{ $message }}</span>
                                                        @enderror
                                                    @else
                                                        <input type="text" wire:model.live="create_by_voucher_no"
                                                            class="form-control form-control-sm is-invalid"
                                                            id="create_by_voucher_no"
                                                            @if ($editItem) disabled @endif>
                                                    @endif
                                                @else
                                                    <label for="create_by_voucher_batch" class="form-label">Number of
                                                        Vouchers</label>
                                                    <input type="text" wire:model.live="create_by_voucher_batch"
                                                        class="form-control form-control-sm @error('create_by_voucher_batch') is-invalid @enderror"
                                                        id="create_by_voucher_batch">
                                                    @error('create_by_voucher_batch')
                                                        <span class=" text-danger">{{ $message }}</span>
                                                    @enderror
                                                @endif
                                                @if ($create_by == 1 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif
                                            </div>
                                            <div class="col">
                                                <label for="create_by_voucher_value" class="form-label">Voucher
                                                    Value</label>
                                                <input type="number" wire:model.live="create_by_voucher_value"
                                                    class="form-control form-control-sm @error('create_by_voucher_value') is-invalid @enderror"
                                                    id="create_by_voucher_value">
                                                @error('create_by_voucher_value')
                                                    <span class=" text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <a type="button" class="btn btn-primary btn-sm mt-3"
                                            wire:click.prevent="addListVoucher">
                                            @if ($editItem)
                                                Edit to List
                                            @else
                                                Add to List
                                            @endif
                                        </a>
                                        <a type="button" class="btn btn-secondary btn-sm mt-3"
                                            wire:click.prevent="clearItem">Clear</a>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div
                                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                            <h4 class="card-title">{{ __('Input Item Promo') }}
                                                </h6>
                                        </div>

                                        <div class="mb-3 form-group row" x-data="{ selectedIndex: null }"
                                            x-init="selectedIndex = -1">
                                            <div class="col">
                                                <label for="item_code" class="form-label">Search</label>
                                                <div class="input-group">
                                                    @if ($search_by == 1)
                                                        @if ($errorDetail == '')
                                                            <input type="text" wire:model.live="searchProducts"
                                                                class="form-control form-control-sm" id="item_code"
                                                                @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                                                @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                                                x-on:keydown.enter="
                                                                if(selectedIndex == -1) {
                                                                    $wire.searchItem();
                                                                } else {
                                                                    $wire.selectProduct(selectedIndex);
                                                                    selectedIndex = -1; 
                                                                }"
                                                                x-on:keydown.tab.prevent="
                                                                selectedIndex = Math.min(selectedIndex + 1, {{ count($products) - 1 }});
                                                                event.preventDefault();
                                                            "
                                                                autocomplete="off">
                                                        @else
                                                            <input type="text" wire:model.live="item_code"
                                                                class="form-control form-control-sm is-invalid"
                                                                id="item_code">
                                                        @endif
                                                    @else
                                                        <!-- <input type="text" class="form-control form-control-sm" value="{{ $item_code }}" disabled> -->
                                                        <input type="text" wire:model.live="item_code"
                                                            class="form-control form-control-sm" disabled>
                                                    @endif

                                                </div>
                                                @if ($search_by == 1 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif

                                                @if ($search_by == 1 && sizeof($products) > 0 && $selectedItem === null)
                                                    @if ($searchProducts != '')
                                                        <div class="dropdown-menu d-block py-0 mt-1 ">
                                                            @foreach ($products as $index => $product)
                                                                <div class="px-2 py-1 border-bottom"
                                                                    :class="{
                                                                        'bg-primary': selectedIndex ===
                                                                            {{ $index }}
                                                                    }">
                                                                    <div class="d-flex flex-column ml-3">
                                                                        <button type="button" class="btn btn-link"
                                                                            wire:click="selectProductByClick('{{ $product->code }}')"
                                                                            :class="{
                                                                                'text-white': selectedIndex ===
                                                                                    {{ $index }}
                                                                            }">
                                                                            {{ $product->code }} ||
                                                                            {{ $product->name }}
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                @endif
                                            </div>
                                            <div class="col">
                                                @if ($tipe == 3 || $tipe == 4)
                                                    <div x-data="{ open: false, allChecked: false }" class="col"
                                                        @click.away="open = false">
                                                        <label for="pack"
                                                            class="form-label">{{ __('Promo Pack') }}</label>
                                                        @if ($flagPack)
                                                            <button class="form-control form-control-sm"
                                                                x-on:click.prevent="open = ! open"
                                                                x-text="(allChecked ? 'All Selected' : 'Select Pack')">
                                                                Select Pack
                                                            </button>
                                                        @else
                                                            <button
                                                                class="form-control form-control-sm border border-danger"
                                                                x-on:click.prevent="open = ! open"
                                                                x-text="(allChecked ? 'All Selected' : 'Select Pack')">
                                                                Select Pack
                                                            </button>
                                                            <span class="text-danger">The promo pack harus
                                                                diisi.</span>
                                                        @endif
                                                        <div x-show.important="open" x-transition
                                                            class="form-control dropdown-menu d-block py-0 w-auto px-2">
                                                            <div class="mt-2 ms-2 mb-2">
                                                                <input type="checkbox" id="packSelectAll"
                                                                    name="packSelectAll" x-model="allChecked"
                                                                    wire:model.live="packSelectAll">
                                                                <label for="selectAllCheckbox" class="ms-2">Select
                                                                    All</label>
                                                            </div>
                                                            @for ($i = 1; $i <= $qty_pack; $i++)
                                                                <div class="ms-4">
                                                                    <input x-bind:checked="allChecked"
                                                                        x-bind:hidden="allChecked" type="checkbox"
                                                                        id="packCheckboxes{{ $i }}"
                                                                        name="packCheckboxes{{ $i }}"
                                                                        wire:model.live="packCheckboxes.{{ $i }}"
                                                                        x-on:change.live="updatePackCheckboxes('{{ $i }}')">
                                                                    <label x-bind:hidden="allChecked" class="ms-2"
                                                                        for="packCheckboxes{{ $i }}">{{ $i }}</label>
                                                                </div>
                                                            @endfor
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="mb-3 form-group row" x-data="{ selectedIndex: null }"
                                            x-init="selectedIndex = -1">
                                            <div class="col">
                                                <label for="item_code" class="form-label">ItemCode</label>
                                                <div class="input-group">
                                                    @if ($search_by == 1)
                                                        @if ($errorDetail == '')
                                                            <input type="text" wire:model.live="item_code"
                                                                class="form-control form-control-sm" id="item_code"
                                                                autocomplete="off" disabled>
                                                        @else
                                                            <input type="text" wire:model.live="item_code"
                                                                class="form-control form-control-sm is-invalid"
                                                                id="item_code">
                                                        @endif
                                                    @else
                                                        <!-- <input type="text" class="form-control form-control-sm" value="{{ $item_code }}" disabled> -->
                                                        <input type="text" wire:model.live="item_code"
                                                            class="form-control form-control-sm" disabled>
                                                    @endif

                                                </div>
                                                @if ($search_by == 1 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif


                                            </div>
                                            <div class="col">
                                                <label for="item_barcode" class="form-label">CodeBars</label>
                                                <div class="input-group">
                                                    @if ($search_by == 2)
                                                        @if ($errorDetail == '')
                                                            <input type="text" wire:model.live="item_barcode"
                                                                class="form-control form-control-sm" id="item_barcode"
                                                                autocomplete="off" disabled>
                                                        @else
                                                            <input type="text" wire:model.live="item_barcode"
                                                                class="form-control form-control-sm is-invalid"
                                                                id="item_barcode">
                                                        @endif
                                                    @else
                                                        <!-- <input type="text" class="form-control form-control-sm" value="{{ $item_barcode }}" disabled> -->
                                                        <input type="text" wire:model.live="item_barcode"
                                                            class="form-control form-control-sm" disabled>
                                                    @endif

                                                </div>
                                                @if ($search_by == 2 && $errorDetail != '')
                                                    <span class="text-danger">{{ $errorDetail }}</span>
                                                @endif

                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label for="item_name" class="form-label">ItemName</label>
                                            <!-- <input type="text" class="form-control form-control-sm" value="{{ $item_name }}" disabled> -->
                                            <input wire:model.live="item_name" type="text"
                                                class="form-control form-control-sm" disabled>
                                        </div>

                                        @if ($tipe == 1 || $tipe == 2)
                                            <div class="mb-3 form-group row">
                                                <div class="col">
                                                    <div class="mb-3">
                                                        <label for="item_nprice" class="form-label">Price</label>
                                                        <!-- <input class="form-control form-control-sm" value="{{ $item_nprice }}" disabled> -->
                                                        <input wire:model.live="item_nprice"
                                                            class="form-control form-control-sm" disabled>
                                                    </div>
                                                </div>

                                                <div class="col">
                                                    @if ($tipe == 1)
                                                        <div class="mb-3">
                                                            <label class="form-label">Discount (%)</label>
                                                            <input wire:model.live="item_disc"
                                                                class="form-control @error('item_disc') is-invalid @enderror form-control-sm"
                                                                id="item_disc" x-mask:dynamic="$money($input, '.')"
                                                                @if ($item_code == '') disabled @endif>
                                                            @error('item_disc')
                                                                <span class=" text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                    @elseif ($tipe == 2)
                                                        <div class="mb-3">
                                                            <label for="item_price" class="form-label">Special
                                                                Price</label>
                                                            <input wire:model.live="item_price"
                                                                class="form-control @error('item_price') is-invalid @enderror form-control-sm"
                                                                id="item_price" x-mask:dynamic="$money($input, '.')">
                                                            @error('item_price')
                                                                <span class=" text-danger">{{ $message }}</span>
                                                            @enderror
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <input type="checkbox" wire:model.live="item_qty_check"
                                                    class="form-check-input" id="item_qty_check">
                                                @if ($tipe == 1)
                                                    <label for="item_qty_check"
                                                        class="form-check-label">{{ __('Input Discount (%) by Qty') }}</label>
                                                @else
                                                    <label for="item_qty_check"
                                                        class="form-check-label">{{ __('Input Special Price by Qty') }}</label>
                                                @endif
                                            </div>

                                            @if ($item_qty_check)
                                                <div class="mb-3">
                                                    <div class="mb-3 form-group row">
                                                        <div class="col">
                                                            <label for="item_qty_qty" class="form-label">Qty</label>
                                                            <div class="input-group">
                                                                <input wire:model.live="item_qty_qty"
                                                                    class="form-control form-control-sm"
                                                                    id="item_qty_qty"
                                                                    x-mask:dynamic="$money($input, '.')">
                                                                @error('item_qty_qty')
                                                                    <span class="text-danger">{{ $message }}</span>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                        <div class="col">
                                                            @if ($tipe == 1)
                                                                <label for="item_qty_disc" class="form-label">Discount
                                                                    (%)</label>
                                                                <div class="input-group">
                                                                    <input wire:model.live="item_qty_disc"
                                                                        class="form-control form-control-sm"
                                                                        id="item_qty_disc"
                                                                        x-mask:dynamic="$money($input, '.')">
                                                                    @error('item_qty_disc')
                                                                        <span
                                                                            class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                    <a type="button" class="btn btn-primary btn-sm"
                                                                        wire:click.prevent="addQty">Add</a>
                                                                </div>
                                                            @else
                                                                <label for="item_qty_price" class="form-label">Special
                                                                    Price</label>
                                                                <div class="input-group">
                                                                    <input wire:model.live="item_qty_price"
                                                                        class="form-control form-control-sm"
                                                                        id="item_qty_price"
                                                                        x-mask:dynamic="$money($input, '.')">
                                                                    @error('item_qty_price')
                                                                        <span
                                                                            class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                    <a type="button" class="btn btn-primary btn-sm"
                                                                        wire:click.prevent="addQty">Add</a>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <livewire:promo.promo-add-item-qty :tipe="$tipe"
                                                        :item_code="$item_code" />
                                                </div>
                                            @endif
                                        @endif

                                        <a type="button" class="btn btn-primary btn-sm mt-3"
                                            wire:click.prevent="addList">
                                            @if ($editItem)
                                                Edit to List
                                            @else
                                                Add to List
                                            @endif
                                        </a>
                                        <a type="button" class="btn btn-secondary btn-sm mt-3"
                                            wire:click.prevent="clearItem">Clear</a>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endif
                @endif

                @if ($flagImport)
                    @if ($tipe != 5)
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div
                                        class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                        <h4 class="card-title">{{ __('Import Item Promo') }}</h6>
                                    </div>

                                    <div class="mb-3">
                                        <label for="file" class="form-label">Promo Detail</label>
                                        <input wire:model="file" type="file"
                                            class="form-control @error('file') is-invalid @enderror form-control-sm"
                                            id="importFile" name="importFile" accept=".csv">
                                        @error('file')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    @if ($tipe == 1 || $tipe == 2)
                                        <div class="mb-3">
                                            <label for="fileQty" class="form-label">Promo Detail by Qty</label>
                                            <input wire:model="fileQty" type="file"
                                                class="form-control form-control-sm" id="importFileQty"
                                                name="importFileQty" accept=".csv">
                                        </div>
                                    @endif

                                    <div class="mb-3">
                                        @if ($import)
                                            <button type="button" class="btn btn-primary btn-sm mt-3" disabled>
                                                <div class="spinner-border spinner-border-sm text-light"
                                                    role="status">
                                                </div>
                                                {{ __('Import') }}
                                            </button>
                                        @else
                                            <button wire:click="importFlagTrue"
                                                class="btn btn-primary btn-sm mt-3">{{ __('Import') }}</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endif
            </div>

            @if ($flag || $flagImport)
                @if ($tipe != 5)
                    <div class="row mt-3">
                        <div class="col-md-12 grid-margin stretch-card">
                            <div class="card">
                                <div class="card-body">
                                    <div
                                        class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                        <h4 class="card-title">{{ __('Promo Detail') }}</h6>
                                    </div>

                                    <livewire:promo.promo-add-table :tipe="$tipe" />
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        </div>

        {{-- @if ($flag || $flagImport)
            @if ($tipe != 5)
                <div class="row mt-3">
                    <div class="col-md-12 grid-margin stretch-card">
                        <div class="card">
                            <div class="card-body">
                                <div
                                    class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                                    <h4 class="card-title">{{ __('Promo Detail') }}</h6>
                                </div>

                                <livewire:promo.promo-add-table :tipe="$tipe" />
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        @endif --}}
    </div>
</div>

@livewireScripts

@push('scripts')
    <script>
        function containsIgnoreCase(value, search) {
            return value.toLowerCase().includes(search.toLowerCase());
        }
    </script>
@endpush

<script>
    function handleEditItem(editItemCode) {
        Livewire.dispatch('editItem', {
            editItemCode: editItemCode
        });
    }

    Livewire.on('focusNextTabDisc', () => {
        document.getElementById('item_disc').focus();
    });

    Livewire.on('focusNextTabPrice', () => {
        document.getElementById('item_price').focus();
    });

    Livewire.on('focusNextTabVoucher', () => {
        document.getElementById('create_by_voucher_value').focus();
    });

    Livewire.on('refresh', () => {
        setTimeout(() => {
            $(document).ready(function() {
                if ($.fn.dataTable.isDataTable('#table')) {
                    $('#table').DataTable().destroy();
                }

                $('#table').DataTable({
                    "lengthMenu": [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ]
                });
            });
        }, 1000);
    });

    setTimeout(() => {
        $(document).ready(function() {
            if ($.fn.dataTable.isDataTable('#table')) {
                $('#table').DataTable().destroy();
            }

            $('#table').DataTable({
                "lengthMenu": [
                    [10, 25, 50, 100, -1],
                    [10, 25, 50, 100, "All"]
                ]
            });
        });
    }, 1000);
</script>
