<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/dashboard">{{ __('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="/promo">{{ __('Promo') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        @if ($add) {{ __('Add Promo') }} @else {{ __('Edit Promo') }} @endif
                    </li>
                </ol>
                <div>
                    <button wire:click="create" type="button" class="btn btn-primary btn-sm">@if ($add) {{ __('Create') }} @else {{ __('Update') }} @endif</button>
                    <a href="/promo" type="button" class="btn btn-secondary btn-sm">{{ __('Close') }}</a>
                </div>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Promo Header') }}</h6>
                        </div>

                        <form>
                            @csrf
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="tipe" class="form-label">{{ __('Promo Type') }}</label>
                                    <select wire:model.live="tipe" class="form-control @error('tipe') is-invalid @enderror form-select-sm" id="tipe" @if($flag || $flagImport) disabled @else @endif>
                                        <option value="">-- {{ __('Select Promo Type') }} --</option>
                                        <option value="1">{{ __('Discount (%)') }}</option>
                                        <option value="2">{{ __('Special Price') }}</option>
                                        <option value="3">{{ __('Bundling') }}</option>
                                        <option value="4">{{ __('Gift With Purchase by Qty') }}</option>
                                        <option value="5">{{ __('Gift With Purchase by Value') }}</option>
                                    </select>
                                    @error('tipe')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($tipe == 3 || $tipe == 4)
                                    <div class="col">
                                        <label for="qty_pack" class="form-label">Qty Pack</label>
                                        <input type="number" wire:model.live="qty_pack" class="form-control @error('qty_pack') is-invalid @enderror form-control-sm" id="qty_pack" min="0" @if ($flag || $flagImport) disabled @endif>
                                        @error('qty_pack')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @elseif ($tipe == 5)
                                    <div class="col">
                                        <label for="value" class="form-label">Value Pack</label>
                                        <input type="number" wire:model.live="value_pack" class="form-control @error('value_pack') is-invalid @enderror form-control-sm" id="value_pack" min="0" @if ($flag || $flagImport) disabled @endif>
                                        @error('value_pack')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @endif
                                </div>
                            </div>

                            @if ($tipe != '')
                            <div class="mb-3">
                                <label for="name" class="form-label">{{ __('Promo Name') }}</label>
                                <input wire:model.live="name" type="text" class="form-control @error('name') is-invalid @enderror form-control-sm" name="name" id="name">
                                @error('name')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="from_date">Start Date</label>
                                    <input wire:model.live="from_date" type="date" class="form-control @error('from_date') is-invalid @enderror form-control-sm" id="from_date">
                                    @error('from_date')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    <label for="to_date">End Date</label>
                                    <input wire:model.live="to_date" type="date" class="form-control @error('to_date') is-invalid @enderror form-control-sm" id="to_date">
                                    @error('to_date')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="id_pricelist" class="form-label">{{ __('Pricelist') }}</label>
                                    <select wire:model.live="id_pricelist" class="form-select @error('id_pricelist') is-invalid @enderror form-select-sm" name="id_pricelist" id="id_pricelist" @if ($flag || $flagImport) disabled @endif>
                                        <option value="">-- {{ __('Select Pricelist') }} --</option>
                                        @foreach($pricelist as $pl)
                                        <option value="{{ $pl->code }}">{{ $pl->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('id_pricelist')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col"></div>
                            </div>

                            @if ($tipe == 3)
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="bundling_benefit" class="form-label">{{ __('Benefit Type') }}</label>
                                    <select wire:model.live="bundling_benefit" class="form-control @error('bundling_benefit') is-invalid @enderror form-select-sm" id="bundling_benefit">
                                        <option value="">-- {{ __('Select Benefit Type') }} --</option>
                                        <option value="1">{{ __('Discount (%)') }}</option>
                                        <option value="2">{{ __('Special Price') }}</option>
                                    </select>
                                    @error('bundling_benefit')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($bundling_benefit == 1)
                                    <label for="bundling_benefit_disc" class="form-label">Discount (%)</label>
                                    <input type="number" wire:model.live="bundling_benefit_disc" class="form-control @error('bundling_benefit_disc') is-invalid @enderror form-control-sm" id="bundling_benefit_disc" max="100" min="0">
                                    @error('bundling_benefit_disc')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @elseif ($bundling_benefit == 2)
                                    <label for="bundling_benefit_price" class="form-label">Special Price</label>
                                    <input type="number" wire:model.live="bundling_benefit_price" class="form-control @error('bundling_benefit_price') is-invalid @enderror form-control-sm" id="bundling_benefit_price" min="0">
                                    @error('bundling_benefit_price')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @endif
                                </div>
                            </div>

                            @elseif ($tipe == 4 || $tipe == 5)
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="gwp_benefit" class="form-label">{{ __('Benefit Type') }}</label>
                                    <select wire:model.live="gwp_benefit" class="form-control @error('gwp_benefit') is-invalid @enderror form-select-sm" id="gwp_benefit">
                                        <option value="">-- {{ __('Select Benefit Type') }} --</option>
                                        <option value="1">{{ __('Free Item') }}</option>
                                        <option value="2">{{ __('Free Cheapest Item') }}</option>
                                        <option value="3">{{ __('Voucher') }}</option>
                                    </select>
                                    @error('gwp_benefit')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    @if ($gwp_benefit == 3)
                                    <label for="gwp_benefit_voucher" class="form-label">Voucher Value</label>
                                    <input type="number" wire:model.live="gwp_benefit_voucher" class="form-control @error('gwp_benefit_voucher') is-invalid @enderror form-control-sm" id="gwp_benefit_voucher" max="100" min="0">
                                    @error('gwp_benefit_voucher')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @endif
                                </div>
                            </div>

                            @if ($gwp_benefit == 1)
                            <div class="row mt-3">
                                <label for="gwp_benefit_item" class="form-label">Item</label>
                                <div class="col-auto">
                                    <input type="text" wire:model.live="gwp_benefit_item" id="gwp_benefit_item" class="form-control form-control-sm @error('gwp_benefit_item') is-invalid @enderror" style="min-width: 20rem" placeholder="Input ItemCode or CodeBars">
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-auto mb-2">
                                    <a type="button" class="btn btn-primary btn-sm" wire:click.prevent="gwp_benefit_item_get">Get Item</a>
                                </div>
                            </div>

                            <livewire:promo.promo-gwp-item />
                            @endif
                            @endif

                            @if ($add)
                            <a type="button" class="btn btn-primary btn-sm mt-3" wire:click.prevent="detail">Input Item Promo</a>
                            <a type="button" class="btn btn-success btn-sm mt-3" wire:click.prevent="detailImport">Import Item Promo</a>
                            <!-- <a type="button" class="btn btn-success btn-sm mt-3" data-bs-toggle="modal" data-bs-target="#importModal">Import Item</a> -->
                            @endif
                            @endif
                        </form>
                    </div>
                </div>
            </div>

            @if ($flag)
            @if ($tipe == 1 || $tipe == 2)
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Input Item Promo') }}</h6>
                        </div>

                        <form>
                            @csrf
                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="search_by" class="form-label">{{ __('Search by') }}</label>
                                    <select wire:model.live="search_by" class="form-control form-select-sm" id="search_by">
                                        <option value="1">{{ __('ItemCode') }}</option>
                                        <option value="2">{{ __('CodeBars') }}</option>
                                    </select>
                                </div>
                                <div class="col"></div>
                            </div>

                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <label for="item_code" class="form-label">ItemCode</label>
                                    <div class="input-group">
                                        <input type="text" wire:model.live="item_code" class="form-control @error('item_code') is-invalid @enderror form-control-sm" id="item_code" @if ($search_by==2) disabled @endif>
                                        @if ($search_by == 1)
                                        @if ($search_code)
                                        <button type="button" class="btn btn-primary btn-sm" disabled>
                                            <div class="spinner-border spinner-border-sm text-light" role="status"></div>
                                            Search
                                        </button>
                                        @else
                                        <button wire:click.live.prevent="searchFlagTrue" type="button" class="btn btn-primary btn-sm">Search</button>
                                        @endif
                                        @endif
                                    </div>
                                    @error('item_code')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col">
                                    <label for="item_barcode" class="form-label">CodeBars</label>
                                    <div class="input-group">
                                        <input type="text" wire:model.live="item_barcode" class="form-control form-control-sm" id="item_barcode" @if ($search_by==1) disabled @endif>
                                        @if ($search_by == 2)
                                        @if ($search_barcode)
                                        <button type="button" class="btn btn-primary btn-sm" disabled>
                                            <div class="spinner-border spinner-border-sm text-light" role="status"></div>
                                            Search
                                        </button>
                                        @else
                                        <button wire:click.live.prevent="searchFlagTrue" type="button" class="btn btn-primary btn-sm">Search</button>
                                        @endif
                                        @endif
                                    </div>
                                    @error('item_barcode')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="item_name" class="form-label">ItemName</label>
                                <input type="text" wire:model.live="item_name" class="form-control form-control-sm" id="item_name" disabled>
                            </div>

                            <div class="mb-3 form-group row">
                                <div class="col">
                                    <div class="mb-3">
                                        <label for="item_nprice" class="form-label">Price</label>
                                        <input wire:model.live="item_nprice" class="form-control form-control-sm" id="item_nprice" x-mask:dynamic="$money($input, '.')" disabled>
                                    </div>
                                </div>

                                <div class="col">
                                    @if ($tipe == 1)
                                    <div class="mb-3">
                                        <label for="item_disc" class="form-label">Discount (%)</label>
                                        <input wire:model.live="item_disc" class="form-control @error('item_disc') is-invalid @enderror form-control-sm" id="item_disc" x-mask:dynamic="$money($input, '.')" @if ($item_code=='' ) disabled @endif>
                                        @error('item_disc')
                                        <span class=" text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @else
                                    <div class="mb-3">
                                        <label for="item_price" class="form-label">Special Price</label>
                                        <input wire:model.live="item_price" class="form-control @error('item_price') is-invalid @enderror form-control-sm" id="item_price" x-mask:dynamic="$money($input, '.')">
                                        @error('item_price')
                                        <span class=" text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <div class="mb-3">
                                <input type="checkbox" wire:model.live="item_qty_check" class="form-check-input" id="item_qty_check">
                                @if ($tipe == 1)
                                <label for="item_qty_check" class="form-check-label">{{ __('Input Discount (%) by Qty') }}</label>
                                @else
                                <label for="item_qty_check" class="form-check-label">{{ __('Input Special Price by Qty') }}</label>
                                @endif
                            </div>

                            @if ($item_qty_check)
                            <div class="mb-3">
                                @if ($tipe == 1)
                                <div class="mb-3 form-group row">
                                    <div class="col">
                                        <label for="item_qty_qty" class="form-label">Qty</label>
                                        <div class="input-group">
                                            <input wire:model.live="item_qty_qty" class="form-control form-control-sm" id="item_qty_qty" x-mask:dynamic="$money($input, '.')">
                                            @error('item_qty_qty')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col">
                                        <label for="item_qty_disc" class="form-label">Discount (%)</label>
                                        <div class="input-group">
                                            <input wire:model.live="item_qty_disc" class="form-control form-control-sm" id="item_qty_disc" x-mask:dynamic="$money($input, '.')">
                                            @error('item_qty_disc')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            <a type="button" class="btn btn-primary btn-sm" wire:click.prevent="addQty">Add</a>
                                        </div>
                                    </div>
                                </div>
                                <livewire:promo.promo-add-item-qty-disc :tipe="$tipe" :item_code="$item_code" />
                                @else
                                <h4 class="card-title" style="color: #1266AB">{{ __('Special Price by Qty') }}</h6>
                                    @endif
                            </div>
                            @endif

                            <a type="button" class="btn btn-primary btn-sm mt-3" wire:click.prevent="addList">Add to List</a>
                            <a type="button" class="btn btn-secondary btn-sm mt-3" wire:click.prevent="clearItem">Clear</a>
                        </form>
                    </div>
                </div>
            </div>
            @endif
            @endif

            @if ($flagImport)
            @if ($tipe == 1 || $tipe == 2)
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Import Item Promo') }}</h6>
                        </div>

                        <div class="mb-3">
                            <label for="file" class="form-label">Promo Detail</label>
                            <input wire:model="file" type="file" class="form-control @error('file') is-invalid @enderror form-control-sm mt-3" id="importFile" name="importFile" accept=".csv">
                            @error('file')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        @if ($import)
                        <button type="button" class="btn btn-primary btn-sm" disabled>
                            <div class="spinner-border spinner-border-sm text-light" role="status"></div>
                            {{ __('Import') }}
                        </button>
                        @else
                        <button wire:click="importFlagTrue" class="btn btn-primary btn-sm mt-3">{{ __('Import') }}</button>
                        @endif
                    </div>
                </div>
            </div>
            @endif
            @endif
        </div>

        @if ($flag)
        @if ($tipe == 1)
        <div class="row mt-3">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h4 class="card-title" style="color: #1266AB">{{ __('Promo Detail') }}</h6>
                        </div>

                        <livewire:promo.promo-add-table :tipe="$tipe" />
                    </div>
                </div>
            </div>
        </div>
        @endif
        @endif
    </div>

    <!-- modal import -->

    <div wire:ignore.self class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="importModalLabel">{{ __('Import Item') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">{{ __('Browse promo template file') }}</div>
                    <div class="mb-4 form-group row">
                        <input wire:model="file" type="file" class="form-control @error('file') is-invalid @enderror form-control-sm" id="importFile" name="importFile" accept=".csv">
                        @error('file')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button id="closeButton" type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Close') }}</button>
                    @if ($import)
                    <button type="button" class="btn btn-primary btn-sm" disabled>
                        <div class="spinner-border spinner-border-sm text-light" role="status"></div>
                        {{ __('Import') }}
                    </button>
                    @else
                    <button wire:click="importFlagTrue" class="btn btn-primary btn-sm">{{ __('Import') }}</button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@livewireScripts

<script>
    Livewire.on('toast-add-success', () => {
        toastr.clear();
        toastr.success('Promo has been successfully added');
    });

    Livewire.on('toast-add-error', () => {
        toastr.clear();
        toastr.success('Promo failed to add');
    });

    Livewire.on('focusNextTabDisc', () => {
        document.getElementById('item_disc').focus();
    });

    Livewire.on('focusNextTabPrice', () => {
        document.getElementById('item_price').focus();
    });

    Livewire.on('closeModal', function() {
        document.getElementById('closeButton').click();
    });
</script>