<div wire:ignore.self>
    <div class="card p-2">
        <div class="card-body">
            <form wire:submit.prevent="{{ $edit ? 'saveEditUDF' : 'createUDF' }}">
                @if ($edit)
                    <div class="fs-4 fw-semibold mb-3">Edit UDF</div>
                @else
                    <div class="fs-4 fw-semibold mb-3">Create UDF</div>
                @endif

                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" id="name" wire:model="name" class="form-control" required>
                    @error('name')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
        
                <div class="form-group">
                    <label for="field">Field</label>
                    <input type="text" id="field" wire:model="field" class="form-control" required>
                    @error('field')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="type">Type</label>
                    <select id="type" wire:model="type" class="form-control" required>
                        <option value="text">Text</option>
                        <option value="number">Number</option>
                    </select>
                    @error('type')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
        
                <div class="form-group mt-2">
                    <label>Active</label><br>
                    <label>
                        <input type="radio" wire:model="active" value="Y"> Yes
                    </label>
                    <label>
                        <input type="radio" wire:model="active" value="N"> No
                    </label>
                </div>
        
                <button type="submit" class="btn btn-primary mt-3">{{ $edit ? 'Update UDF' : 'Create UDF' }}</button>
                @if($edit)
                <button type="button" class="btn btn-secondary mt-3" wire:click="cancelEditUDF">Cancel Edit</button>
                @endif
            </form>
        </div>
        
    </div>
   
    <div class="card mt-4 p-4" style="max-height: 400px; overflow-y: auto; overflow-x: hidden;">
        <div class="fs-4 fw-semibold mb-3">UDF list</div>
        <table id="example" class="my-table mt-2" style="width:100%">
            <thead>
                <tr>
                    <th style="border-top-left-radius: 1rem">Code</th>
                    <th>Name</th>
                    <th>Field</th>
                    <th>Type</th>
                    <th>Active</th>
                    <th style="border-top-right-radius: 1rem">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($udfs as $udf)
                    <tr>
                        <td>{{ $udf->code }}</td>
                        <td>{{ $udf->name }}</td>
                        <td>{{ $udf->type }}</td>
                        <td>{{ $udf->field }}</td>
                        <td onclick="handleUDFStatusChange('{{ $udf->code }}')" style="cursor: pointer;">
                            <span class="badge" 
                                style="{{ $udf->active === 'Y' ? 'background-color: #50c87825; color: #3fca6d;' : 'background-color: #eb586e31; color: #e93a54;' }}">
                                {{ $udf->active === 'Y' ? 'Yes' : 'No' }}
                            </span>

                        </td>
                        <td>
                            <button class="btn btn-sm" style="background: #00000015;" onclick="handleEditUDF('{{ $udf->code }}')">
                                <div style="width: 17px"> 
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                      </svg>
                                </div>
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@livewireScripts()
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });

function handleUDFStatusChange(code) {
    Livewire.dispatch('changeStatusUDF', {
        code: code,
    });
}

function handleEditUDF(code) {
    Livewire.dispatch('editUDF', {
        code: code,
    });
}
</script>
