<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Goods Return') }} @admin All Store @else {{ userWarehouse() }} @endadmin
                    </li>
                </ol>
            </div>
        </nav>
        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="button-top-right">
                    <button wire:keydown.window.shift.n="toCreatePO" wire:click="toCreatePO" type="button"
                        class="btn btn-primary btn-sm ml-4 create-new-goods-return-pop">{{ __('Create Goods Return') }}</button>
                </div>
                <div class="card-body">
                    <div class="py-12">
                       
                        <div class="table-responsive table-salesemp">
                            <div class="mb-3 d-flex justify-content-between">
                                <div class="d-flex align-items-center">
                                    <label class="me-2">Show</label>
                                    <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                        <option value="10">10</option>
                                        <option value="20">20</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                    <label class="">entries</label>
                                </div>
                                <div class="d-flex align-items-center">
                                    <label class="me-2">Search</label>
                                    <input wire:model.live="search" type="text" class="form-control form-control-sm" 
                                        placeholder="Search">
                                </div>
                            </div>
                            <table class="my-table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th style="text-align: center; border-top-left-radius: .5rem;" scope="col">#</th>
                                        <th style="text-align: center;" scope="col">{{ __('Action') }}</th>
                                        <th style="text-align: center;" scope="col">
                                            <div wire:click="sortBy('whs_name')" style="cursor: pointer">
                                                {{ __('Store') }}
                                                @if($sortField === 'whs_name')
                                                    @if($sortDirection === 'asc')
                                                        ↑
                                                    @else
                                                        ↓
                                                    @endif
                                                @endif
                                            </div>
                                        </th>
                                        <th style="text-align: center;" scope="col">
                                            <div wire:click="sortBy('date')" style="cursor: pointer">
                                                {{ __('Date') }}
                                                @if($sortField === 'date')
                                                    @if($sortDirection === 'asc')
                                                        ↑
                                                    @else
                                                        ↓
                                                    @endif
                                                @endif
                                            </div>
                                        </th>
                                        <th style="text-align: center;" scope="col">
                                            <div wire:click="sortBy('name')" style="cursor: pointer">
                                                {{ __('Supplier') }}
                                                @if($sortField === 'name')
                                                    @if($sortDirection === 'asc')
                                                        ↑
                                                    @else
                                                        ↓
                                                    @endif
                                                @endif
                                            </div>
                                        </th>
                                        <th style="text-align: center;" scope="col">{{ __('Remark') }}</th>
                                        <th style="text-align: center;" scope="col">
                                            <div wire:click="sortBy('qty')" style="cursor: pointer">
                                                {{ __('Qty') }}
                                                @if($sortField === 'qty')
                                                    @if($sortDirection === 'asc')
                                                        ↑
                                                    @else
                                                        ↓
                                                    @endif
                                                @endif
                                            </div>
                                        </th>
                                        <th style="text-align: center; border-top-right-radius: .5rem;" scope="col">
                                            <div wire:click="sortBy('total')" style="cursor: pointer">
                                                {{ __('Total') }}
                                                @if($sortField === 'total')
                                                    @if($sortDirection === 'asc')
                                                        ↑
                                                    @else
                                                        ↓
                                                    @endif
                                                @endif
                                            </div>
                                        </th>
                                    </tr>
                                </thead>

                                <tbody class="small">
                                    @forelse($purchase as $key => $item)
                                        <tr>
                                            <td scope="col">{{ $purchase->firstItem() + $key }}</td>
                                            <td> <button class="btn btn-primary content-end goodsReturn-detail-pop"
                                                    style="padding: 2.5px 5px; font-size: 12px;">
                                                    <a href="/purchase-return/detail/{{ $item->no }}"
                                                        style="text-decoration:none; color:white;">Detail</a></button>
                                                <button type="button" class="btn btn-danger content-end delete-promo"
                                                    style="padding: 5px 10px; font-size: 12px;"
                                                    @admin data-bs-toggle="modal"
                                                        data-bs-target="#deleteModal"
                                                    onclick="handleremoveItem('{{ $item->no }}')" @else disabled
                                                    @endadmin>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="15"
                                                        height="15" fill="currentColor" class="bi bi-trash"
                                                        viewBox="0 0 16 16">
                                                        <path
                                                            d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                                        <path
                                                            d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                                                    </svg>
                                                </button>
                                            </td>
                                            <td>{{ $item->whs_name ?? '-' }}</td>
                                            <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->remark }}</td>
                                            <td>{{ $item->qty }}</td>
                                            <td>
                                                {{ 'Rp. ' . number_format($item->total, 0, ',', '.') }}
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">No records found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">
                            {{ $purchase->links() }}
                        </div>
                        <table class="table dataTables_wrapper dt-bootstrap5 mt-2" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>
                                </tr>
                            </thead>

                            <tbody class="small">
                                <td>Total</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="text-align: right;">{{ number_format($totalSumQty, 0, ',', ',') }}</td>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @admin
        <!-- modal delete -->
        <div wire:ignore.self class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">
                            {{ __('Confirmation') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        {{ __('Are you sure you want to delete this Good Receipt with No: ') }}
                        {{ $noGR }}
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal">{{ __('Close') }}</button>
                        <button wire:click="deleteGR" class="btn btn-danger">{{ __('Delete') }}</button>
                    </div>
                </div>
            </div>
        </div>
    @endadmin
</div>
@livewireScripts
<script>
     function handleremoveItem(no) {
        Livewire.dispatch('removeItem', {
            no: no
        });
    }

    Livewire.on('openModalDel', () => {
        $('#deleteModal').modal('show');
    });
    Livewire.on('closeModalDel', () => {
        $('#deleteModal').modal('hide');
    });

    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 500);
    });
</script>
