<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="{{ route('pr.index') }}">{{ __('Goods Return') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Create') }}
                    </li>
                </ol>
            </div>
        </nav>
        <div class="" id="cashier">
            <div class="col-sm-4 col-md-4 col-lg-3 mt-2">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="dateInput">Date</label>

                        <input type="date" class="form-control rounded" id="dateInput" wire:model.live="date"
                            placeholder="Choose Date" autocomplete="off">
                    </div>
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3 mt-2" x-data="{ selectedIndexSupplier: null }" x-init="selectedIndexSupplier = -1">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="searchSupplierInput">Supplier</label>
                        <input type="text" class="form-control rounded"
                            wire:model.debounce.100ms.live="searchsupplier" id="searchSupplierInput"
                            placeholder="Select Supplier"
                            @keydown.arrow-down.prevent="selectedIndexSupplier = Math.min(selectedIndexSupplier + 1, 10)"
                            @keydown.arrow-up.prevent="selectedIndexSupplier = Math.max(selectedIndexSupplier - 1, -1)"
                            x-on:keydown.enter="
                        if(selectedIndexSupplier == -1) {
        
                        }else{
                            $wire.selectSupplier(selectedIndexSupplier);
                            selectedIndexSupplier = -1;
                        }"
                            autocomplete="off">
                    </div>
                    @if ($selectedSupplier === null)
                        @if ($results)
                            <div class="dropdown-menu d-block py-0">
                                @foreach ($results as $index => $supplier)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexSupplier === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link"
                                                :class="{ 'text-white': selectedIndexSupplier === {{ $index }} }"
                                                wire:click="selectSupplierByClick('{{ $supplier->code }}')">
                                                {{ $supplier->code }} || {{ $supplier->name }} || {{ $supplier->email }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    @endif
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3 mt-2">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="textAreaInput">Remarks</label>
                        <textarea class="form-control rounded" id="textAreaInput" placeholder="Enter details" rows="1"
                            style="width: 500px;" wire:model.live="remarks" autocomplete="off"></textarea>
                        @error('remarks')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            @if ($selectedSupplier)
                <div class="row mt-2">
                    {{-- <div class="col-sm-4 col-md-4 col-lg-3">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="inpotNoPo">No PO</label>
                            <input class="form-control rounded" id="inputNoPo" wire:model.live="no"
                                autocomplete="off">
                            @error('no')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>

                    </div>
                </div> --}}
                    <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
                        <div class="form-group">
                            <div class="d-flex" style="flex-direction: column">
                                <label for="searchItemInput">Store</label>
                                <input type="text" class="form-control rounded"
                                    wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                                    placeholder="Search Store"
                                    @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                                    @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                                    x-on:keydown.enter="
                    if(selectedIndexWarehouse == -1) {
    
                    }else{
                        $wire.selectWarehouse(selectedIndexWarehouse);
                        selectedIndexWarehouse = -1;
                    }"
                                autocomplete="off" @admin @else disabled
                                @endadmin>
                        </div>
                        @if ($selectedWarehouse === null)
                            @if ($resultwarehouse)
                                <div class="dropdown-menu d-block py-0">
                                    @foreach ($resultwarehouse as $index => $item)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                                    wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                                    {{ $item->code }} || {{ $item->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexItem: null }" x-init="selectedIndexItem = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">Item</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchitem" id="searchItemInput"
                                placeholder="Select Item"
                                @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexItem == -1) {
                    $wire.selectItemByName();

                    }else{
                        $wire.selectItem(selectedIndexItem);
                        selectedIndexItem = -1;
                    }"
                                autocomplete="off">
                        </div>
                        @if ($selectedItem === null)
                            @if ($resultitem)
                                <div class="dropdown-menu d-block py-0">
                                    @foreach ($resultitem as $index => $item)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexItem === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexItem === {{ $index }} }"
                                                    wire:click="selectItemByClick('{{ $item->code }}')">
                                                    {{ $item->code }} || {{ $item->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card-body">
                        <div class="py-12">
                            <div class="table-responsive head-table-no-suggestion">
                                {{-- <table id="example" --}}
                                <table class="my-table" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col">{{ __('Code') }}</th>
                                            <th scope="col">{{ __('Barcode') }}</th>
                                            <th scope="col">{{ __('Name') }}</th>
                                            <th scope="col">{{ __('Qty') }}</th>
                                            <th scope="col">{{ __('Price') }}</th>
                                            <th scope="col">{{ __('Sub Total') }}</th>
                                            <th scope="col" style="border-top-right-radius: 1rem">
                                                {{ __('Action') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="small">
                                        @forelse ($tableItems as $index => $item)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $item['code'] }}</td>
                                                <td>{{ $item['barcode'] }}</td>
                                                <td>{{ $item['name'] }}</td>
                                                <td>
                                                    <div x-data="{ quantity: 1 }"
                                                        style="display: flex; align-items: center; gap: 5px;">

                                                        <input type="number" x-model.number="quantity"
                                                            x-on:input="quantity = quantity < 0 ? 0 : quantity || 0; $wire.set('tableItems.{{ $index }}.quantity', quantity)"
                                                            x-on:keydown="if ($event.key === 'Backspace' && quantity === 0) $event.preventDefault()"
                                                            class="form-control" min="0" id="numberInput"
                                                            wire:model.live="tableItems.{{ $index }}.quantity"
                                                            style="flex: 3;">

                                                        <select class="form-control input-group" id="type"
                                                            wire:model.live="tableItems.{{ $index }}.unit"
                                                            style="flex: 1;">
                                                            <option value="0">pcs</option>
                                                            @foreach ($item['units'] as $unit)
                                                                <option value="{{ $unit->id }}">
                                                                    {{ $unit->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div x-data="{ price: 0 }">
                                                        <input type="number" x-model.number="price"
                                                            x-on:input="price = price < 0 ? 0 : price || 0; $wire.set('tableItems.{{ $index }}.price', price)"
                                                            x-on:keydown="if ($event.key === 'Backspace' && price === 0) $event.preventDefault()"
                                                            class="form-control" min="0" id="inputPrice"
                                                            wire:model.live="tableItems.{{ $index }}.price"
                                                            @if($item['consignment'] == 'Y') disabled @endif>
                                                            
                                                    </div>
                                                </td>
                                                @if (!empty($item['price']) && $item['price'] !== 0)
                                                    <td>Rp.
                                                        {{ number_format($item['price'] * $item['quantity'], 0, ',', '.') }}
                                                    </td>
                                                @else
                                                    <td>Rp. 0</td>
                                                @endif
                                                <td>
                                                    <button type="button"
                                                        onclick="handleremoveItem('{{ $index }}');"
                                                        class="btn btn-danger btn-sm">Delete</button>
                                                </td>
                                            </tr>
                                        @empty
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <div wire:ignore.self>
                                <table id="table" class="table dataTables_wrapper dt-bootstrap5 text-white"
                                    style="width:100%; ">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>

                                            <th scope="col"></th>
                                            <th scope="col"></th>
                                            <th scope="col"></th>

                                            <th scope="col" colspan="4"></th>
                                            <th scope="col" style="text-align: right;">{{ __('Total Qty') }}
                                            </th>

                                            <th scope="col" style="text-align: right;">{{ __('Grand Total') }}
                                            </th>
                                        </tr>
                                    </thead>

                                    <tbody class="small">

                                        <tr>
                                            <td colspan="2">Total</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td colspan="4"></td>
                                            <td style="text-align: right;">
                                                {{ number_format(array_sum(array_column($tableItems, 'qtypcs')), 0, ',', '.') }}
                                            </td>
                                            <td style="text-align: right;">
                                                Rp.
                                                {{ number_format(
                                                    array_sum(
                                                        array_map(function ($item) {
                                                            return $item['quantity'] * $item['price'];
                                                        }, $tableItems),
                                                    ),
                                                    0,
                                                    ',',
                                                    '.',
                                                ) }}
                                            </td>



                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end mt-4">
                <button wire:click="savetoTable" class="btn btn-primary"
                    @if (!$tableItems) disabled @endif>Save</button>
            </div>

        @endif
    </div>

</div>
@livewireScripts()
<script>
    function handleremoveItem(index) {
        Livewire.dispatch('removeItem', {
            index: index
        });
    }

    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 1000);
    });

    document.addEventListener('keydown', function(event) {
        if (event.key === 'F1') {
            event.preventDefault();
            document.getElementById('dateInput').focus();
        }
        if (event.key === 'F2') {
            event.preventDefault();
            document.getElementById('searchSupplierInput').focus();
        }
        if (event.key === 'F3') {
            event.preventDefault();
            document.getElementById('textAreaInput').focus();
        }
    });

    Livewire.on('activeF4', (params) => {
        document.addEventListener('keydown', function(event) {
            if (event.key === 'F4') {
                event.preventDefault();
                const activeElement = document.activeElement;

                if (activeElement.id === 'searchWarehouseInput') {
                    document.getElementById('searchItemInput').focus();
                } else if (activeElement.id === 'searchItemInput') {
                    document.getElementById('searchWarehouseInput').focus();
                } else {
                    const searchWarehouse = document.getElementById('searchWarehouseInput');
                    if (!searchWarehouse.disabled) {
                        searchWarehouse.focus();
                    } else {
                        document.getElementById('searchItemInput')
                            .focus();
                    }
                }
            }
        });
    });
</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>
