<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Compare SO') }}
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Result') }}
                    </li>
                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin">
                <div class="button-top-right">
                    {{-- <button type="button" wire:click="export" class="btn btn-primary btn-sm ml-4">Export
                        Difference</button>
                    <button type="button" wire:click="exportNoDiff" class="btn btn-primary btn-sm ml-4">Export No
                        Difference</button> --}}
                    <button wire:click="save" type="button"
                        class="btn btn-success btn-sm ml-4" wire:click="save">{{ __('Save') }}</button>
                    <button wire:click="close" type="button"
                        class="btn btn-secondary btn-sm ml-4">{{ __('Close') }}</button>
                </div>
                <div class="">
                    <div class="card p-3 mb-3">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title">{{ __('Compare SO Result') }}</h6>
                        </div>
                        <div class="d-flex align-items-center small">
                            <h6 class="card-title text-secondary mb-0">{{ __('Toko : ') }}</h6>
                            <div class="mx-1 form-group ml-2 flex-grow-1">
                                <div class="col-sm-2" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
                                    <input type="text" class="form-control form-control-sm rounded"
                                        wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                                        placeholder="Search Store"
                                        @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                                        @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                                        x-on:keydown.enter="
                                               if(selectedIndexWarehouse == -1) {
                                                   
                                               } else {
                                                   $wire.selectWarehouse(selectedIndexWarehouse);
                                                   selectedIndexWarehouse = -1;
                                               }"
                                        autocomplete="off" @if (Auth::user()->whs_code != '-') disabled @endif>
                                    @error('selectedWarehouse')
                                        <small class="text-danger d-block mt-1"> {{ $message }}</small>
                                    @enderror

                                    @if ($selectedWarehouse === null && $resultwarehouse)
                                        <div class="dropdown-menu d-block py-0 mt-0">
                                            @foreach ($resultwarehouse as $index => $item)
                                                <div class="px-2 py-1 border-bottom"
                                                    :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                                    <div class="d-flex flex-column ml-3">
                                                        <button type="button" class="btn btn-link"
                                                            :class="{
                                                                'text-white': selectedIndexWarehouse ===
                                                                    {{ $index }}
                                                            }"
                                                            wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                                            {{ $item->code }} || {{ $item->name }}
                                                        </button>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mt-1">
                            <h6 class="card-title text-secondary">{{ __('Date : ') }}
                                <input type="date" wire:model.live="date"
                                    class="form-control-sm rounded border-1">
                            </h6>
                        </div>
                        <div class="d-flex align-items-center small mt-1">
                            <h6 class="card-title text-secondary mb-0">{{ __('Remark : ') }}</h6>
                            <div class="ml-2 flex-grow-1">
                                <textarea class="mx-1 form-control form-control-sm rounded" id="textAreaInput" placeholder="Enter details"
                                    rows="1" style="min-width: 200px; max-width: 500px;" wire:model.live="remarks" autocomplete="off"></textarea>
                                @error('remarks')
                                    <small class="text-danger d-block mt-1"> {{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                        <div class="mt-1 d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Type : ') }} <span
                                    class="">{{ $opnameh->type ?? '' }}</span></h6>
                        </div>
                    </div>

                    <div>
                        <div class="py-12">
                            <div class="table-responsive table-opname-result">
                                {{-- <table id="example" --}}
                                <table id=""
                                    class="my-table dataTables_wrapper dt-bootstrap5"
                                    style="width:100%; ">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col">{{ __('Code') }}</th>
                                            <th scope="col">{{ __('Barcode') }}</th>
                                            <th scope="col">{{ __('Name') }}</th>
                                            <th scope="col">{{ __('Price') }}</th>
                                            <th scope="col">{{ __('Qty') }}</th>
                                            <th scope="col">{{ __('Opname') }}</th>
                                            <th scope="col" style="border-top-right-radius: 1rem">
                                                {{ __('Difference') }}</th>

                                        </tr>
                                    </thead>

                                    <tbody class="small">
                                        @foreach ($opnames as $key => $opname)
                                            <tr>
                                                <th scope="col">{{ $key + 1 }}</td>
                                                <td>{{ $opname->item_code }}</td>
                                                <td>{{ $opname->item_barcode }}</td>
                                                <td>{{ $opname->item_name }}</td>
                                                <td>{{ number_format($opname->price) }}</td>
                                                <td>{{ number_format($opname->qty) }}</td>
                                                <td>
                                                    <div>
                                                        <input type="number" id="quantityInput"
                                                            value="{{ $quantities[$key] }}"
                                                            class="form-control p-0 border-0" onfocus="handleFocus()"
                                                            style="width: 50px;" oninput="handleInput(this.value)"
                                                            onblur="handleBlur({{ $key }}, '{{ $opname->item_code }}', this.value)">
                                                    </div>
                                                </td>


                                                <td>{{ number_format($opname->difference) }}</td>


                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    @livewireScripts()
    <script>
        function handleFocus() {
            // Example: Add focus handling if needed
        }

        // Function to handle input value change
        function handleInput(value) {
            updateBackend(index, code, value);
        }

        // Function to handle input blur (when user leaves the input field)
        function handleBlur(index, code, value) {
            // Example: Perform backend update via AJAX or any other method
            updateBackend(index, code, value);
        }

        function updateBackend(index, code, value) {
            Livewire.dispatch('updateQuantity', {
                index: index,
                code: code,
                value: value,
            });
        }

        Livewire.on('refreshDatatable', (params) => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        });
    </script>
</div>
