<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Compare SO') }}
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Input') }}
                    </li>
                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="d-flex justify-content-end">
                @if ($isloading)
                    <button wire:click="firstClick" type="button" class="btn btn-primary btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                            aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>
                @else
                    <button wire:click="firstClick" type="button"
                        class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4"
                        @if (!$cancreateSo) disabled @endif>{{ __('Import') }}</button>
                @endif
            </div>
            <div class="col-md-6" style="padding-top: 2rem">
                <div class="card p-lg-4 rounded-5">
                    <div class="card-body" style="font-weight: bolder; font-size: medium;">
                        <div
                            class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-3">
                            <h6 class="card-title" style="font-size: large; font-weight: bold">
                                {{ __('Compare SO Input') }}</h6>
                        </div>

                        @admin
                            <div class="mb-4">
                                <label for="warehouse" class="form-label">{{ __('Toko') }}</label>
                                <select wire:model="whs_code" class="form-select form-select-md opname-input" style="border-radius: 2rem" id="warehouse"
                                    name="warehouse">
                                    <option value="">-- Select Store --</option>

                                    @foreach ($warehouse as $item)
                                        <option value="{{ $item->code }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endadmin

                        <form class="mb-5">
                            <div class="mb-4">
                                <label for="soType" class="form-label">{{ __('Opname Type') }}</label>
                                <select wire:model="type" class="form-select form-select-md opname-input" id="soType"
                                    name="soType">
                                    <option value="Global">{{ __('Global') }}</option>
                                    <option value="Partial">{{ __('Partial') }}</option>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label for="compareDate" class="form-label">{{ __('Stock Date') }}</label>
                                <input wire:model="period" type="date" class="form-control form-control-md"
                                    id="compareDate" name="compareDate" data-toggle="datepicker">
                            </div>

                            <div class="mb-4">
                                <label for="importFile" class="form-label">{{ __('Import File Opname (*.csv, *.xlsx)') }}
                                </label>
                                <a wire:click="downloadTemplate"
                                    class="text-decoration-none badge bg-primary top-0 end-0"
                                    style="cursor: pointer;">Example</a>
                                <input wire:model="file" type="file"
                                    class="form-control @error('file') is-invalid @enderror form-control-md"
                                    id="importFile" name="importFile" accept=".csv,.xlsx">
                                @error('file')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    
        document.addEventListener('keydown', function(event) {
            if (event.key === 'F1') {
                event.preventDefault();
                document.getElementById('warehouse').focus();
            }
            if (event.key === 'F2') {
                event.preventDefault();
                document.getElementById('soType').focus();
            }
            if (event.key === 'F3') {
                event.preventDefault();
                document.getElementById('compareDate').focus();
            }
            if (event.key === 'F4') {
                event.preventDefault();
                document.getElementById('importFile').focus();
            }
        });

        document.addEventListener('livewire:navigated', () => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                $('#table').DataTable({
                    "bDestroy": true
                });
            });
        });
        
    </script>

</div>
