<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb align-items-center">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item d-flex align-items-center">
                        <span class="me-2">{{ __('Stock Opname') }} {{ userWarehouse() }}</span>
                    </li>
                </ol>

            </div>
        </nav>
        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="button-top-right">
                    <button wire:keydown.window.shift.n="toCreateSO" wire:click="toCreateSO" type="button"
                        class="btn btn-primary btn-sm ml-4"
                        @if (!$cancreateSo) disabled @endif>{{ __('Input SO') }}</button>
                </div>
                <div class="card-body">
                    <div class="py-12">
                        <div class="table-responsive table-salesemp">
                            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                        <th scope="col">{{ __('No') }}</th>
                                        <th scope="col">{{ __('Toko') }}</th>
                                        <th scope="col">{{ __('Date') }}</th>
                                        <th scope="col">{{ __('Remark') }}</th>
                                        <th scope="col">{{ __('Qty') }}</th>
                                        <th scope="col">{{ __('Opname') }}</th>
                                        <th scope="col">{{ __('Difference') }}</th>

                                        <th scope="col" style="border-top-right-radius: 1rem">{{ __('Action') }}
                                        </th>

                                    </tr>
                                </thead>

                                <tbody class="small">
                                    @forelse($stockopname as $key => $item)
                                        <tr>
                                            <td scope="col">{{ $loop->iteration }}</td>
                                            <th> {{ $item->no }}</th>
                                            <td>{{ $item->whs_name ?? '-' }}</td>
                                            <td>{{ \Carbon\Carbon::parse($item->date)->format('d F Y') }}</td>
                                            <td>{{ $item->remark }}</td>
                                            <td>{{ $item->qty }}</td>
                                            <td>{{ $item->opname }}</td>
                                            <td>{{ $item->difference }}</td>
                                            <td>
                                                <button id="detailButton"
                                                    class="detail-stock-pop mx-auto btn btn-primary content-end"
                                                    style="padding: 2.5px 5px; font-size: 12px;"
                                                    onclick="toDetail('{{ $item->no }}')">Detail</button>
                                                @if ($item->adjust == 'N')
                                                    <button class="mx-auto btn btn-danger content-end"
                                                        style="padding: 2.5px 5px; font-size: 12px;"data-bs-toggle="modal"
                                                        data-bs-target="#modalAdjust{{ $item->no }}">Not
                                                        Adjust</button>
                                                @else
                                                    <button class="mx-auto btn btn-success content-end"
                                                        style="padding: 2.5px 5px; font-size: 12px;"
                                                        disabled>Adjusted</button>
                                                @endif
                                                @if ($item->adjust == 'N')
                                                    <button class="mx-auto btn btn-warning content-end"
                                                        style="padding: 2.5px 5px; font-size: 12px;"
                                                        onclick="openDeleteModal('{{ $item->no }}')">Delete</button>
                                                @endif
                                            </td>

                                        </tr>
                                        <div wire:ignore.self class="modal fade" id="modalAdjust{{ $item->no }}"
                                            tabindex="-1" aria-labelledby="modalSyncLabel" aria-hidden="true"
                                            data-bs-backdrop="static">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="modalSyncLabel">Adjust Item</h5>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>Are you sure want Adjust the Item <span class="fw-bold">
                                                                {{ $item->no }} </span> ?</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary"
                                                            data-bs-dismiss="modal">Close</button>
                                                        <button type="button" class="btn btn-success"
                                                            wire:click="toAdjust('{{ $item->no }}')">Yes</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div wire:ignore.self class="modal fade" id="deleteConfirmModal" tabindex="-1"
                aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            Are you sure you want to delete? <strong id="deleteItemName"></strong> ?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="button" class="btn btn-danger" onclick="confirmDelete()"
                                data-bs-dismiss="modal">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @livewireScripts
    <script>
        let deleteCode = null;

        function openDeleteModal(no) {
            deleteCode = no;
            $('#deleteConfirmModal').modal('show');
            $('#deleteItemName').text(no);
        }

        function toDetail(no) {
            Livewire.dispatch('goToDetail', {
                no: no,
            });
        }

        Livewire.on('refreshDatatable', (params) => {
            setTimeout(() => {
                $(document).ready(function() {
                    $.fn.dataTable.ext.errMode = 'none';
                    new DataTable('#example', {
                        order: [],
                    });
                });
            }, 500);
        });

        Livewire.on('closeModal', (params) => {
            setTimeout(() => {
                $('#modalAdjust' + params).modal('hide');
            }, 500);
        });

        function confirmDelete() {
            if (deleteCode) {
                Livewire.dispatch('deleteSO', {
                    no: deleteCode,
                });
                deleteCode = null;
            }
        }
    </script>
