<div class="container mt-4">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="mb-0">{{ $isEditing ? 'Edit' : 'Add' }} DoH UDF</h4>
        </div>
        <div class="card-body">
            @if (session()->has('message'))
                <div class="alert alert-success">
                    {{ session('message') }}
                </div>
            @endif

            <div class="mb-3">
                <label for="warehouse" class="form-label">Warehouse</label>
                <select class="form-select @error('whs_code') is-invalid @enderror" wire:model.live="whs_code"
                    @if ($isEditing) disabled @endif>
                    <option value="">-- Select Warehouse --</option>
                    @foreach ($warehouses as $warehouse)
                        <option value="{{ $warehouse->code }}">{{ $warehouse->name }}</option>
                    @endforeach
                </select>
                @error('whs_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="brand" class="form-label">Brand</label>
                <select class="form-select @error('brand_code') is-invalid @enderror" wire:model.live="brand_code"
                    @if ($isEditing) disabled @endif>
                    <option value="">-- Select Brand --</option>
                    @foreach ($brands as $brand)
                        <option value="{{ $brand->code }}">{{ $brand->name }}</option>
                    @endforeach
                </select>
                @error('brand_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="category" class="form-label">Category</label>
                <select class="form-select @error('category_code') is-invalid @enderror" wire:model.live="category_code"
                    @if ($isEditing) disabled @endif>
                    <option value="">-- Select Category --</option>
                    @foreach ($categories as $category)
                        <option value="{{ $category->code }}">{{ $category->name }}</option>
                    @endforeach
                </select>
                @error('category_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="size" class="form-label">Size</label>
                <select class="form-select @error('size_code') is-invalid @enderror" wire:model.live="size_code"
                    @if ($isEditing) disabled @endif>
                    <option value="">-- Select Size --</option>
                    @foreach ($sizes as $size)
                        <option value="{{ $size->code }}">{{ $size->name }}</option>
                    @endforeach
                </select>
                @error('size_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="moh" class="form-label">Day on Hand</label>
                        <input type="number" class="form-control @error('moh') is-invalid @enderror"
                            wire:model.live="moh" min="0" step="1">
                        @error('moh')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="mdq" class="form-label">Min Display</label>
                        <input type="number" class="form-control @error('mdq') is-invalid @enderror"
                            wire:model.live="mdq" min="0" step="1">
                        @error('mdq')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between">
                <a href="{{ route('index-add-moh-udf') }}" class="btn btn-secondary">Back</a>

                @if ($isprocessing)
                    <button type="submit" class="btn btn-primary" disabled>
                        <div class="spinner-border spinner-border-sm" role="status"></div>
                        {{ $isEditing ? 'Update' : 'Create' }}
                    </button>
                @else
                    @if ($isEditing)
                        <button type="button" class="btn btn-primary" wire:click.prevent="checkData">Update</button>
                    @else
                        <button type="button" class="btn btn-primary"
                            onclick="Livewire.dispatch('bbb')">Create</button>
                    @endif
                @endif


            </div>
        </div>
    </div>

    <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true"
        data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addModalLabel">{{ __('Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    {{ __('Are you sure you want to add this moh udf??') }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button wire:click="checkData" type="submit" class="btn btn-danger">{{ __('Save') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>

@livewireScripts

<script>
    document.addEventListener('DOMContentLoaded', function() {
        Livewire.on('addModal', () => {
            $('#addModal').modal('show');
        });
    });
</script>
