<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4>DoH UDF Management</h4>
    </div>
    <div class="d-flex justify-content-end mb-3">
        <button class="btn btn-primary" wire:click="addMohUDF">Add DoH UDF</button>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                    <thead>
                        <tr>
                            <th scope="col" style="border-top-left-radius: 1rem">Warehouse</th>
                            <th scope="col">Code</th>
                            <th scope="col">Brand</th>
                            <th scope="col">Category</th>
                            <th scope="col">Size</th>
                            <th scope="col">DoH</th>
                            <th scope="col">MDQ</th>
                            <th scope="col" style="border-top-right-radius: 1rem">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($mohData as $item)
                            <tr>
                                <td>{{ $item->warehouse_name }} ({{ $item->warehouse_code }})</td>
                                <td>{{ $item->code }}</td>
                                <td>{{ $item->brand_name }} ({{ $item->brand_code }})</td>
                                <td>{{ $item->category_name }} ({{ $item->category_code }})</td>
                                <td>{{ $item->size_name }} ({{ $item->size_code }})</td>
                                <td>{{ $item->moh }}</td>
                                <td>{{ $item->mdq }}</td>
                                <td>
                                    <button class="btn btn-sm btn-primary"
                                        onclick="Livewire.dispatch('edit', { code: '{{ $item->code }}' })">
                                        Edit
                                    </button>
                                    {{-- <button class="btn btn-sm btn-danger"
                                        onclick="Livewire.dispatch('delete', { code: '{{ $item->code }}' })">
                                        Delete
                                    </button> --}}
                                    <a onclick="Livewire.dispatch('aaa', { code: '{{ $item->code }}' })"
                                        type="button" class="btn btn-danger content-end"
                                        style="padding: 5px 10px; font-size: 8px;" @D_SettingsSalesTarget disabled
                                        @endD_SettingsSalesTarget>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"
                                            fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16"
                                            style="color: white">
                                            <path
                                                d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                            <path
                                                d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                                        </svg>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">No records found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true"
        data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">{{ __('Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    {{ __('Are you sure you want to delete this moh udf?') }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button wire:click="delete('{{ $code }}')" type="submit"
                        class="btn btn-danger">{{ __('Delete') }}</button>
                </div>
            </div>
        </div>
    </div>
</div>

@livewireScripts

<script>
    document.addEventListener('DOMContentLoaded', function() {
        Livewire.on('deleteModal', () => {
            $('#deleteModal').modal('show');
        });
    });
</script>
