<div>
    <div class="py-12">
        <div class="table-responsive table-member-tablet member">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: 1rem;">#</th>
                        <th scope="col">{{ __('Code') }}</th>
                        <th scope="col">{{ __('Name') }}</th>
                        <th scope="col">{{ __('Hobby') }}</th>
                        <th scope="col">{{ __('Phone') }}</th>
                        <th scope="col">{{ __('Email') }}</th>
                        <th scope="col">{{ __('Address') }}</th>
                        <th scope="col">{{ __('Status') }}</th>

                        <th scope="col" style="border-top-right-radius: 1rem;">{{ __('Action') }}</th>
                    </tr>
                </thead>

                <tbody class="small">
                    @foreach ($members as $key => $member)
                        <tr wire:key="{{ $member->code }}">
                            <th scope="col">{{ $key + 1 }}</td>
                            <td>{{ $member->code }}</td>
                            <td>{{ $member->name }}</td>
                            <td>{{ $member->hobby }}</td>
                            <td>{{ $member->phone }}</td>
                            <td>{{ $member->email }}</td>
                            <td>{{ $member->address }}</td>
                            <td>
                                {{-- <button class="btn @if ($member->active == 'Y') btn-success @else btn-danger @endif badge" data-bs-toggle="modal" data-bs-target="#modalStatus{{ $member->code }}"> --}}
                                <div data-bs-toggle="modal">

                                    @if ($member->active == 'N')
                                        <div class="badge" style="background: #d8111128; color: #d81111;">
                                            Inactive
                                        </div>
                                    @else
                                        <div class="badge" style="background: #11d88c25; color: #00a868;">
                                            Active
                                        </div>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-primary"
                                    onclick="openEditModal(
        '{{ $member->code }}',
        '{{ $member->name }}',
        '{{ $member->phone }}',
        '{{ $member->email }}',
        `{{ $member->address }}`,
        '{{ $member->hobby }}'
    )">
                                    <div style="width: 17px">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                            <path
                                                d="M15.502 1.94a.5.5 0 0 1 0 .706L14.207 3.94l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4 10.146V12h1.854l7.898-7.604z" />
                                            <path fill-rule="evenodd"
                                                d="M1 13.5V3a2 2 0 0 1 2-2h6.5a.5.5 0 0 1 0 1H3a1 1 0 0 0-1 1v10.5a.5.5 0 0 1-.5.5H2a.5.5 0 0 1-.5-.5z" />
                                        </svg>
                                    </div>
                                </button>


                                <button class="btn btn-sm btn-danger"
                                    onclick="openDeleteModal('{{ $member->code }}', '{{ $member->name }}')">
                                    <div style="width: 17px">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                            <path
                                                d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                            <path
                                                d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                                        </svg>
                                    </div>
                                </button>

                            </td>
                        </tr>
                        <div wire:ignore.self class="modal fade" id="deleteConfirmModal" tabindex="-1"
                            aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Confirm Delete</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        Are you sure you want to delete? <strong id="deleteItemName"></strong> ?
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Cancel</button>
                                        <button type="button" class="btn btn-danger" onclick="confirmDelete()"
                                            data-bs-dismiss="modal">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div wire:ignore.self class="modal fade" id="editModal" tabindex="-1"
                            aria-labelledby="editModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Edit Member</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <form onsubmit="event.preventDefault(); confirmEdit();">
                                            <div class="mb-3">
                                                <label class="form-label">Name</label>
                                                <input type="text" id="editName" class="form-control">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Phone</label>
                                                <input type="text" id="editPhone" class="form-control">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Email</label>
                                                <input type="email" id="editEmail" class="form-control">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Address</label>
                                                <textarea id="editAddress" class="form-control" rows="2"></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Hobby</label>
                                                <input type="text" id="editHobby" class="form-control">
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <button class="btn btn-primary" onclick="confirmEdit()"
                                            data-bs-dismiss="modal">Save</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });

    function openDeleteModal(code, name) {
        deleteCode = code;
        document.getElementById('deleteItemName').textContent = name;

        $('#deleteConfirmModal').modal('show');

    }

    function confirmDelete() {
        if (deleteCode) {
            Livewire.dispatch('markAsDeleted', {
                code: deleteCode
            });
            deleteCode = null;
        }

        const modal = bootstrap.Modal.getInstance(document.getElementById('deleteConfirmModal'));
        modal.hide();
    }

    let editCode = null;

    function openEditModal(code, name, phone, email, address, hobby) {
        editCode = code;
        document.getElementById('editName').value = name;
        document.getElementById('editPhone').value = phone;
        document.getElementById('editEmail').value = email;
        document.getElementById('editAddress').value = address;
        document.getElementById('editHobby').value = hobby;
        $('#editModal').modal('show');
    }

    function confirmEdit() {
        const data = {
            code: editCode,
            name: document.getElementById('editName').value,
            phone: document.getElementById('editPhone').value,
            email: document.getElementById('editEmail').value,
            address: document.getElementById('editAddress').value,
            hobby: document.getElementById('editHobby').value,
        }
        Livewire.dispatch('editMember', {
            data: data,
        });
        editCode = null;
    }
</script>
