<div>
    <div wire:ignore.self class="py-12">
        <div class="table-responsive table-item">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                        <th scope="col">{{ __('Code') }}</th>
                        <th scope="col">{{ __('Barcode') }}</th>
                        <th scope="col">{{ __('Name') }}</th>
                        {{-- <th scope="col">{{ __('Price Sell') }}</th> --}}
                        {{-- <th scope="col">{{ __('Price Buy') }}</th> --}}
                        {{-- @admin
                            <th scope="col">{{ __('Avg Price') }}</th>
                        @endadmin --}}
                        {{-- <th scope="col">{{ __('Qty') }}</th> --}}
                        {{-- <th scope="col">{{ __('Unit') }}</th> --}}
                        <th scope="col">{{ __('Qty') }}</th>

                        <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th>
                        {{-- <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th> --}}
                    </tr>
                </thead>

                <tbody class="small">
                    @foreach ($items as $key => $item)
                        <tr>
                            <th scope="row">{{ $key + 1 }}</th>
                            <td>{{ $item->code }}</td>
                            <td>{{ $item->barcode }}</td>
                            <td onclick="handleShowInfo('{{ $item->code }}')" style="color: blue; cursor: pointer">
                                {{ $item->name }}</td>
                            {{-- <td>{{ number_format($item->price) }}</td> --}}
                            {{-- <td>{{ number_format($item->pricebuy) }}</td> --}}
                            {{-- @admin
                                <td>{{ number_format($item->avgprice) }}</td>
                            @endadmin --}}
                            <td class="text-center">{{ number_format($item->trans_qty) }} pcs</td>
                            {{-- <td>{{ $item->unit_name }}</td>
                            <td class="text-center">{{ $item->message ?: '-' }}</td> --}}
                            {{-- <td>
                                @if ($item->trans_qty > 0)
                                    <div type="button" disabled>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" width="22px" height="22px">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg>                                          
                                    </div>
                                @else
                                    <div type="button" onclick="handleEdit('{{ $item->code }}')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" width="22px" height="22px">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg> 
                                    </div>
                                @endif
                            </td> --}}
                            <td>
                                <button class="btn btn-warning btn-sm"
                                    onclick="Livewire.dispatch('markAsLostSale', { code: '{{ $item->code }}' });">
                                    Lost Sale
                                </button>

                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>

    </div>
    <div class="mt-4" wire:ignore.self>
        <table id="example" class="table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>

                    <th style="text-align: center;" scope="col">{{ __('Total Qty') }}</th>
                </tr>
            </thead>

            <tbody class="small">

                <tr>
                    <td colspan="6">Total</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    <td style="text-align: center;">{{ number_format($items->sum('trans_qty'), 0, ',', ',') }}</td>
                </tr>

            </tbody>
        </table>
    </div>


    <div class="modal fade" id="unitModal" tabindex="-1" aria-labelledby="unitModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="unitModalLabel">Unit and Quantity Information</h5>
                    <button type="button" class="btn-close" wire:click="closeModalInfo" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th class="text-center">Pieces</th>
                                <th class="text-center">Unit</th>
                                <th class="text-center">Full Units</th>
                                <th class="text-center">Remaining Pieces</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (isset($itemData['units']) && count($itemData['units']) > 0)
                                @php
                                    $hasUnitData = false;
                                @endphp
                                @foreach ($itemData['units'] as $unit)
                                    @if ($unit['unit_name'] && $unit['qty_unit'] >= 0)
                                        @php
                                            $hasUnitData = true;
                                        @endphp
                                        <tr>
                                            <td class="text-center">{{ floor($unit['pieces']) }} pcs</td>
                                            <td class="text-center">{{ $unit['unit_name'] }}</td>
                                            <td class="text-center">{{ $unit['qty_unit'] }} {{ $unit['unit_name'] }}
                                            </td>
                                            <td class="text-center">{{ $unit['remaining_qty'] }} pcs</td>
                                        </tr>
                                    @endif
                                @endforeach
                                @if (!$hasUnitData)
                                    <tr>
                                        <td colspan="4" class="text-center">No unit data available.</td>
                                    </tr>
                                @endif
                            @else
                                <tr>
                                    <td colspan="4" class="text-center">No unit data available.</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeModalInfo">Close</button>
                </div>
            </div>
        </div>
    </div>
    <button id="triggerOffcanvas" class="d-none" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
        aria-controls="offcanvasRight"></button>
    <div wire:ignore.self class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight"
        aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header">
            <h5 class="mx-4" id="offcanvasRightLabel">Lost Sale</h5>
            <button type="button" class="text-reset mb-2" data-bs-dismiss="offcanvas" aria-label="Close"
                id="closeOffcanvas" style="font-size: 1.5em; color: inherit; background: none; border: none"> →
            </button>
        </div>
        <div class="offcanvas-body">
            <div style="height: 750px; max-height: 750px; overflow-y: auto">
                @foreach ($lostSale as $item)
                    <div wire:key="lost-sale-{{ $item->id }}">
                        <p> Item : {{ $item->name }} - {{ $item->barcode }} </p>
                        @if ($item->total_qty <= 0)
                            <p class="text-danger"> Tidak ada stock </p>
                            <textarea class="form-control" wire:model="keterangan.{{ $item->id }}" placeholder="Keterangan">{{ $item->keterangan }}</textarea>
                        @else
                            <p class="text-success"> Ada stock {{ $item->total_qty }} pcs</p>
                        @endif
                        <p><button class="btn badge btn-warning"
                                wire:click="deleteLostSale({{ $item->id }})">Delete List</button></p>
                        <hr>
                    </div>
                @endforeach
            </div>
            <div class="d-flex justify-content-end">
                <button class="btn btn-primary mt-2" wire:click="saveLostSale">Save</button>

            </div>
        </div>
    </div>
</div>
</div>
@livewireScripts
<script>
    Livewire.on('showCanvas', () => {
        setTimeout(() => {
            document.getElementById('triggerOffcanvas').click();
        }, 500);
    });
    Livewire.on('closeCanvas', () => {
        setTimeout(() => {
            document.getElementById('closeOffcanvas').click();
        }, 500);
    });
    Livewire.on('hideCanvas', () => {
        document.getElementById('triggerOffcanvas').click();
        Livewire.dispatch('successNotification');
    });
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });
</script>
