<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb align-items-center">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Items') }}
                    </li>
                    <li class="breadcrumb-item active d-flex align-items-center" aria-current="page">
                        @admin
                            <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                                style="width: auto;">
                                @foreach ($warehouse as $whs)
                                    <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                                @endforeach
                            </select>
                        @else
                            <span class="me-2">{{ userWarehouse() }} </span>
                        @endadmin

                    </li>
                </ol>
            </div>
        </nav>

        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="button-top-right">
                        @if ($isloadingpromo)
                            <button type="button" class="btn btn-primary btn-sm ml-4"
                                disabled>{{ __('Insert Batch Item') }}</button>
                        @else
                            <button type="button" wire:keydown.window.shift.n="toBatch" wire:click="toBatch"
                                class="btn btn-primary btn-sm ml-4">{{ __('Insert Batch Item') }}</button>
                        @endif
                    </div>

                    <div class="card-body">
                        <div class="align-items-center card-body justify-content-between small">
                            {{-- <h6 class="card-title ">{{ __('Items') }}</h6> --}}
                            <div class="form-group row">
                                <div class="col-md-2">
                                    <label for="typeInvoice">Filter By</label>
                                    <select class="form-select" wire:model.live="type" id="type">
                                        <option value="Barcode">Barcode</option>
                                        <option value="Code">Code</option>
                                        <option value="Name">Name</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="input"></label>
                                    <input type="text" class="form-control" wire:model.live="inputfilter"
                                        placeholder="Type here" id="inputFilter">
                                </div>
                                <div class="col-md-2 py-3 mt-1">
                                    @if ($isloadingsearch)
                                        <button wire:click="filterItem" wire:loading.attr="disabled"
                                            wire:target="filterItem" type="button" class="btn btn-primary mb-2"
                                            disabled>
                                            <span id="loadingSpinner2" class="spinner-border spinner-border-sm"
                                                role="status" aria-hidden="true"></span>
                                            <span id="innerSpan">Loading . . .</span>
                                        </button>
                                    @else
                                        <button type="button" id="filterBtn" class="btn btn-primary mb-2"
                                            @if (!$inputfilter) disabled @else wire:click="firstClick" @endif>Filter</button>
                                    @endif
                                </div>
                            </div>

                        </div>
                        @if ($isFilter)
                            <livewire:pos.item.item-table :item="$item" />
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @livewireScripts
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>
        Livewire.on('showCanvas', () => {
            setTimeout(() => {
                document.getElementById('triggerOffcanvas').click();
            }, 500);
        });
        Livewire.on('closeCanvas', () => {
            setTimeout(() => {
                document.getElementById('closeOffcanvas').click();
            }, 500);
        });
        Livewire.on('hideCanvas', () => {
            document.getElementById('triggerOffcanvas').click();
            Livewire.dispatch('successNotification');
        });

        function handleShowInfo(code) {
            Livewire.dispatch('showInfo', {
                code: code,
            });
        }
        Livewire.on('openModalInfo', (params) => {
            $('#unitModal').modal('show');

        });
        Livewire.on('closeModalInfo', (params) => {
            $('#unitModal').modal('hide');

        });
        document.addEventListener('keydown', function(event) {
            if (event.key === 'F1') {
                event.preventDefault();
                document.getElementById('type').focus();
            }
            if (event.key === 'F2') {
                event.preventDefault();
                document.getElementById('inputFilter').focus();
            }
            if (event.key === 'F3') {
                event.preventDefault();
                document.getElementById('filterBtn').focus();
            }

        });

        function handleEdit(code) {
            Livewire.dispatch('editItem', {
                code: code
            });
        }
        Livewire.on('refreshjs', (params) => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        });

        Livewire.on('openTheModalEdit', (params) => {
            $('#modalEdit').modal('show');

        });
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });

        document.addEventListener('livewire:navigated', () => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                $('#table').DataTable({
                    "bDestroy": true
                });
            });
        });
        window.addEventListener('keydown', function(event) {

            if (event.key === 'End') {
                event.preventDefault();
                document.getElementById('triggerOffcanvas').click();

            }
        });
    </script>

</div>
