<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="unit-page py-12 mt-2">
        <div class="header" x>
            <div class="d-flex justify-content-end">
                <div class="form-check mb-4">
                    
                        <button data-bs-target="#modalCreate" data-bs-toggle="modal"
                        class="btn btn-sm btn-primary rounded-3 px-4">+ Add Unit</button>
                </div>
            </div>
        </div>



        <div class="card p-4 table-responsive table-member-tablet bg-transparent">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <label class="me-2">Show</label>
                    <select wire:model.live="perPage" class="form-control form-select-sm me-2" style="width: auto">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="20">20</option>
                        <option value="50">50</option>
                    </select>
                    <label>entries</label>
                </div>
                <div class="d-flex align-items-center">
                    <label class="me-2">Search</label>
                    <input wire:model.live="search" type="text" class="form-control form-control-sm"
                        placeholder="Search">
                </div>
            </div>

            <table class="my-table" style="width:100%">
                <thead>
                    <tr>
                        <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                        <th style="text-align: center;" wire:click="doSort('name')" style="cursor: pointer">
                            Name
                            @if ($sortColumn === 'name')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center; border-top-right-radius: .5rem">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($units as $index => $unit)
                        <tr>
                            <td class="text-center">{{ $units->firstItem() + $index }}</td>
                            <td>{{ $unit->name }}</td>
                            <td style="text-align: center;">
                                <a href="{{ route('item.unititem', ['id' => $unit->id]) }}"
                                    class="btn btn-sm btn-badge btn-primary">
                                    <div style="width: 17px; height: auto;">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="size-6">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                        </svg>
                                    </div>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center">No units found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            <div class="mt-4">
                {{ $units->links() }}
            </div>
        </div>
    </div>

    <!-- Create Modal -->
    <div wire:ignore.self class="modal fade" id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Unit</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" wire:model.live="name" id="name"
                            class="form-control @error('name') is-invalid @enderror">
                        @error('name')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $name == '') disabled @endif
                        wire:click="save">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:initialized', () => {
            @this.on('refreshDatatable', (event) => {
                $('#example').DataTable().destroy();
                setTimeout(function() {
                    $('#example').DataTable({
                        searching: false,
                        paging: false,
                        info: false,
                        ordering: false
                    });
                }, 1000);
            });
        });

        document.addEventListener('livewire:initialized', () => {
            @this.on('closemodalCreate', (event) => {
                $('#modalCreate').modal('hide');
            });
        });

        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });
    </script>
</div>
