<div>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="py-12 mt-2">
        <div style="display: flex; justify-content: end">
            <a data-bs-target="#modalCreateUnitItem" data-bs-toggle="modal"
                class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3">+ Add Unit Item </a>
        </div>
        <div class="table-responsive table-member-tablet mt-4 card p-4 bg-transparent">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="d-flex align-items-center">
                    <label class="me-2">Show</label>
                    <select wire:model.live="perPage" class="form-control form-select-sm me-2" style="width: auto">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="20">20</option>
                        <option value="50">50</option>
                    </select>
                    <label>entries</label>
                </div>
                <div class="d-flex align-items-center">
                    <label class="me-2">Search</label>
                    <input wire:model.live="search" type="text" class="form-control form-control-sm"
                        placeholder="Search">
                </div>
            </div>

            <div class="fs-4 fw-semibold mb-3">Item Unit List</div>
            <table class="my-table" style="width:100%">
                <thead>
                    <tr>
                        <th style="text-align: center; border-top-left-radius: .5rem" wire:click="doSort('item_code')" style="cursor: pointer">
                            Item Code
                            @if ($sortColumn === 'item_code')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center" wire:click="doSort('barcode')" style="cursor: pointer">
                            Item Barcode
                            @if ($sortColumn === 'barcode')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center" wire:click="doSort('name')" style="cursor: pointer">
                            Item Name
                            @if ($sortColumn === 'name')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center" wire:click="doSort('qty')" style="cursor: pointer">
                            Qty
                            @if ($sortColumn === 'qty')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center" wire:click="doSort('pricesell')" style="cursor: pointer">
                            Price Sell
                            @if ($sortColumn === 'pricesell')
                                <span>
                                    @if ($sortDirection === 'ASC')
                                        <i class="fas fa-sort-up"></i>
                                    @else
                                        <i class="fas fa-sort-down"></i>
                                    @endif
                                </span>
                            @endif
                        </th>
                        <th style="text-align: center; border-top-right-radius: .5rem">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($itemUnit as $item)
                        <tr>
                            <td style="text-align: center">{{ $item->item_code }}</td>
                            <td style="text-align: center">{{ $item->barcode }}</td>
                            <td style="text-align: center">{{ $item->name }}</td>
                            <td style="text-align: center">{{ $item->qty }}</td>
                            <td style="text-align: center">Rp. {{ number_format($item->pricesell, 0, ',', '.') }}</td>
                            <td style="text-align: center">
                                <div class="btn btn-sm" type="button" style="background: #00000015;"
                                    onclick="handleEditUnitItem('{{ $item->item_code }}', '{{ $item->id_unit }}')">
                                    <div style="width: 17px"> 
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                        </svg>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" style="text-align: center">No items found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            <div class="mt-4">
                {{ $itemUnit->links() }}
            </div>
        </div>
    </div>

    <!-- Create Modal -->
    <div wire:ignore.self class="modal fade" id="modalCreateUnitItem" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Unit Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="closeModal"></button>
                </div>
                <div class="modal-body">
                    <!-- Item Code -->
                    <div class="form-group">
                        <label for="item_code">Item Code</label>
                        <input type="text" wire:model.live="item_code" id="item_code" class="form-control mb-2">
                        @error('item_code')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>

                    <!-- Quantity -->
                    <div class="form-group">
                        <label for="qty">Quantity</label>
                        <input type="number" wire:model.live="qty" id="qty" class="form-control mb-2"
                            min="1">
                        @error('qty')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>

                    <!-- Price Sell -->
                    <div class="form-group">
                        <label for="pricesell">Price Sell</label>
                        <input type="number" wire:model.live="pricesell" id="pricesell" class="form-control mb-2"
                            min="0" step="0.01">
                        @error('pricesell')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="closeModal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click="saveUnitItem">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div wire:ignore.self class="modal fade" id="modalEditUnitItem" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Unit Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="closeModal"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="item_code">Item Code</label>
                        <input type="text" value="{{ $selectedUnitCode }}" class="form-control mb-2" disabled>
                    </div>
                    <div class="form-group">
                        <label for="item_code">Item Barcode</label>
                        <input type="text" value="{{ $selectedUnitBarcode }}" class="form-control mb-2" disabled>
                    </div>
                    <div class="form-group">
                        <label for="item_code">Item Name</label>
                        <input type="text" value="{{ $selectedUnitName }}" class="form-control mb-2" disabled>
                    </div>
                    <!-- Quantity -->
                    <div class="form-group">
                        <label for="qty">Quantity</label>
                        <input type="number" wire:model.live="qty" id="qty" class="form-control mb-2"
                            min="1">
                        @error('qty')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>

                    <!-- Price Sell -->
                    <div class="form-group">
                        <label for="pricesell">Price Sell</label>
                        <input type="number" wire:model.live="pricesell" id="pricesell" class="form-control mb-2"
                            min="0" step="0.01">
                        @error('pricesell')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="closeModal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click="saveUpdate">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('livewire:initialized', () => {
            const modalCreate = document.getElementById('modalCreateUnitItem');
            const modalEdit = document.getElementById('modalEditUnitItem');

            modalCreate.addEventListener('hidden.bs.modal', () => {
                @this.dispatch('closeModal');
            });

            modalEdit.addEventListener('hidden.bs.modal', () => {
                @this.dispatch('closeModal');
            });

            Livewire.on('closemodalCreate', () => {
                const modal = bootstrap.Modal.getInstance(modalCreate);
                modal.hide();
            });

            Livewire.on('closeModalEdit', () => {
                const modal = bootstrap.Modal.getInstance(modalEdit);
                modal.hide();
            });

            Livewire.on('openModalEdit', () => {
                const modal = bootstrap.Modal.getInstance(modalEdit) || new bootstrap.Modal(modalEdit);
                modal.show();
            });
        });

        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                const modal = new bootstrap.Modal(document.getElementById('modalCreateUnitItem'));
                modal.show();
            }
        });
    </script>
</div>
