<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            height: 50px;
        }
    </style>
    <div class="supplier-page py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: false }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
            isInputGroupVisible = !isInputGroupVisible; 
            @this.call('changeTable'); 
        }">
            <div class="d-flex justify-content-start">
                <div class="form-check" wire:click="changeTable" @click="isInputGroupVisible = !isInputGroupVisible"
                    data-toggle="tooltip" title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop" style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                        + Add
                        @else
                        <div class="d-flex justify-content-center gap-1 align-items-center">
                            <div style="width: 17px; height: auto;">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                </svg>
                            </div>
                            Table
                        </div>
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">
                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3">+ Add Supplier</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx" style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="importItem" type="button"
                                class="btn btn-success btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                @if (!$file) disabled @endif>
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                    </svg>
                                </div>{{ __('Import') }}</button>
                            <button type="button" class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                onclick="window.location.href='/assets/template/Template Supplier.csv'">
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                      </svg>
                                </div> {{ __(' Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEdit">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>
                @endif
                <div class="table-responsive table-member-tablet mt-4">
                    @if ($chunks)
                        <table class="my-table" @if (!$editChunks) id="example" @endif
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                                    <th style="text-align: center">Code</th>
                                    <th style="text-align: center">Name</th>
                                    <th style="text-align: center">Address</th>
                                    <th style="text-align: center">Phone</th>

                                    <th style="text-align: center; border-top-right-radius: .5rem">Email</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.code">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.name">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.address">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.phone"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.email"></td>
                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td>{{ $item['code'] }}</td>
                                            <td>{{ $item['name'] }}</td>
                                            <td>{{ $item['address'] }}</td>
                                            <td>{{ $item['phone'] }}</td>
                                            <td>{{ $item['email'] }}</td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
        @if ($isTable)
            <div class="table-responsive table-member-tablet mt-4 table-supplier-pop">
                <table class="my-table" id="example" style="width:100%">
                    <thead>
                        <tr>
                            <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                            <th style="text-align: center">Code</th>
                            <th style="text-align: center">Name</th>
                            <th style="text-align: center">Address</th>
                            <th style="text-align: center">Phone</th>
                            <th style="text-align: center">Email</th>

                            <th style="text-align: center; border-top-right-radius: .5rem">Edit</th>


                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($itemSupplier as $item)
                            <tr>
                                <td style="text-align: center">{{ $loop->iteration }}</td>
                                <td>{{ $item->code }}</td>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->address }}</td>
                                <td>{{ $item->phone }}</td>
                                <td>{{ $item->email }}</td>
                                <td>
                                    <button class="btn btn-sm" style="background: #00000015;"
                                        onclick="handleEditSupplier('{{ $item->code }}')">
                                        <div style="width: 17px"> 
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                              </svg>
                                        </div>
                                    </button>
                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        @endif
    </div>
    <div wire:ignore.self class="modal fade " id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Supplier</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        onclick="closeModal()"></button>
                </div>
                <div class="modal-body">

                    {{-- <div class="form-group">
                        <div class="form-group">
                            <label for="barcode">Supplier Code</label>
                            <input type="text" wire:model.live="code" id="code" class="form-control">
                            @error('code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    </div> --}}
                    {{-- @admin
                        <div class="form-group">
                            <label for="whs_code">Warehouse</label>
                            <select wire:model.live="whs_code" id="whs_code" class="form-select">
                                @foreach ($warehouses as $warehouse)
                                    <option value="{{ $warehouse->code }}">{{ $warehouse->name }}</option>
                                @endforeach
                            </select>
                            @error('whs_code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endadmin --}}

                    <div class="form-group">
                        <label for="name">Supplier Name</label>
                        <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                        @error('name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="address">Address</label>
                        <input type="text" wire:model.live="address" id="address" class="form-control mb-2">
                        @error('address')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone</label>
                        <input type="text" wire:model.live="phone" id="phone" class="form-control mb-2">
                        @error('phone')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="email" id="email" class="form-control mb-2">
                        @error('email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <div class="form-check mb-2">
                            <input type="checkbox" wire:model.live="consignment" id="consignment"
                                class="form-check-input">
                            <label for="consignment" class="form-check-label">Consignment</label>
                            @error('consignment')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    @if ($consignment)
                        <div class="form-group">
                            <label for="shared_margin">Shared Margin (%)</label>
                            <input type="number" wire:model.live="shared_margin" id="shared_margin"
                                class="form-control mb-2">
                            @error('shared_margin')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group">
                            <div class="form-check mb-2">
                                <input type="checkbox" wire:model.live="activate_dashboard" id="activate_dashboard"
                                    class="form-check-input">
                                <label for="activate_dashboard" class="form-check-label">Activate Supplier Dashboard</label>
                                @error('activate_dashboard')
                                    <small class="text-danger d-block mt-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                    @endif

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                        onclick="closeModal()">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $name == '') disabled @endif
                        wire:click="{{ $isEdit ? 'saveUpdate' : 'save' }}">Save</button>
                </div>
            </div>
        </div>
    </div>
    @livewireScripts()
    <script>
        function handleEditSupplier(code) {
            Livewire.dispatch('isEdit', {
                code: code,
            });
        }

        function closeModal() {
            const formFields = {
                text: ['code', 'name', 'address', 'phone', 'email', 'shared_margin'],
                checkbox: ['consignment', 'activate_dashboard']
            };

            formFields.text.forEach(id => {
                $(`#${id}`).val('');
            });

            formFields.checkbox.forEach(id => {
                $(`#${id}`).prop('checked', false);
            });
        }

        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });

        Livewire.on('openModalforEdit', (data) => {
            const formFields = {
                text: {
                    'code': data[0].code,
                    'name': data[0].name,
                    'address': data[0].address,
                    'phone': data[0].phone,
                    'email': data[0].email,
                    'shared_margin': data[0].shared_margin
                },
                checkbox: {
                    'consignment': data[0].consignment,
                    'activate_dashboard': data[0].dashboard
                }
            };

            Object.entries(formFields.text).forEach(([id, value]) => {
                $(`#${id}`).val(value);
            });

            Object.entries(formFields.checkbox).forEach(([id, value]) => {
                $(`#${id}`).prop('checked', value);
            });

            setTimeout(() => {
                $('#modalCreate').modal('show');
            }, 500);
        })
    </script>
    @if ($istutorials)
        <script>
            const supplierPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [{
                            element: '.supplier-pop',
                            popover: {
                                description: 'This menu is designed to manage the list of providers/suppliers'
                            }
                        },
                        {
                            element: '.table-supplier-pop',
                            popover: {
                                description: 'The table displays complete information for each provider such as code, name, address and other information'
                            }
                        },
                        {
                            element: '.konsinyasi-pop',
                            popover: {
                                description: 'If the supplier consigns their goods for sale (consignment), check the Consignment option and enter the agreed margin percentage. If the supplier does not use a consignment system, leave the Consignment option unchecked.'
                            }
                        },
                        {
                            element: '.add-supplier-pop',
                            popover: {
                                description: 'click the button to add a new provider'
                            }
                        },
                        {

                            element: '.go-sales-emp-pop',
                            popover: {
                                description: 'After registering the list of providers, you now need to add store staff in the settings menu, store staff.'
                            }
                        },
                    ],
                    onDeselected: () => {
                        $.ajax({
                            type: "POST",
                            url: '/update-status-driver',
                            data: {
                                menu: "Supplier",
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                            },
                            error: function(data, textStatus, errorThrown) {
                            },
                        });

                    }
                });

                driverObj.drive();
            }
        </script>
    @endif
</div>