<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="size-page py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: false }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
            isInputGroupVisible = !isInputGroupVisible; 
            @this.call('changeTable'); 
        }"
            @success-import.window="isInputGroupVisible = false">
            <div class="d-flex justify-content-start">
                <div class="form-check" wire:click="changeTable" @click="isInputGroupVisible = !isInputGroupVisible"
                    data-toggle="tooltip" title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop"
                        style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                            + Add
                        @else
                            <div class="d-flex justify-content-center gap-1 align-items-center">
                                <div style="width: 17px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                    </svg>
                                </div>
                                Table
                            </div>
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">
                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3">+ Add Size</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx"
                            style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="importItem" type="button"
                                class="btn btn-success btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                @if (!$file) disabled @endif>
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                    </svg>
                                </div>{{ __('Import') }}
                            </button>
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                onclick="window.location.href='/assets/template/Template Size.csv'">
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                    </svg>
                                </div>
                                {{ __(' Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="modeEditFalse">Save Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEditTrue">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>

                    @if ($this->hasDuplicates)
                        <div class="d-flex justify-content-end gap-2 mb-3">
                            <button wire:click="downloadDuplicates('xlsx')"
                                class="btn btn-sm btn-outline-primary rounded-3">
                                <i class="fas fa-file-excel me-1"></i> Export Duplicate Data
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive table-member-tablet mt-4">
                        @if ($chunks)
                            <table class="my-table" @if (!$editChunks) id="example" @endif
                                style="width:100%">
                                <thead>
                                    <tr>
                                        <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                                        <th style="text-align: center">Code</th>
                                        <th style="text-align: center; border-top-right-radius: .5rem">Name</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($editChunks)
                                        @foreach ($chunks as $index => $item)
                                            <tr>
                                                <td style="text-align: center">{{ $loop->iteration }}</td>
                                                <td><input type="text" class="form-control"
                                                        wire:model.lazy="chunks.{{ $index }}.code">
                                                </td>
                                                <td><input type="text" class="form-control"
                                                        wire:model.lazy="chunks.{{ $index }}.name">
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        @foreach ($chunks as $index => $item)
                                            <tr>
                                                <td style="text-align: center">{{ $loop->iteration }}</td>
                                                <td>{{ $item['code'] }}</td>
                                                <td>{{ $item['name'] }}</td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        @endif
                    </div>
                @endif
            </div>
        </div>
        @if ($isTable)
            <div class="card p-4 table-responsive table-member-tablet bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="d-flex align-items-center">
                        <label class="me-2">Show</label>
                        <select wire:model.live="perPage" class="form-control form-select-sm me-2"
                            style="width: auto">
                            <option value="5">5</option>
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                        </select>
                        <label>entries</label>
                    </div>
                    <div class="d-flex align-items-center">
                        <label class="me-2">Search</label>
                        <input wire:model.live="search" type="text" class="form-control form-control-sm"
                            placeholder="Search">
                    </div>
                </div>

                <table class="my-table" style="width:100%">
                    <thead>
                        <tr>
                            <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                            <th style="text-align: center;" wire:click="doSort('code')" style="cursor: pointer">
                                Code
                                @if ($sortColumn === 'code')
                                    <span>
                                        @if ($sortDirection === 'ASC')
                                            <i class="fas fa-sort-up"></i>
                                        @else
                                            <i class="fas fa-sort-down"></i>
                                        @endif
                                    </span>
                                @endif
                            </th>
                            <th style="text-align: center;" wire:click="doSort('name')" style="cursor: pointer">
                                Name
                                @if ($sortColumn === 'name')
                                    <span>
                                        @if ($sortDirection === 'ASC')
                                            <i class="fas fa-sort-up"></i>
                                        @else
                                            <i class="fas fa-sort-down"></i>
                                        @endif
                                    </span>
                                @endif
                            </th>
                            <th style="text-align: center; border-top-right-radius: .5rem">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($sizes as $index => $item)
                            <tr>
                                <td class="text-center">{{ $sizes->firstItem() + $index }}</td>
                                <td>{{ $item->code }}</td>
                                <td>{{ $item->name }}</td>
                                <td>
                                    <div class="btn-group gap-2">
                                        <button class="btn btn-sm btn-primary"
                                            onclick="Livewire.dispatch('isEdit', ['{{ $item->code }}'])">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                <path
                                                    d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                <path fill-rule="evenodd"
                                                    d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" />
                                            </svg>
                                        </button>
                                        <button class="btn btn-sm btn-danger"
                                            onclick="openDeleteModal('{{ $item->code }}', '{{ $item->name }}')">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path
                                                    d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z" />
                                                <path
                                                    d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z" />
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center">No sizes found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="mt-4">
                    {{ $sizes->links() }}
                </div>
            </div>
        @endif
    </div>

    <!-- Create Modal -->
    <div wire:ignore.self class="modal fade" id="modalCreate" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Size</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div x-data="{
                        autoGenerate: false,
                        codeSize: '',
                        async generateCode() {
                            // Call the Livewire method to get next available code
                            const result = await @this.getNextAvailableCode();
                            if (result.success) {
                                this.codeSize = result.code;
                                // Notify Livewire that input has changed
                                this.$nextTick(() => {
                                    const input = document.getElementById('code');
                                    input.value = result.code;
                                    input.dispatchEvent(new Event('input'));
                                });
                            } else {
                                // Show error message
                                alert(result.message || 'Failed to generate code');
                                this.autoGenerate = false;
                            }
                        }
                    }" x-init="if (autoGenerate) generateCode()">
                        <div class="form-check mb-2">
                            <input type="checkbox" class="form-check-input" id="auto_code"
                                x-model="autoGenerate" @change="autoGenerate ? generateCode() : codeSize = ''">
                            <label class="form-check-label" for="auto_code">Generate Code</label>
                        </div>
                        <div class="form-group">
                            <label for="code">Code</label>
                            <input type="text" id="code" class="form-control mb-2" x-model="codeSize"
                                :disabled="autoGenerate" @input="codeSize = codeSize.toUpperCase()"
                                wire:model="code">
                            @error('code')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group mt-3">
                            <label for="name">Name</label>
                            <input type="text" wire:model="name" id="name"
                                class="form-control @error('name') is-invalid @enderror">
                            @error('name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" wire:click="save" class="btn btn-primary">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div wire:ignore.self class="modal fade" id="modalEdit" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Edit Size</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="code">Code</label>
                        <input type="text" wire:model="code" id="code" class="form-control" readonly>
                    </div>
                    <div class="form-group mt-3">
                        <label for="name">Name</label>
                        <input type="text" wire:model="name" id="name"
                            class="form-control @error('name') is-invalid @enderror">
                        @error('name')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" wire:click="saveUpdate" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div wire:ignore.self class="modal fade" id="modalDelete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Delete Size</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this size?</p>
                    <p><strong>Code:</strong> <span id="deleteCode"></span></p>
                    <p><strong>Name:</strong> <span id="deleteName"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" onclick="confirmDelete()">Delete</button>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        document.addEventListener('livewire:initialized', () => {
            @this.on('refreshDatatable', (event) => {
                $('#example').DataTable().destroy();
                setTimeout(function() {
                    $('#example').DataTable({
                        searching: false,
                        paging: false,
                        info: false,
                        ordering: false
                    });
                }, 1000);
            });
        });

        document.addEventListener('livewire:initialized', () => {
            @this.on('openModalEdit', (code, name) => {
                $('#modalEdit').modal('show');
            });
        });

        document.addEventListener('livewire:initialized', () => {
            @this.on('closemodalCreate', (event) => {
                $('#modalCreate').modal('hide');
            });
        });

        document.addEventListener('livewire:initialized', () => {
            @this.on('clearAfterCloseModalEdit', (event) => {
                $('#modalEdit').modal('hide');
            });
        });

        // Function to clear form fields
        function clearFormFields() {
            const codeInput = document.getElementById('code');
            const nameInput = document.getElementById('name');
            const autoGenerateCheckbox = document.getElementById('auto_code');
            
            if (codeInput) codeInput.value = '';
            if (nameInput) nameInput.value = '';
            if (autoGenerateCheckbox) autoGenerateCheckbox.checked = false;
        }

        // Clear form when modal is hidden
        document.getElementById('modalCreate').addEventListener('hidden.bs.modal', function () {
            clearFormFields();
        });

        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.shiftKey && event.key === 'N') {
                event.preventDefault();
                $('#modalCreate').modal('show');
            }
        });

        function openDeleteModal(code, name) {
            document.getElementById('deleteCode').textContent = code;
            document.getElementById('deleteName').textContent = name;
            $('#modalDelete').modal('show');
        }

        function confirmDelete() {
            const code = document.getElementById('deleteCode').textContent;
            Livewire.dispatch('markAsDeleted', [code]);
            $('#modalDelete').modal('hide');
        }
    </script>
@endpush
