<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="product-page py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: {{ session('fromCashier') ? 'true' : 'false' }} }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
        isInputGroupVisible = !isInputGroupVisible; 
        @this.call('changeTable'); 
        }">
            <div class="d-flex justify-content-start">
                <div class="form-check" @click="isInputGroupVisible = !isInputGroupVisible" data-toggle="tooltip"
                    title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop"
                        style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                            + Add
                        @else
                            <div class="d-flex justify-content-center gap-1 align-items-center">
                                <div style="width: 17px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                    </svg>
                                </div>
                                Table
                            </div>
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">
                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal" wire:click="clearSes"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3 add-item-pop shadow-md">+
                            Add Item</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx"
                            style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="toImportItem" type="button"
                                class="btn btn-success btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                @if (!$file) disabled @endif>
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                    </svg>
                                </div>
                                {{ __('Import') }}
                            </button>
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                onclick="window.location.href='/assets/template/Template Item.csv'">
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                    </svg>
                                </div>
                                {{ __('Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="modeEditFalse">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEditTrue">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>

                @endif
                <div class="table-responsive table-member-tablet mt-4">
                    @if ($chunks)
                        <table class="my-table" @if (!$editChunks) id="example" @endif
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                                    <th style="text-align: center">Code</th>
                                    <th style="text-align: center">Barcode</th>
                                    <th style="text-align: center">Name</th>
                                    <th style="text-align: center">Brand Code</th>
                                    <th style="text-align: center">Category Code</th>
                                    <th style="text-align: center">Size Code</th>
                                    <th style="text-align: center">Inventory</th>
                                    <th style="text-align: center">Sales</th>
                                    <th style="text-align: center">Purchase</th>
                                    <th style="text-align: center">Consignment</th>
                                    <th style="text-align: center">Price</th>
                                    <th style="text-align: center; border-top-right-radius: .5rem">Supplier Code</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.code">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.barcode">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.name">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.brand_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.category_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.size_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.inventory"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.sales">
                                            </td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.purchase"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.consignment">
                                            </td>
                                            <td><input type="text"
                                                    class="form-control"wire:model.lazy="chunks.{{ $index }}.price">
                                            </td>
                                            <td><input type="text"
                                                    class="form-control"wire:model.lazy="chunks.{{ $index }}.supplier_code">
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td>{{ $item['code'] }}</td>
                                            <td>{{ $item['barcode'] }}</td>
                                            <td>{{ $item['name'] }}</td>
                                            <td>{{ $item['brand_code'] }}</td>
                                            <td>{{ $item['category_code'] }}</td>
                                            <td>{{ $item['size_code'] }}</td>
                                            <td>{{ $item['inventory'] }}</td>
                                            <td>{{ $item['sales'] }}</td>
                                            <td>{{ $item['purchase'] }}</td>
                                            <td>{{ $item['consignment'] }}</td>
                                            <td>{{ $item['price'] }}</td>
                                            <td>{{ $item['supplier_code'] }}</td>


                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>

            @if ($isTable)
                <div class="card p-4 bg-transparent" x-show="!isInputGroupVisible">
                    <div class="fs-4 fw-semibold mb-3">Item list</div>
                    <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                        <thead>
                            <tr>
                                <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                <th scope="col">{{ __('Code') }}</th>
                                <th scope="col">{{ __('Barcode') }}</th>
                                <th scope="col">{{ __('Name') }}</th>
                                <th scope="col">{{ __('Brand') }}</th>
                                <th scope="col">{{ __('Category') }}</th>
                                <th scope="col">{{ __('Size') }}</th>
                                @if ($activeUDFs->isNotEmpty())
                                    @foreach ($activeUDFs as $udf)
                                        <th scope="col">{{ __($udf->field) }}</th>
                                    @endforeach
                                @endif
                                <th scope="col" style="text-align: center">{{ __('Consignment') }}</th>



                                <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th>
                            </tr>
                        </thead>

                        <tbody class="small">
                            @foreach ($item as $key => $item)
                                <tr>
                                    <th scope="row">{{ $key + 1 }}</th>
                                    <td>{{ $item->code }}</td>
                                    <td>{{ $item->barcode }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->brand->name ?? '-' }}</td>
                                    <td>{{ $item->category->name ?? '-' }}</td>
                                    <td>{{ $item->size->name ?? '-' }}</td>
                                    @if ($activeUDFs->isNotEmpty())
                                        @foreach ($activeUDFs as $udf)
                                            <td>{{ $item->{$udf->field} ?? '-' }}</td>
                                        @endforeach
                                    @endif
                                    <td style="text-align: center">
                                        @if ($item->consignment == 'Y')
                                            <span class="badge" style="background: #11d88c25; color: #00a868;"
                                                role="button"
                                                wire:click="$dispatch('openSupplierModal', {code: '{{ $item->code }}'})">Yes</span>
                                        @else
                                            <span class="badge"
                                                style="background: #d8111128; color: #d81111;">No</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm edit-product-pop" style="background: #00000015;"
                                            onclick="handleEditItem('{{ $item->code }}')">
                                            <div style="width: 17px">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="size-6">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                                                </svg>
                                            </div>
                                        </button>
                                    </td>

                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        </div>
        @endif
    </div>
    <div wire:ignore.self class="modal fade" id="modalInfoSupplier" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Item & Supplier Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Name</label>
                            <p class="text-secondary mb-0">{{ $infoitem_name ?? '-' }}</p>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Code</label>
                            <p class="text-secondary mb-0">{{ $infoitem_code ?? '-' }}</p>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Barcode</label>
                            <p class="text-secondary mb-0">{{ $infoitem_barcode ?? '-' }}</p>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Supplier Name</label>
                            <p class="text-secondary mb-0">{{ $infosupplier_name ?? '-' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Supplier Code</label>
                            <p class="text-secondary mb-0">{{ $infosupplier_code ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade modal-lg" data-bs-backdrop="static" id="modalCreate" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel">
                        @if ($isEdit)
                            Edit
                        @else
                            Buat 
                        @endif Item
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        onclick="clearForm()"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="form-group">
                            <label for="barcode">Code</label>
                            <input type="text" id="code" class="form-control mb-2"
                                style="text-transform: uppercase"
                                @if ($isEdit) disabled @else wire:model.live="code" @endif
                                oninput="this.value = this.value.toUpperCase()">
                            @error('code')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                        <label for="code">Barcode</label>
                        <input type="text" wire:model.live="barcode" id="barcode" class="form-control mb-2">
                        @error('barcode')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                        @error('name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    @if ($unit_code)
                        <div class="form-group">
                            <label for="name">Qty / {{ $unit_label }}</label>
                            <input type="number" wire:model.live="qtyunit" id="qtyunit"
                                class="form-control mb-2">
                            @error('name')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                    <div class="form-group">
                        <label for="brand_code">Brand </label>
                        <select class="form-select mb-2" wire:model.live="brand_code" id="brand_code">
                            <option value="">-- Select Brand --</option>

                            @foreach ($itemBrand as $brand)
                                <option value="{{ $brand->code }}">{{ $brand->name }}</option>
                            @endforeach
                            <option value="BrandCN">{{ empty($name_brand) ? 'Create New' : $name_brand }}</option>
                        </select>
                        @if ($isCreateNewBrand)
                            <button data-bs-target="#modalCreateBrand" data-bs-toggle="modal" data-bs-dismiss="modal"
                                class="btn badge bg-primary">Open Form Brand</button>
                        @endif
                        @error('brand_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="category_code">Category </label>
                        <select class="form-select mb-2" wire:model.live="category_code" id="category_code">
                            <option value="">-- Select Category --</option>

                            @foreach ($itemCategory as $cat)
                                <option value="{{ $cat->code }}">{{ $cat->name }}</option>
                            @endforeach
                            <option value="CategoryCN">{{ empty($name_category) ? 'Create New' : $name_category }}
                            </option>
                        </select>
                        @if ($isCreateNewCategory)
                            <button data-bs-target="#modalCreateCategory" data-bs-toggle="modal"
                                data-bs-dismiss="modal" class="btn badge bg-primary">Open Form Category</button>
                        @endif
                        @error('category_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="size_code">Size </label>
                        <select class="form-select mb-2" wire:model.live="size_code" id="size_code">
                            <option value="">-- Select Size --</option>

                            @foreach ($itemSize as $size)
                                <option value="{{ $size->code }}">{{ $size->name }}</option>
                            @endforeach
                            <option value="SizeCN">{{ empty($name_size) ? 'Create New' : $name_size }}</option>
                        </select>
                        @if ($isCreateNewSize)
                            <button data-bs-target="#modalCreateSize" data-bs-toggle="modal" data-bs-dismiss="modal"
                                class="btn badge bg-primary">Open Form Size</button>
                        @endif
                        @error('size_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    @if (!empty($activeUDFs))
                        @foreach ($udfFields as $field => $value)
                            <div class="form-group mb-2">
                                <label for="{{ $field }}">{{ $field }}</label>
                                <input type="text" wire:model.live="udfFields.{{ $field }}"
                                    id="{{ $field }}" class="form-control" value="{{ $value }}">
                                @error("udfFields.$field")
                                    <small class="text-danger d-block mt-1">{{ $message }}</small>
                                @enderror
                            </div>
                        @endforeach
                    @endif
                    <div class="d-flex justify-content-between mt-2">
                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="isConsignment" id="isConsignment"
                                class="form-check-input" @if ($isEdit && !$canEditSupplier) disabled @endif>
                            <label for="consignment" class="form-check-label">Consignment</label>
                            @error('isConsignment')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="inventory" id="inventory"
                                class="form-check-input">
                            <label for="inventory" class="form-check-label">Inventory</label>
                            @error('inventory')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="sales" id="sales" class="form-check-input">
                            <label for="sales" class="form-check-label">Sales</label>
                            @error('sales')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="form-check">
                            <input type="checkbox" wire:model.live="purchase" id="purchase"
                                class="form-check-input">
                            <label for="purchase" class="form-check-label">Purchase</label>
                            @error('purchase')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>


                    @if ($isConsignment)
                        <div class="form-group mt-3">
                            <label for="supplier_code">Supplier</label>
                            <select wire:model.live="supplier_code" id="supplier_code" class="form-select"
                                @if ($isEdit && !$canEditSupplier) disabled @endif>
                                <option value="">-- Select Supplier --</option>
                                @foreach ($suppliers as $supplier)
                                    <option value="{{ $supplier->code }}">{{ $supplier->name }}</option>
                                @endforeach
                                <option value="SupplierCN">
                                    {{ empty($suppliernew_name) ? 'Create New' : $suppliernew_name }}
                            </select>
                            @error('supplier_code')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        @if ($isCreateNewSupplier)
                            <button data-bs-target="#modalCreateSupplier" data-bs-toggle="modal"
                                data-bs-dismiss="modal" class="btn badge bg-primary">Open Form Supplier</button>
                        @endif
                        @error('supplier_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                        onclick="clearForm()">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $name == '') disabled @endif
                        @if ($isEdit) wire:click="saveUpdate"
                    @else wire:click="save" @endif>
                        @if ($isEdit)
                            Edit
                        @else
                            Save
                        @endif
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateSupplier" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Supplier</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="name">Supplier Name</label>
                        <input type="text" wire:model.live="suppliernew_name" id="name"
                            class="form-control mb-2">
                        @error('suppliernew_name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="address">Address</label>
                        <input type="text" wire:model.live="suppliernew_address" id="address"
                            class="form-control mb-2">
                        @error('suppliernew_address')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="phone">Phone</label>
                        <input type="text" wire:model.live="suppliernew_phone" id="phone"
                            class="form-control mb-2">
                        @error('suppliernew_phone')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="suppliernew_email" id="email"
                            class="form-control mb-2">
                        @error('suppliernew_email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="shared_margin">Shared Margin (%)</label>
                        <input type="number" wire:model.live="shared_margin" id="shared_margin"
                            class="form-control mb-2">
                        @error('shared_margin')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateUnit" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Unit</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">


                    <div class="form-group">
                        <label for="name">Name Unit</label>
                        <input type="text" wire:model.live="name_unit" id="name_unit" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateBrand" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Brand</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="code_brand">Code Brand</label>
                        <input type="text" wire:model.live="code_brand" id="code_brand" class="form-control"
                            onkeyup="this.value = this.value.toUpperCase();">
                        @error('code_brand')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name">Name Brand</label>
                        <input type="text" wire:model.live="name_brand" id="name_brand" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateCategory" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="Create">Modal Create Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="code_category">Code Category</label>
                        <input type="text" wire:model.live="code_category" id="code_category"
                            class="form-control text-uppercase" onkeyup="this.value = this.value.toUpperCase();" />
                        @error('code_category')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name_category">Name Category</label>
                        <input type="text" wire:model.live="name_category" id="name_category"
                            class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateSize" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Size</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="code_size">Code Size</label>
                        <input type="text" wire:model.live="code_size" id="code_size" class="form-control"
                            onkeyup="this.value = this.value.toUpperCase();">
                        @error('code_size')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name_size">Name Size</label>
                        <input type="text" wire:model.live="name_size" id="name_size" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@livewireScripts()
<script>
    function clearForm() {
        const formFields = {
            text: ['code', 'barcode', 'name'],
            select: ['unit', 'brand_code', 'category_code', 'size_code', 'supplier_code'],
            number: ['qtyunit'],
            checkbox: ['inventory', 'sales', 'purchase']
        };

        formFields.text.forEach(id => document.getElementById(id).value = '');
        formFields.select.forEach(id => document.getElementById(id).selectedIndex = 0);
        formFields.number.forEach(id => document.getElementById(id).value = 0);
        formFields.checkbox.forEach(id => document.getElementById(id).checked = false);
    }

    function handleEditItem(code) {
        Livewire.dispatch('isEdit', {
            code: code,
        });
    }

    Livewire.on('openModalforEdit', (data) => {
        const formFields = {
            text: {
                'code': data[0].code,
                'barcode': data[0].barcode,
                'name': data[0].name,
                'unit': data[0].unit_code,
                'qtyunit': data[0].qtyunit,
                'brand_code': data[0].brand_code,
                'category_code': data[0].category_code,
                'size_code': data[0].size_code,
                'supplier_code': data[0].supp_code
            },
            checkbox: {
                'inventory': data[0].inventory,
                'sales': data[0].sales,
                'purchase': data[0].purchase,
                'isConsignment': data[0].consignment
            }
        };

        Object.entries(formFields.text).forEach(([id, value]) => {
            $(`#${id}`).val(value);
        });

        Object.entries(formFields.checkbox).forEach(([id, value]) => {
            $(`#${id}`).prop('checked', value);
        });

        setTimeout(() => {
            $('#modalCreate').modal('show');
        }, 500);
    });

    const initDataTable = () => {
        $.fn.dataTable.ext.errMode = 'none';
        new DataTable('#example', {
            order: [],
            language: {
                search: "Search:",
                lengthMenu: "Show _MENU_ entries",
                info: "Showing _START_ to _END_ of _TOTAL_ entries",
                paginate: {
                    first: "First",
                    last: "Last",
                    next: "Next",
                    previous: "Previous"
                }
            }
        });
    };

    Livewire.on('openModalBuat', () => {
        $('#modalCreate').modal('show');
        Livewire.dispatch('resetTheSession');
    });
    Livewire.on('openModalInfoSupplier', () => {
        $('#modalInfoSupplier').modal('show');
        $(document).ready(initDataTable);
    });

    Livewire.on('refreshjs', () => {
        $(document).ready(initDataTable);
    });

    Livewire.on('successImport', () => {
        const RELOAD_DELAY = 3000;
        setTimeout(() => {
            window.location.reload();
        }, RELOAD_DELAY);
    });

    Livewire.on('cancelImport', () => {
        window.location.reload();

    });

    Livewire.on('closeModal', () => {
        const CLEAR_DELAY = 500;
        $('#modalCreate').modal('hide');
        setTimeout(clearForm, CLEAR_DELAY);
    });

    document.addEventListener('keydown', (event) => {
        const isModalShortcut = event.ctrlKey && event.shiftKey && event.key === 'N';
        if (isModalShortcut) {
            event.preventDefault();
            $('#modalCreate').modal('show');
        }
    });
</script>
@if ($istutorials)
    <script>
        const productPopup = () => {
            const driver = window.driver.js.driver;
            const driverObj = driver({
                showProgress: true,
                steps: [

                    {
                        element: '.add-product-pop',
                        popover: {
                            description: 'By clicking this button, you can add a product.'
                        }
                    },
                    {
                        element: '.konsinyasi-item-pop',
                        popover: {
                            description: 'For consignment products, one item can only have one supplier. When adding an item, check the consignment option if it is a consignment product, and select the appropriate supplier.'
                        }
                    },
                    {
                        element: '.edit-product-pop',
                        popover: {
                            description: 'You can edit items here.'
                        }
                    },
                    {
                        element: '.go-good-receipt-pop',
                        popover: {
                            description: 'Now you can receive goods. You can go directly to the goods receiving page (Inventory > Transaction > Receivings).'
                        }
                    },
                ],
                onDeselected: () => {
                    $.ajax({
                        type: "POST",
                        url: '/update-status-driver',
                        data: {
                            menu: "Product",
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {},
                        error: function(data, textStatus, errorThrown) {},
                    });
                }
            });

            driverObj.drive();
        }
    </script>
@endif
