<div wire:ignore.self>
    <style>
        .large-td {
            width: 200px;
            /* Adjust the width as needed */
            height: 50px;
            /* Adjust the height as needed */
        }
    </style>
    <div class="product-page py-12 mt-2">
        <div class="header" x-data="{ isInputGroupVisible: {{ session('fromCashier') ? 'true' : 'false' }} }"
            @keydown.window="if ($event.ctrlKey && ($event.key === 'ArrowRight' || $event.key === 'ArrowLeft')) { 
        isInputGroupVisible = !isInputGroupVisible; 
        @this.call('changeTable'); 
        }">
            <div class="d-flex justify-content-start">
                <div class="form-check" @click="isInputGroupVisible = !isInputGroupVisible" data-toggle="tooltip"
                    title="Click to show/hide">
                    <button class="btn btn-sm mb-4 add-product-pop"
                        style="background: #ee32ff1f; color: #ee32ff; border-radius: 1rem">
                        @if ($isTable)
                            + Add
                        @else
                            <div class="d-flex justify-content-center gap-1 align-items-center">
                                <div style="width: 17px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                    </svg>
                                </div>
                                Table
                            </div>
                        @endif
                    </button>
                </div>
            </div>

            <div class="mb-4" x-show="isInputGroupVisible">
                @if (!$chunks)
                    <div style="display: flex; justify-content: end">
                        <a data-bs-target="#modalCreate" data-bs-toggle="modal"
                            onclick="Livewire.dispatch('createNewItem')"
                            class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3 mb-3 add-item-pop shadow-md">+
                            Add Item</a>
                    </div>
                    <div class="p-4" style="border: 1px dashed rgba(46, 46, 46, 0.288); border-radius: .5rem">
                        <div class="fs-4 fw-semibold mb-2">
                            Import File
                        </div>
                        <label for="importFile" class="form-label">{{ __('Supported formats') }} <span
                                class="text-danger">*.csv, *.xlsx</span>
                        </label>
                        <input wire:model="file" type="file"
                            class="form-control @error('file') is-invalid @enderror form-control-md" id="importFile"
                            name="importFile" accept=".csv, .xlsx"
                            style="background: transparent; border-radius: .5rem">
                        @error('file')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button wire:click="toImportItem" type="button"
                                class="btn btn-success btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                @if (!$file) disabled @endif>
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                    </svg>
                                </div>
                                {{ __('Import') }}
                            </button>
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm rounded-3 fs-6 px-4 d-flex justify-content-center align-items-center gap-2"
                                onclick="window.location.href='/assets/template/Template Item.xlsx'">
                                <div style="width: 16px; height: auto;">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                        stroke-width="1.5" stroke="currentColor" class="size-6">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5M16.5 12 12 16.5m0 0L7.5 12m4.5 4.5V3" />
                                    </svg>
                                </div>
                                {{ __('Download Template') }}
                            </button>
                        </div>
                    </div>
                @endif
                @if ($chunks)
                    @if (!$editChunks)
                        <button class="btn btn-primary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="saveChunks">Save</button>
                    @endif
                    @if ($editChunks)
                        <button class="btn btn-success btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                            wire:click="modeEditFalse">Save
                            Edit</button>
                    @else
                        <button class="btn btn-warning btn-sm ml-4 rounded-3 fs-6 px-4 mt-3" wire:click="modeEditTrue">
                            Edit</button>
                    @endif
                    <button class="btn btn-secondary btn-sm ml-4 rounded-3 fs-6 px-4 mt-3"
                        wire:click="cancelImport">Cancel</button>

                    @if($this->hasDuplicates)
                        <div class="d-flex justify-content-end gap-2 mb-3">
                            <button wire:click="downloadDuplicates('xlsx')" class="btn btn-sm btn-outline-primary rounded-3">
                                <i class="fas fa-file-excel me-1"></i> Ekspor Data Duplikat
                            </button>
                           
                        </div>
                    @endif
                @endif
                <div class="table-responsive table-member-tablet mt-4">
                    @if ($chunks)
                        <table class="my-table" @if (!$editChunks) id="example" @endif
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th style="text-align: center; border-top-left-radius: .5rem">No</th>
                                    <th style="text-align: center">Code</th>
                                    <th style="text-align: center">Barcode</th>
                                    <th style="text-align: center">Name</th>
                                    <th style="text-align: center">Brand Code</th>
                                    <th style="text-align: center">Category Code</th>
                                    <th style="text-align: center">Size Code</th>
                                    <th style="text-align: center">Inventory</th>
                                    <th style="text-align: center">Sales</th>
                                    <th style="text-align: center">Purchase</th>
                                    <th style="text-align: center">Consignment</th>
                                    <th style="text-align: center">Price</th>
                                    <th style="text-align: center; border-top-right-radius: .5rem">Supplier Code</th>

                                </tr>
                            </thead>
                            <tbody>
                                @if ($editChunks)
                                    @foreach ($chunks as $index => $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.code">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.barcode">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.name">
                                            </td>
                                            <td class="large-td"><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.brand_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.category_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.size_code"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.inventory"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.sales">
                                            </td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.purchase"></td>
                                            <td><input type="text" class="form-control"
                                                    wire:model.lazy="chunks.{{ $index }}.consignment">
                                            </td>
                                            <td><input type="text"
                                                    class="form-control"wire:model.lazy="chunks.{{ $index }}.price">
                                            </td>
                                            <td><input type="text"
                                                    class="form-control"wire:model.lazy="chunks.{{ $index }}.supplier_code">
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    @foreach ($chunks as $item)
                                        <tr>
                                            <td style="text-align: center">{{ $loop->iteration }}</td>
                                            <td>{{ $item['code'] }}</td>
                                            <td>{{ $item['barcode'] }}</td>
                                            <td>{{ $item['name'] }}</td>
                                            <td>{{ $item['brand_code'] }}</td>
                                            <td>{{ $item['category_code'] }}</td>
                                            <td>{{ $item['size_code'] }}</td>
                                            <td>{{ $item['inventory'] }}</td>
                                            <td>{{ $item['sales'] }}</td>
                                            <td>{{ $item['purchase'] }}</td>
                                            <td>{{ $item['consignment'] }}</td>
                                            <td>{{ $item['price'] }}</td>
                                            <td>{{ $item['supplier_code'] }}</td>


                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>

            @if ($isTable)
                <div class="card p-4 bg-transparent" x-show="!isInputGroupVisible">
                    <div class="table-responsive">
                        <div class="mb-3 d-flex justify-content-between">
                            <div class="d-flex align-items-center">
                                <label class="me-2">Show</label>
                                <select wire:model.live="perPage" class="form-control form-select-sm me-2">
                                    <option value="10">10</option>
                                    <option value="20">20</option>
                                    <option value="50">50</option>
                                </select>
                                <label class="">entries</label>
                            </div>
                            <div class="d-flex align-items-center">
                                <label class="me-2">Search</label>
                                <input wire:model.live="search" type="text" class="form-control form-control-sm"
                                    placeholder="Search">
                            </div>
                        </div>
                        <table class="my-table" style="width:100%">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                    <th scope="col" wire:click="doSort('code')" style="cursor: pointer">
                                        {{ __('Code') }}
                                        @if($sortColumn === 'code')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </th>
                                    <th scope="col" wire:click="doSort('barcode')" style="cursor: pointer">
                                        {{ __('Barcode') }}
                                        @if($sortColumn === 'barcode')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </th>
                                    <th scope="col" wire:click="doSort('name')" style="cursor: pointer">
                                        {{ __('Name') }}
                                        @if($sortColumn === 'name')
                                            <i class="fas fa-sort-{{ $sortDirection === 'ASC' ? 'up' : 'down' }} ms-1"></i>
                                        @else
                                            <i class="fas fa-sort ms-1 text-muted"></i>
                                        @endif
                                    </th>
                                    <th scope="col">{{ __('Brand') }}</th>
                                    <th scope="col">{{ __('Category') }}</th>
                                    <th scope="col">{{ __('Size') }}</th>
                                    @if ($activeUDFs->isNotEmpty())
                                        @foreach ($activeUDFs as $udf)
                                            <th scope="col">{{ __($udf->field) }}</th>
                                        @endforeach
                                    @endif
                                    <th scope="col" style="text-align: center">{{ __('Consignment') }}</th>
                                    <th scope="col" style="border-top-right-radius: .5rem">{{ __('Action') }}</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse ($items as $key => $item)
                                    <tr>
                                        <th scope="row">{{ $items->firstItem() + $key }}</th>
                                        <td>{{ $item->code }}</td>
                                        <td>{{ $item->barcode }}</td>
                                        <td>{{ $item->name }}</td>
                                        <td>{{ $item->brand->name ?? '-' }}</td>
                                        <td>{{ $item->category->name ?? '-' }}</td>
                                        <td>{{ $item->size->name ?? '-' }}</td>
                                        @if ($activeUDFs->isNotEmpty())
                                            @foreach ($activeUDFs as $udf)
                                                <td>{{ $item->{$udf->field} ?? '-' }}</td>
                                            @endforeach
                                        @endif
                                        <td style="text-align: center">
                                            @if ($item->consignment == 'Y')
                                                <span class="badge bg-success" role="button"
                                                    wire:click="$dispatch('openSupplierModal', {code: '{{ $item->code }}'})">Yes</span>
                                            @else
                                                <span class="badge bg-danger">No</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group gap-2" role="group">
                                                <button class="btn btn-sm btn-primary" onclick="handleEditItem('{{ $item->code }}')">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                        <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                                        <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z"/>
                                                    </svg>
                                                </button>
                                                <button class="btn btn-sm btn-danger" onclick="openDeleteModal('{{ $item->code }}', '{{ $item->name }}')">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                        <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5Zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6Z"/>
                                                        <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1ZM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118ZM2.5 3h11V2h-11v1Z"/>
                                                    </svg>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-center">No items found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        {{ $items->links('vendor.livewire.bootstrap') }}
                    </div>
                </div>
            @endif
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="deleteConfirmModal" tabindex="-1"
        aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Confirmation</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete <strong id="deleteItemName"></strong> ?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" onclick="confirmDelete()"
                        data-bs-dismiss="modal">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" id="modalInfoSupplier" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Item & Supplier Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Name</label>
                            <p class="text-secondary mb-0">{{ $infoitem_name ?? '-' }}</p>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Code</label>
                            <p class="text-secondary mb-0">{{ $infoitem_code ?? '-' }}</p>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label fw-bold">Item Barcode</label>
                            <p class="text-secondary mb-0">{{ $infoitem_barcode ?? '-' }}</p>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Supplier Name</label>
                            <p class="text-secondary mb-0">{{ $infosupplier_name ?? '-' }}</p>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Supplier Code</label>
                            <p class="text-secondary mb-0">{{ $infosupplier_code ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade modal-lg" data-bs-backdrop="static" id="modalCreate" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel" tabindex="-1">

        <div class="modal-dialog modal-dialog-centered  modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel">
                        @if ($isEdit)
                            Edit
                        @else
                            Create
                        @endif Item
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        onclick="clearForm()"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        @if (!$isEdit)
                            <div class="form-check mb-2">
                                <input type="checkbox" class="form-check-input" id="auto_code"
                                    wire:model.live="autoGenerateCode">
                                <label class="form-check-label" for="auto_code">Generate Code</label>
                            </div>
                        @endif
                        <div class="form-group">
                            <label for="code">Code</label>
                            <input type="text" id="code" class="form-control mb-2"
                                style="text-transform: uppercase" wire:model.live="code"
                                oninput="this.value = this.value.toUpperCase()"
                                @if ($autoGenerateCode || $isEdit) disabled @endif>
                            @error('code')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        <label for="code">Barcode</label>
                        <input type="text" wire:model.live="barcode" id="barcode" class="form-control mb-2">
                        @error('barcode')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" wire:model.live="name" id="name" class="form-control mb-2">
                        @error('name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    @if ($unit_code)
                        <div class="form-group">
                            <label for="name">Qty / {{ $unit_label }}</label>
                            <input type="number" wire:model.live="qtyunit" id="qtyunit"
                                class="form-control mb-2">
                            @error('name')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group">
                        <label for="brand_code">Brand </label>
                        <select class="form-select mb-2" wire:model.live="brand_code" id="brand_code">
                            <option value="">-- Select Brand --</option>
                            <option value="BrandCN">{{ empty($name_brand) ? '**Create New**' : $name_brand }}</option>

                            @foreach ($itemBrand as $brand)
                                <option value="{{ $brand->code }}">{{ $brand->name }}</option>
                            @endforeach
                        </select>
                        @if ($isCreateNewBrand)
                            <button data-bs-target="#modalCreateBrand" data-bs-toggle="modal" data-bs-dismiss="modal"
                                class="btn badge bg-primary">Open Form Brand</button>
                        @endif
                        @error('brand_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                        @error('code_brand')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="category_code">Category </label>
                        <select class="form-select mb-2" wire:model.live="category_code" id="category_code">
                            <option value="">-- Select Category --</option>
                            <option value="CategoryCN">{{ empty($name_category) ? '**Buat Baru**' : $name_category }}
                            </option>
                            @foreach ($itemCategory as $cat)
                                <option value="{{ $cat->code }}">{{ $cat->name }}</option>
                            @endforeach

                        </select>
                        @if ($isCreateNewCategory)
                            <button data-bs-target="#modalCreateCategory" data-bs-toggle="modal"
                                data-bs-dismiss="modal" class="btn badge bg-primary">Open Form Category</button>
                        @endif
                        @error('category_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                        @error('code_category')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="size_code">Size </label>
                        <select class="form-select mb-2" wire:model.live="size_code" id="size_code">
                            <option value="">-- Select Size --</option>
                            <option value="SizeCN">{{ empty($name_size) ? '**Buat Baru**' : $name_size }}</option>

                            @foreach ($itemSize as $size)
                                <option value="{{ $size->code }}">{{ $size->name }}</option>
                            @endforeach
                        </select>
                        @if ($isCreateNewSize)
                            <button data-bs-target="#modalCreateSize" data-bs-toggle="modal" data-bs-dismiss="modal"
                                class="btn badge bg-primary">Open Form Size</button>
                        @endif
                        @error('size_code')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                        @error('code_size')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    @if (!empty($activeUDFs))
                        @foreach ($activeUDFs as $udf)
                            <div class="form-group mb-2">
                                <label for="{{ $udf->field }}">{{ $udf->field }}</label>
                                <input type="{{ $udf->type }}" wire:model.live="udfFields.{{ $udf->field }}"
                                    id="udfFields.{{ $udf->field }}" class="form-control udf-input">
                                @error("udfFields.{$udf->field}")
                                    <small class="text-danger d-block mt-1">{{ $message }}</small>
                                @enderror
                            </div>
                        @endforeach
                    @endif

                    <div class="d-flex justify-content-between mt-2">
                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="isConsignment" id="isConsignment"
                                class="form-check-input" @if ($isEdit && !$canEditSupplier) disabled @endif>
                            <label for="consignment" class="form-check-label">Consignment</label>
                            @error('isConsignment')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="inventory" id="inventory"
                                class="form-check-input">
                            <label for="inventory" class="form-check-label">Inventory</label>
                            @error('inventory')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="form-check mr-3">
                            <input type="checkbox" wire:model.live="sales" id="sales" class="form-check-input">
                            <label for="sales" class="form-check-label">Sales</label>
                            @error('sales')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="form-check">
                            <input type="checkbox" wire:model.live="purchase" id="purchase"
                                class="form-check-input">
                            <label for="purchase" class="form-check-label">Purchase</label>
                            @error('purchase')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>


                    @if ($isConsignment)
                        <div class="form-group mt-3">
                            <label for="supplier_code">Supplier</label>
                            <select wire:model.live="supplier_code" id="supplier_code" class="form-select"
                                @if ($isEdit && !$canEditSupplier) disabled @endif>
                                <option value="">-- Select Supplier --</option>
                                @foreach ($suppliers as $supplier)
                                    <option value="{{ $supplier->code }}">{{ $supplier->name }}</option>
                                @endforeach
                                <option value="SupplierCN">
                                    {{ empty($suppliernew_name) ? '**Buat Baru**' : $suppliernew_name }}
                            </select>
                            @error('supplier_code')
                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                            @enderror
                        </div>

                        @if ($isCreateNewSupplier)
                            <button data-bs-target="#modalCreateSupplier" data-bs-toggle="modal"
                                data-bs-dismiss="modal" class="btn badge bg-primary">Open Form Supplier</button>
                        @endif
                        

                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"
                        onclick="clearForm()">Close</button>
                    <button type="button" class="btn btn-primary" @if ($errors->any() || $name == '') disabled @endif
                        @if ($isEdit) wire:click="saveUpdate"
                    @else wire:click="save" @endif>
                        @if ($isEdit)
                            Edit
                        @else
                            Save
                        @endif
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateSupplier" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Supplier</h5>
                    <button type="button" class="btn-close" data-bs-target="#modalCreate" data-bs-toggle="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="name">Supplier Name</label>
                        <input type="text" wire:model.live="suppliernew_name" id="name"
                            class="form-control mb-2">
                        @error('suppliernew_name')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="address">Address</label>
                        <input type="text" wire:model.live="suppliernew_address" id="address"
                            class="form-control mb-2">
                        @error('suppliernew_address')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="phone">Phone</label>
                        <input type="text" wire:model.live="suppliernew_phone" id="phone"
                            class="form-control mb-2">
                        @error('suppliernew_phone')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group mb-3">
                        <label for="email">Email</label>
                        <input type="text" wire:model.live="suppliernew_email" id="email"
                            class="form-control mb-2">
                        @error('suppliernew_email')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="shared_margin">Shared Margin (%)</label>
                        <input type="number" wire:model.live="shared_margin" id="shared_margin"
                            class="form-control mb-2">
                        @error('shared_margin')
                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateUnit" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Unit</h5>
                    <button type="button" class="btn-close" data-bs-target="#modalCreate" data-bs-toggle="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">


                    <div class="form-group">
                        <label for="name">Name Unit</label>
                        <input type="text" wire:model.live="name_unit" id="name_unit" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateBrand" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Brand</h5>
                    <button type="button" class="btn-close"data-bs-target="#modalCreate" data-bs-toggle="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div x-data="{
                        autoGenerate: false,
                        codeBrand: '',
                        generateCode() {
                            const random = Math.random().toString(36).substring(2, 7).toUpperCase();
                            this.codeBrand = 'BRD-' + random;
                    
                            // Notify Livewire of the change
                            this.$nextTick(() => {
                                const input = document.getElementById('code_brand');
                                input.dispatchEvent(new Event('input'));
                            });
                        }
                    }" x-init="if (autoGenerate) generateCode()">

                        @if (!$isEdit)
                            <!-- Checkbox: Generate Code -->
                            <div class="form-check mb-2">
                                <input type="checkbox" class="form-check-input" id="auto_code"
                                    x-model="autoGenerate" @change="autoGenerate ? generateCode() : codeBrand = ''">
                                <label class="form-check-label" for="auto_code">Generate Code</label>
                            </div>
                        @endif
                        <!-- Input: Code Brand -->
                        <div class="form-group">
                            <label for="code_brand">Code Brand</label>
                            <input type="text" id="code_brand" class="form-control" x-model="codeBrand"
                                :disabled="autoGenerate" @input="codeBrand = codeBrand.toUpperCase()"
                                wire:model.live="code_brand">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="name">Name Brand</label>
                        <input type="text" wire:model.live="name_brand" id="name_brand" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateCategory" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="Create">Modal Create Category</h5>
                    <button type="button" class="btn-close" data-bs-target="#modalCreate" data-bs-toggle="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div x-data="{
                        autoGenerate: false,
                        codeCategory: '',
                        generateCode() {
                            const random = Math.random().toString(36).substring(2, 7).toUpperCase();
                            this.codeCategory = 'CAT-' + random;
                    
                            this.$nextTick(() => {
                                const input = document.getElementById('code_category');
                                input.dispatchEvent(new Event('input'));
                            });
                        }
                    }" x-init="if (autoGenerate) generateCode()">
                        @if (!$isEdit)
                            <!-- Checkbox to auto-generate -->
                            <div class="form-check mb-2">
                                <input type="checkbox" class="form-check-input" id="auto_code"
                                    x-model="autoGenerate"
                                    @change="autoGenerate ? generateCode() : codeCategory = ''">
                                <label class="form-check-label" for="auto_code">Generate Code</label>
                            </div>
                        @endif
                        <!-- Input for Code Category -->
                        <div class="form-group">
                            <label for="code_category">Code Category</label>
                            <input type="text" id="code_category" class="form-control" x-model="codeCategory"
                                :disabled="autoGenerate" @input="codeCategory = codeCategory.toUpperCase()"
                                wire:model.live="code_category">
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="name_category">Name Category</label>
                        <input type="text" wire:model.live="name_category" id="name_category"
                            class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCreateSize" data-bs-backdrop="static" aria-hidden="true"
        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal Create Size</h5>
                    <button type="button" class="btn-close" data-bs-target="#modalCreate" data-bs-toggle="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div x-data="{
                        autoGenerate: false,
                        codeSize: '',
                        generateCode() {
                            const random = Math.random().toString(36).substring(2, 7).toUpperCase();
                            this.codeSize = 'SIZ-' + random;
                    
                            // Notify Livewire that input has changed
                            this.$nextTick(() => {
                                const input = document.getElementById('code_size');
                                input.dispatchEvent(new Event('input'));
                            });
                        }
                    }" x-init="if (autoGenerate) generateCode()">
                        @if (!$isEdit)
                            <!-- Checkbox to auto-generate -->
                            <div class="form-check mb-2">
                                <input type="checkbox" class="form-check-input" id="auto_code"
                                    x-model="autoGenerate" @change="autoGenerate ? generateCode() : codeSize = ''">
                                <label class="form-check-label" for="auto_code">Generate Code</label>
                            </div>
                        @endif
                        <!-- Code Size Input -->
                        <div class="form-group">
                            <label for="code_size">Code Size</label>
                            <input type="text" id="code_size" class="form-control" x-model="codeSize"
                                :disabled="autoGenerate" @input="codeSize = codeSize.toUpperCase()"
                                wire:model.live="code_size">
                        </div>
                    </div>


                    <div class="form-group">
                        <label for="name_size">Name Size</label>
                        <input type="text" wire:model.live="name_size" id="name_size" class="form-control">
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" data-bs-target="#modalCreate" data-bs-toggle="modal"
                        data-bs-dismiss="modal">Save</button>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts()
<script>
    let deleteCode = null;

    function openDeleteModal(code, name) {
        deleteCode = code;
        document.getElementById('deleteItemName').textContent = name;

        $('#deleteConfirmModal').modal('show');

    }

    function confirmDelete() {
        if (deleteCode) {
            Livewire.dispatch('markAsDeleted', {
                code: deleteCode
            });
            deleteCode = null;
        }

        const modal = bootstrap.Modal.getInstance(document.getElementById('deleteConfirmModal'));
        modal.hide();
    }

    function clearForm() {
        const formFields = {
            text: ['code', 'barcode', 'name'],
            select: ['unit', 'brand_code', 'category_code', 'size_code', 'supplier_code'],
            number: ['qtyunit'],
            checkbox: ['auto_code', 'consignment']
        };

        document.querySelectorAll('.udf-input').forEach(input => {
            input.value = '';
            input.dispatchEvent(new Event('input'));
        });


        // Clear text inputs
        formFields.text.forEach(id => {
            const el = document.getElementById(id);
            if (el) {
                el.value = '';
                el.dispatchEvent(new Event('input')); // notify Livewire
            }
        });

        // Reset select elements to first option
        formFields.select.forEach(id => {
            const el = document.getElementById(id);
            if (el) {
                el.selectedIndex = 0; // select the first option
                el.dispatchEvent(new Event('input')); // notify Livewire
            }
        });

        // Reset number inputs
        formFields.number.forEach(id => {
            const el = document.getElementById(id);
            if (el) {
                el.value = 0;
                el.dispatchEvent(new Event('input')); // notify Livewire
            }
        });

        // Uncheck checkboxes
        formFields.checkbox.forEach(id => {
            const checkbox = document.getElementById(id);
            if (checkbox) {
                checkbox.checked = false;
                checkbox.dispatchEvent(new Event('change')); // for Livewire/Alpine sync
            }
        });
    }


    function handleEditItem(code) {
        Livewire.dispatch('isEdit', {
            code: code,
        });
    }

    Livewire.on('openModalforEdit', (data) => {
        const formFields = {
            text: {
                'code': data[0].code,
                'barcode': data[0].barcode,
                'name': data[0].name,
                'unit': data[0].unit_code,
                'qtyunit': data[0].qtyunit,
                'brand_code': data[0].brand_code,
                'category_code': data[0].category_code,
                'size_code': data[0].size_code,
                'supplier_code': data[0].supp_code
            },
            checkbox: {
                'inventory': data[0].inventory,
                'sales': data[0].sales,
                'purchase': data[0].purchase,
                'isConsignment': data[0].consignment
            }
        };

        Object.entries(formFields.text).forEach(([id, value]) => {
            $(`#${id}`).val(value);
        });

        Object.entries(formFields.checkbox).forEach(([id, value]) => {
            $(`#${id}`).prop('checked', value);
        });

        setTimeout(() => {
            $('#modalCreate').modal('show');
        }, 500);
    });

    const initDataTable = () => {
        $.fn.dataTable.ext.errMode = 'none';
        new DataTable('#example', {
            order: [],
            language: {
                search: "Search:",
                lengthMenu: "Show _MENU_ entries",
                info: "Showing _START_ to _END_ of _TOTAL_ entries",
                paginate: {
                    first: "First",
                    last: "Last",
                    next: "Next",
                    previous: "Previous"
                }
            }
        });
    };
    Livewire.on('getGeneratedCode', (code) => {
        document.getElementById('code').value = code;
    });


    Livewire.on('openModalBuat', () => {
        $('#modalCreate').modal('show');
        Livewire.dispatch('resetTheSession');
    });
    Livewire.on('openModalInfoSupplier', () => {
        $('#modalInfoSupplier').modal('show');
        $(document).ready(initDataTable);
    });

    Livewire.on('refreshjs', () => {
        $(document).ready(initDataTable);
    });

    Livewire.on('successImport', () => {
        const RELOAD_DELAY = 3000;
        setTimeout(() => {
            window.location.reload();
        }, RELOAD_DELAY);
    });

    Livewire.on('cancelImport', () => {
        window.location.reload();

    });

    Livewire.on('closeModal', () => {
        const CLEAR_DELAY = 500;
        $('#modalCreate').modal('hide');
        setTimeout(clearForm, CLEAR_DELAY);
    });

    document.addEventListener('keydown', (event) => {
        const isModalShortcut = event.ctrlKey && event.shiftKey && event.key === 'N';
        if (isModalShortcut) {
            event.preventDefault();
            $('#modalCreate').modal('show');
        }
    });
</script>
@if ($istutorials)
    <script>
        const productPopup = () => {
            const driver = window.driver.js.driver;
            const driverObj = driver({
                showProgress: true,
                steps: [

                    {
                        element: '.add-product-pop',
                        popover: {
                            description: 'By clicking this button, you can add a product.'
                        }
                    },
                    {
                        element: '.konsinyasi-item-pop',
                        popover: {
                            description: 'For consignment products, one item can only have one supplier. When adding an item, check the consignment option if the product is consignment, and select the appropriate supplier.'
                        }
                    },
                    {
                        element: '.edit-product-pop',
                        popover: {
                            description: 'You can edit items here.'
                        }
                    },
                    {
                        element: '.go-good-receipt-pop',
                        popover: {
                            description: 'Now you can receive goods. You can go directly to the receiving page (Inventory>Transaction>Receivings).'
                        }
                    },
                ],
                onDeselected: () => {
                    $.ajax({
                        type: "POST",
                        url: '/update-status-driver',
                        data: {
                            menu: "Product",
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {},
                        error: function(data, textStatus, errorThrown) {},
                    });
                }
            });

            driverObj.drive();
        }
    </script>
@endif

