<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb align-items-center">
                    <li class="breadcrumb-item">
                        <a href="{{ route('item') }}">{{ __('Items') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Insert') }}
                    </li>
                    <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                        <span class="me-2">{{ $insertType }}</span>
                        @if ($insertType == 'Item Pricelist')
                            @admin
                                <select class="form-select form-select-sm filter-it-pop" wire:model.live="whs_code"
                                    style="width: auto;">
                                    @foreach ($warehouse as $whs)
                                        <option value="{{ $whs->code }}">{{ $whs->name }}</option>
                                    @endforeach
                                </select>
                            @else
                                <span class="me-2">{{ userWarehouse() }} </span>
                            @endadmin

                        @endif
                    </li>
                </ol>
            </div>
        </nav>

        <div class="d-flex" style="flex-direction: column" id="cashier">
            {{-- <h4>{{ $insertType }} <br>
                @if ($insertType == 'Item Pricelist')
                    {{ userWarehouse() }}
                @endif
            </h4> --}}
            {{-- <div class="align-items-center justify-content-between small">
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Pricelist')"
                    @if ($insertType == 'Pricelist') disabled @endif>Pricelist</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Size')"
                    @if ($insertType == 'Size') disabled @endif>Size</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Category')"
                    @if ($insertType == 'Category') disabled @endif>Category</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Brand')"
                    @if ($insertType == 'Brand') disabled @endif>Brand</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Unit')"
                    @if ($insertType == 'Unit') disabled @endif>Unit</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Item')"
                    @if ($insertType == 'Item') disabled @endif>Item</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Item Pricelist')"
                    @if ($insertType == 'Item Pricelist') disabled @endif>Item Pricelist</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Supplier')"
                    @if ($insertType == 'Supplier') disabled @endif>Supplier</button>
                <button class="btn btn-badge btn-primary mb-1" wire:click="changeInsert('Sales')"
                    @if ($insertType == 'Sales') disabled @endif>Sales</button>
            </div> --}}
            {{-- <hr /> --}}
            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="">
                        <div class="card-body">
                            @if ($insertType == 'Pricelist')
                                <livewire:pos.item.insert-pricelist wire:key="insert-pricelist" />
                            @elseif($insertType == 'Size')
                                <livewire:pos.item.insert-size wire:key="insert-size" />
                            @elseif($insertType == 'Category')
                                <livewire:pos.item.insert-category wire:key="insert-category" />
                            @elseif($insertType == 'Brand')
                                <livewire:pos.item.insert-brand wire:key="insert-brand" />
                            @elseif($insertType == 'Unit')
                                <livewire:pos.item.insert-unit wire:key="insert-unit" />
                            @elseif ($insertType == 'Item')
                                <livewire:pos.item.insert-item wire:key="insert-item" />
                            @elseif($insertType == 'Item Pricelist')
                                <livewire:pos.item.insert-item-pricelist wire:key="insert-itempricelist" />
                            @elseif($insertType == 'Supplier')
                                <livewire:pos.item.insert-supplier wire:key="insert-supplier" />
                            @elseif($insertType == 'Sales')
                                <livewire:pos.item.insert-employee wire:key="insert-sales" />
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts

<script>
    function handleEditItemPricelist(code, pricelistcode) {
        Livewire.dispatch('editItemPricelist', {
            code: code,
            pricelistcode: pricelistcode
        });
    }

    Livewire.on('closemodalCreate', () => {
        $('#modalCreate').modal('hide');
    });

    Livewire.on('openModalEdit', () => {
        $('#modalEditPricelistItem').modal('show');
    });
    Livewire.on('closeModalEdit', () => {
        $('#modalEditPricelistItem').modal('hide');
    });

    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 1000); 
    });
</script>
