<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb align-items-center">
                    <li class="breadcrumb-item">
                        <a href="{{ route('item') }}">{{ __('Items') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Insert') }}
                    </li>
                    <li class="breadcrumb-item d-flex align-items-center" aria-current="page">
                        <span class="me-2">Item Pricelist</span>
                      
                           

                    </li>
                </ol>
            </div>
        </nav>

        <div class="d-flex" style="flex-direction: column" id="cashier">
            <div class="d-flex align-items-center gap-2">
                <div class="fs-4 fw-semibold">Item Unit</div>
                <div class="badge text-primary" style="background: #2282ff38">{{ $nameUnit }}</div>
            </div>
            
            {{-- <h4>Item Unit<br>
                
                    {{ userWarehouse() }} <br><span class="text-primary">({{ $nameUnit }})</span>
            </h4> --}}

            <div class="row">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="">
                        <div class="card-body mb-3">
                            <livewire:pos.item.insert-unit-item wire:key="insert-unit-item" :param="$param" />

                            {{-- <livewire:pos.item.insert-item-pricelist wire:key="insert-itempricelist" :param="$param" /> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts


<script>
    function handleEditUnitItem(code, unitcode) {
        Livewire.dispatch('editUnitItem', {
            code: code,
            unitcode: unitcode
        });
    }

    Livewire.on('closemodalCreate', () => {
        $('#modalCreateUnitItem').modal('hide');
    });

    Livewire.on('openModalEdit', () => {
        $('#modalEditUnitItem').modal('show');
    });
    Livewire.on('closeModalEdit', () => {
        $('#modalEditUnitItem').modal('hide');
    });

    Livewire.on('refreshjs', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 1000);
    });
</script>
