<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="{{ route('item-transfer.index') }}">{{ __('Item Transfer') }} </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Create Item Transfer') }} {{ $ITSess }}
                    </li>
                </ol>
            </div>
        </nav>
        <div class="" id="cashier">
            <div class="col-sm-6 col-md-6 col-lg-4 mb-2">
                <div class="form-group">
                    <div class="d-flex" style="align-items: center; justify-content: space-between;">
                        <div class="d-flex flex-column">
                            <label for="dateInput">Date </label>
                            <input type="date" class="form-control rounded" id="dateInput" wire:model.live="date"
                                placeholder="Choose Date" autocomplete="off">
                        </div>

                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="checkboxInput"
                                wire:model.live="isRequest">
                            <label class="form-check-label" for="checkboxInput">Request</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3 mb-2" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        @if ($isRequest)
                            <label for="searchItemInput">Create Request To Store</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                                placeholder="Search Store"
                                @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                                x-on:keydown.enter="
            if(selectedIndexWarehouse == -1) {

            }else{
                $wire.selectWarehouse(selectedIndexWarehouse);
                selectedIndexWarehouse = -1;
            }"
                                autocomplete="off">
                        @else
                            <label for="searchItemInput">From Store</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                                placeholder="Search Store"
                                @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                                x-on:keydown.enter="
                if(selectedIndexWarehouse == -1) {

                }else{
                    $wire.selectWarehouse(selectedIndexWarehouse);
                    selectedIndexWarehouse = -1;
                }"
                            autocomplete="off" @admin @else disabled
                            @endadmin>
                    @endif

                </div>
                @if ($selectedWarehouse === null)
                    @if ($resultwarehouse)
                        <div class="dropdown-menu d-block py-0">
                            @foreach ($resultwarehouse as $index => $item)
                                <div class="px-2 py-1 border-bottom"
                                    :class="{ 'bg-primary': selectedIndexWarehouse === {{ $index }} }">
                                    <div class="d-flex flex-column ml-3">
                                        <button type="button" class="btn btn-link"
                                            :class="{ 'text-white': selectedIndexWarehouse === {{ $index }} }"
                                            wire:click="selectWarehouseByClick('{{ $item->code }}')">
                                            {{ $item->code }} || {{ $item->name }}
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @endif
            </div>
        </div>
        <div class="col-sm-4 col-md-4 col-lg-3 mb-2">
            <div class="form-group">
                <div class="d-flex" style="flex-direction: column">
                    <label for="textAreaInput">Remarks</label>
                    <textarea class="form-control rounded" id="textAreaInput" placeholder="Enter details" rows="1"
                        style="width: 500px;" wire:model.live="remarks" autocomplete="off"></textarea>
                    @error('remarks')
                        <small class="text-danger d-block mt-1"> {{ $message }}</small>
                    @enderror
                </div>
            </div>
        </div>

        @if ($selectedWarehouse)
            <div class="row mt-2">

                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouseto: null }" x-init="selectedIndexWarehouseto = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            @if ($isRequest)
                                <label for="searchItemInput">From Store</label>
                            @else
                                <label for="searchItemInput">Search Store</label>
                            @endif
                            @if ($isRequest)
                                <input type="text" class="form-control rounded"
                                    wire:model.debounce.100ms.live="searchwarehouseto" id="searchWarehouseInput2"
                                    placeholder="Search Store"
                                    @keydown.arrow-down.prevent="selectedIndexWarehouseto = Math.min(selectedIndexWarehouseto + 1, 10)"
                                    @keydown.arrow-up.prevent="selectedIndexWarehouseto = Math.max(selectedIndexWarehouseto - 1, -1)"
                                    x-on:keydown.enter="
                    if(selectedIndexWarehouseto == -1) {
    
                    }else{
                        $wire.selectWarehouseto(selectedIndexWarehouseto);
                        selectedIndexWarehouseto = -1;
                    }"
                                autocomplete="off" @admin @else disabled
                                @endadmin>
                        @else
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchwarehouseto" id="searchWarehouseInput2"
                                placeholder="Search Store"
                                @keydown.arrow-down.prevent="selectedIndexWarehouseto = Math.min(selectedIndexWarehouseto + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexWarehouseto = Math.max(selectedIndexWarehouseto - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexWarehouseto == -1) {
    
                    }else{
                        $wire.selectWarehouseto(selectedIndexWarehouseto);
                        selectedIndexWarehouseto = -1;
                    }"
                                autocomplete="off">
                        @endif
                    </div>
                    @if ($selectedWarehouseto === null)
                        @if ($resultwarehouseto)
                            <div class="dropdown-menu d-block py-0">
                                @foreach ($resultwarehouseto as $index => $item)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexWarehouseto === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link"
                                                :class="{ 'text-white': selectedIndexWarehouseto === {{ $index }} }"
                                                wire:click="selectWarehousetoByClick('{{ $item->code }}')">
                                                {{ $item->code }} || {{ $item->name }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    @endif
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3 mb-2" x-data="{ selectedIndexItem: null }" x-init="selectedIndexItem = -1">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="searchItemInput">Item</label>
                        <input type="text" class="form-control rounded"
                            wire:model.debounce.100ms.live="searchitem" id="searchItemInput"
                            placeholder="Select Item"
                            @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                            @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                            x-on:keydown.enter="
                    if(selectedIndexItem == -1) {
                        $wire.selectItemByName();
                    }else{
                        $wire.selectItem(selectedIndexItem);
                        selectedIndexItem = -1;
                    }"
                            autocomplete="off">
                    </div>
                    @if ($selectedItem === null)
                        @if ($resultitem)
                            <div class="dropdown-menu d-block py-0">
                                @foreach ($resultitem as $index => $item)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexItem === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link"
                                                :class="{ 'text-white': selectedIndexItem === {{ $index }} }"
                                                wire:click="selectItemByClick('{{ $item->code }}')">
                                                @if ($isRequest)
                                                    {{ $item->code }} || {{ $item->name }} ||
                                                    {{ number_format($item->total_qty) }} pcs
                                                @else
                                                    {{ $item->code }} || {{ $item->name }}
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>
        <div class="row mt-4" style="max-height: 350px">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card-body">
                    <div class="py-12">
                        <div class="table-responsive head-table-no-suggestion">
                            {{-- <table id="example" --}}
                            <table class="my-table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                        <th scope="col">{{ __('Code') }}</th>
                                        <th scope="col">{{ __('Barcode') }}</th>
                                        <th scope="col">{{ __('Name') }}</th>
                                        <th scope="col">{{ __('Qty') }}</th>
                                        <th scope="col">{{ __('Price') }}</th>
                                        <th scope="col" style="border-top-right-radius: 1rem">
                                            {{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody class="small">
                                    @forelse ($tableItems as $index => $item)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $item['code'] }}</td>
                                            <td>{{ $item['barcode'] }}</td>
                                            <td>{{ $item['name'] }}</td>
                                            <td>
                                                <div x-data="{ quantity: 1 }"
                                                    style="display: flex; align-items: center; gap: 5px;">
                                                    <input type="number"
                                                    wire:model.live="tableItems.{{ $index }}.quantity"
                                                    class="form-control"
                                                    min="1"
                                                    oninput="this.value = this.value < 1 || this.value === '' ? 1 : this.value"
                                                    style="flex: 3;">
                                                
                                                    <select class="form-control input-group" id="type"
                                                        wire:model.live="tableItems.{{ $index }}.unit"
                                                        style="flex: 1;">
                                                        <option value="0">pcs</option>
                                                        @foreach ($item['units'] as $unit)
                                                            <option value="{{ $unit->id }}">
                                                                {{ $unit->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </td>
                                            <td>Rp. {{ number_format($item['price'], 0, ',', '.') }}</td>
                                            <td>
                                                <button type="button"
                                                    onclick="handleremoveItem('{{ $index }}');"
                                                    class="btn btn-danger btn-sm">Delete</button>
                                            </td>
                                        </tr>
                                    @empty
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="d-flex justify-content-end mt-4">
            <button wire:click="savetoTable" class="btn btn-primary"
                @if (!$tableItems) disabled @endif>Save</button>
        </div>

    @endif
</div>

</div>
@livewireScripts()
<script>
    function handleremoveItem(index) {
        Livewire.dispatch('removeItem', {
            index: index
        });
    }

    Livewire.on('refreshDatatable', (params) => {
        setTimeout(() => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                new DataTable('#example', {
                    order: [],
                });
            });
        }, 1000);
    });
    document.addEventListener('keydown', function(event) {
        if (event.key === 'F4') {
            event.preventDefault();
            const activeElement = document.activeElement;

            if (activeElement.id === 'searchWarehouseInput2') {
                document.getElementById('searchItemInput').focus();
            } else if (activeElement.id === 'searchItemInput') {
                document.getElementById('searchWarehouseInput2').focus();
            } else {
                document.getElementById('searchWarehouseInput2').focus();
            }
        }
    });
    Livewire.on('activeF4', (params) => {
        document.addEventListener('keydown', function(event) {
            if (event.key === 'F4') {
                event.preventDefault();
                const activeElement = document.activeElement;

                if (activeElement.id === 'searchWarehouseInput2') {
                    document.getElementById('searchItemInput').focus();
                } else if (activeElement.id === 'searchItemInput') {
                    document.getElementById('searchWarehouseInput2').focus();
                } else {
                    document.getElementById('searchWarehouseInput2').focus();
                }
            }
        });
    });

    document.addEventListener('keydown', function(event) {
        if (event.key === 'F1') {
            event.preventDefault();
            const activeElement = document.activeElement;

            if (activeElement.id === 'dateInput') {
                document.getElementById('checkboxInput').focus();
            } else if (activeElement.id === 'checkboxInput') {
                document.getElementById('dateInput').focus();
            } else {
                document.getElementById('dateInput').focus();
            }
        }
        if (event.key === 'F2') {
            event.preventDefault();
            document.getElementById('searchWarehouseInput').focus();
        }
        if (event.key === 'F3') {
            event.preventDefault();
            document.getElementById('textAreaInput').focus();
        }
    });

    document.getElementById('checkboxInput').addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
            event.preventDefault();
            this.checked = !this.checked;
            this.dispatchEvent(new Event('input'));
            this.dispatchEvent(new Event('change'));
        }
    });
</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>
