<div wire:ignore.self class="modal fade" id="modalSyncAll" data-bs-backdrop="static" tabindex="-1" aria-labelledby="modalSyncAllLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSyncAllLabel">Sync Inventory Transfer Request</h5>
                <div id="loadingSpinner" class="spinner-border text-primary" role="status" style="display: none;">
                    <span class="visually-hidden">Loading...</span>
                </div>
                @if($isloading)
                <div id="loadingSpinner" class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                @endif
            </div>
            <div class="modal-body">
                <div class="col-auto">
                    <div class="form-check">
                        <input type="checkbox" id="selectAll" class="form-check-input" wire:model.live="isCheckedAll" checked>
                        <label class="form-check-label" for="selectAll">Sync All</label>
                    </div>
                </div>
            </div>
            <div class="mx-2 row align-items-center">
                <div class="col">
                    <label for="filterBy">Filter By</label>
                    <select id="filterBy" class="form-select" wire:model.live="selectedFilter" @if($isCheckedAll) disabled @endif>
                        <option value="Period">Period</option>
                        <option value="Docnum">Document Number</option>
                    </select>
                </div>
            </div>
            @if(!$isDocnum)
            <div class="mt-2 mx-2 row align-items-center">
                <div class="col">
                    <label for="startDate">Start Date</label>
                    <input type="date" class="form-control" id="startDate" wire:model.live="startDate"  @if($isCheckedAll) disabled @endif>
                </div>
                <div class="col">
                    <label for="endDate">End Date</label>
                    <input type="date" class="form-control" id="endDate" wire:model.live="endDate" @if($isCheckedAll) disabled @endif>
                </div>
            </div>
            @endif
            @if($isDocnum)
            <div class="mt-2 mx-2 row align-items-center">
                <div class="col">
                    <label>IT Docnum</label>
                    <input type="text" class="form-control" wire:model.live="docNum" @if($isCheckedAll) disabled @endif oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                </div>
            </div>
            @endif
            <div wire:ignore.self class="modal-footer mt-4">
                <button type="button" id="closeSyncAll" class="btn btn-danger" data-bs-dismiss="modal" @if($isloading) disabled="true" @endif>Close</button>
            @if($isCheckedAll)
                <button id="buttonSync" type="button" class="btn btn-primary"
                        wire:click="firstClick" 
                        @if($isloading) disabled="true" @endif
                        onclick="disableButton(this)"
                >          
                @if(!$isloading)
                    <span id="innerSpan">Sync all</span>
                @else
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                @endif      
                </button>
            @else
                <button id="buttonSync" type="button" class="btn btn-primary"
                        wire:click="firstClick"
                        @if($isloading) disabled="true" @endif
                        @if($isDocnum && empty($docNum)) disabled="true" @endif onclick="disableButton(this)"
                >
                @if($isDocnum)
                    @if(!$isloading)
                        <span id="innerSpan">Sync by Docnum</span>
                    @else
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    @endif
                @else
                    @if(!$isloading)
                        <span id="innerSpan">Sync by Period</span>
                    @else
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    @endif
                @endif
                </button>
            @endif
            </div>
        </div>
    </div>
</div>
@livewireScripts

<script>
    function disableButton(button) {
        button.disabled = true;
        var closeButton = document.getElementById('closeSyncAll');
        
        if (closeButton !== null) {
            closeButton.disabled = true;
        }

    }
</script>
