<div>
    <div class="page-content bg-white ">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb fs-5">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/it_in">{{ __('Inv Transfer In') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>

                <button wire:click="close" type="button" class="btn btn-secondary btn-sm ml-2">{{ __('Close') }}</button>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card bg-white p-2 mb-3 " style="">
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('IT In Detail no. ') }} <span class="text-dark">{{ $no->no }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Date : ') }} <span class="text-dark">{{ $no->date }}</span></h6>
                        </div>
                        <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                            <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span class="text-dark">{{ $no->comments }}</span></h6>
                        </div>
                    </div>

                    <div class="table-responsive table-it-in-detail">
                        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5 text-dark" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                    <th scope="col">{{ __('Code') }}</th>
                                    <th scope="col">{{ __('Barcode') }}</th>
                                    <th scope="col">{{ __('Name') }}</th>
                                    <th scope="col" style="border-top-right-radius: 1rem">{{ __('Qty') }}</th>
                                </tr>
                            </thead>

                            <tbody class="small">
                                @foreach($details as $key => $detail)
                                <tr>
                                    <th scope="col">{{ $key + 1 }}</td>
                                    <td>{{ $detail->code }}</td>
                                    <td>{{ $detail->barcode }}</td>
                                    <td>{{ $detail->name }}</td>
                                    <td>{{ number_format($detail->qty) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div wire:ignore.self>
                        <table id="table" class="table dataTables_wrapper dt-bootstrap5 text-white" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col" colspan="4"></th>
                                    <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>
                                </tr>
                            </thead>

                            <tbody class="small">
                                
                                <tr>
                                    <td colspan="2">Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td colspan="4"></td>
                                    <td style="text-align: right;">{{ number_format($details->sum('qty'), 0, ',', ',') }}</td>
                                </tr>
                               
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>