<div>
    <div class="container my-4">
        <h2 class="mb-3">Transaction History</h2>
        <div class="accordion" id="transactionAccordion" style="max-height: 800px; overflow-y: auto;">
            @forelse($transaction as $key => $item)
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#transaction{{ $key }}">
                            <div class="d-flex justify-content-between align-items-center w-100 me-2">
                                <span>Order ID: {{ $item->order_id }}</span>
                                <span
                                    class="badge {{ $item->status == 'success' ? 'bg-success' : ($item->status == 'pending' ? 'bg-warning text-dark' : 'bg-danger') }}">{{ ucfirst($item->status) }}</span>
                            </div>
                        </button>
                    </h2>
                    <hr>
                    <div id="transaction{{ $key }}" class="accordion-collapse collapse"
                        data-bs-parent="#transactionAccordion">
                        <div class="accordion-body">
                            <div class="row">
                                @php $details = json_decode($item->detail, true); @endphp

                                <div class="col-md-6">
                                    <h6><strong>Customer Details</strong></h6>
                                    <hr>
                                    <ul class="list-unstyled">
                                        <li><strong>Name:</strong> {{ $details['customer_details']['first_name'] }}
                                            {{ $details['customer_details']['last_name'] }}</li>
                                        <li><strong>Email:</strong> {{ $details['customer_details']['email'] }}</li>
                                        <li><strong>Phone:</strong> {{ $details['customer_details']['phone'] }}</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6><strong>Order Details</strong></h6>
                                    <hr>
                                    <ul class="list-unstyled">
                                        @foreach ($details['item_details'] as $itemDetail)
                                            <li>
                                                <strong>{{ $itemDetail['name'] }}</strong> -
                                                {{ $itemDetail['quantity'] }} x Rp.
                                                {{ number_format($itemDetail['price'], 0, ',', '.') }}
                                            </li>
                                        @endforeach
                                    </ul>
                                    <p><strong>Total:</strong> Rp. {{ number_format($item->amount, 0, ',', '.') }}</p>
                                    <p><strong>Plan:</strong> {{ $item->plan }}</p>
                                    @if ($item->status == 'success')
                                        <p><strong>Renewed At:</strong>
                                            {{ \Carbon\Carbon::parse($item->updated_atrenew)->format('l, d F Y') }}</p>
                                        <p><strong>Expires At:</strong>
                                            {{ \Carbon\Carbon::parse($item->expired_at)->format('l, d F Y') }}</p>
                                    @endif
                                    <p><strong>Excluded Users:</strong>
                                        {{ $item->user_exclude ? implode(', ', array_column(json_decode($item->user_exclude, true), 'username')) : '-' }}
                                    </p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 text-end ">
                                    @if ($item->status == 'pending')
                                        <button class="btn btn-primary"
                                            onclick="getSnap('{{ $item->snap_token }}')">Pay Now</button>
                                    @else
                                        <button
                                            class="btn {{ $item->status == 'success' ? 'btn-success' : 'btn-danger' }}"
                                            disabled>{{ ucfirst($item->status) }}</button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="accordion-item">
                    <div class="accordion-body">
                        <p>No transactions found.</p>
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</div>
@livewireScripts
<script src="https://app.midtrans.com/snap/snap.js"
    data-client-key="{{ config('services.midtrans.clientKey') }}"></script>

<script type="text/javascript">
    function getSnap(no) {
        Livewire.dispatch('getSnap', {
            no: no
        });
    }
    Livewire.on('openTheSnap', () => {
        snap.pay(@this.snapToken, {
            // Optional
            onSuccess: function(result) {
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
                // Livewire.dispatch('onSuccessPay', {
                //     result: result
                // });
            },
            // Optional
            onPending: function(result) {
                /* You may add your own js here, this is just example */
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
            },
            // Optional
            onError: function(result) {
                /* You may add your own js here, this is just example */
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
            }
        });
    })

    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });
</script>
