<div>
    <div class="page-content">
        <div class="" id="cashier">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card-body">
                    <div class="py-12">
                        <div class="table-responsive table-salesemp">
                            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                        <th scope="col">{{ __('Order Id') }}</th>
                                        <th scope="col">{{ __('Status') }}</th>
                                        <th scope="col">{{ __('Detail') }}</th>
                                        <th scope="col">{{ __('Total') }}</th>
                                        <th scope="col">{{ __('Renew At') }}</th>
                                        <th scope="col" style="border-top-right-radius: 1rem">{{ __('Expired At') }}</th>
                                    </tr>
                                </thead>

                                <tbody class="small">
                                    @forelse($transaction as $key => $item)
                                        <tr>
                                            <td scope="col">{{ $loop->iteration }}</td>
                                            <td>
                                                <button
                                                    class="btn {{ $item->status == 'pending' ? 'btn-primary' : ($item->status == 'success' ? 'btn-success' : 'btn-danger') }} content-end goodsReceipt-detail-pop"
                                                    style="padding: 2.5px 5px; font-size: 12px;"
                                                    {{ $item->status == 'pending' ? 'onclick= getSnap(\'' . $item->snap_token . '\')' : 'disabled' }}>
                                                    {{ $item->status == 'pending' ? 'Pay Now' : ($item->status == 'success' ? 'Payment Successful' : 'Payment Failed') }}
                                                </button>
                                            </td>
                                            <td>{{ $item->order_id }}</td>
                                            <td>{{ $item->status }}</td>
                                            <td>
                                                @php
                                                    $details = json_decode($item->detail, true);
                                                @endphp

                                                <div>
                                                    <strong>{{ __('Customer Details') }}:</strong>
                                                    <ul>
                                                        <li><strong>{{ __('First Name') }}:</strong>
                                                            {{ $details['customer_details']['first_name'] }}</li>
                                                        <li><strong>{{ __('Last Name') }}:</strong>
                                                            {{ $details['customer_details']['last_name'] }}</li>
                                                        <li><strong>{{ __('Email') }}:</strong>
                                                            {{ $details['customer_details']['email'] }}</li>
                                                        <li><strong>{{ __('Phone') }}:</strong>
                                                            {{ $details['customer_details']['phone'] }}</li>
                                                    </ul>
                                                </div>

                                                <div>
                                                    <strong>{{ __('Item Details') }}:</strong>
                                                    <ul>
                                                        @foreach ($details['item_details'] as $itemDetail)
                                                            <li>
                                                                <strong>{{ __('Item Name') }}:</strong>
                                                                {{ $itemDetail['name'] }}<br>
                                                                <strong>{{ __('Quantity') }}:</strong>
                                                                {{ $itemDetail['quantity'] }}<br>
                                                                <strong>{{ __('Price') }}:</strong>
                                                                {{ number_format($itemDetail['price'], 2) }}
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </td>
                                            
                                            <td>
                                                {{ 'Rp. ' . number_format($item->amount, 0, ',', '.') }}
                                            </td>
                                            @if ($item->status == 'success')
                                            <td>{{ \Carbon\Carbon::parse($item->updated_atrenew)->format('l, d F Y') }}</td>
                                            <td>{{ \Carbon\Carbon::parse($item->expired_at)->format('l, d F Y') }}</td>
                                            @else
                                                <td> - </td>
                                                <td> - </td>
                                            @endif
                                        </tr>

                                    @empty

                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@livewireScripts
<script src="https://app.midtrans.com/snap/snap.js"
    data-client-key="{{ config('services.midtrans.clientKey') }}"></script>

<script type="text/javascript">
    function getSnap(no) {
        Livewire.dispatch('getSnap', {
            no: no
        });
    }
    Livewire.on('openTheSnap', () => {
        snap.pay(@this.snapToken, {
            // Optional
            onSuccess: function(result) {
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
                // Livewire.dispatch('onSuccessPay', {
                //     result: result
                // });
            },
            // Optional
            onPending: function(result) {
                /* You may add your own js here, this is just example */
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
            },
            // Optional
            onError: function(result) {
                /* You may add your own js here, this is just example */
                document.getElementById('result-json').innerHTML += JSON.stringify(result, null, 2);
            }
        });
    })

    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });
    });
</script>
