<div wire:ignore.self class="modal fade" id="welcomeModal" tabindex="-1" aria-labelledby="welcomeModalLabel"
    aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered custom-width">
        <div class="modal-content rounded-4 border-0">
            <div class="modal-body text-center p-5">
                <h1 class="fs-1.5rem fs-3 fw-bold mb-4 dark-blue">
                    Welcome to<br>Softcomp POS
                </h1>

                <div class="illustration-container mb-4">
                    <img src="{{ asset('assets/popup.png') }}" alt="Welcome Illustration" class="img-fluid"
                        style="max-width: 250px;">
                </div>

                <p class="mb-4">
                    Our program has created an initial sample item "<span class="fw-bold dark-blue">Item01</span>". <br>
                    Customize or add items as per your requirement.<br>
                    Enjoy trying out Softcomp POS!
                </p>
                <div>
                    <p class="mb-4">Please complete your company information or skip.</p>

                    <div>
                        <div class="mb-3 text-start">
                            <label for="nama_perusahaan" class="form-label">Company Name</label>
                            <input type="text" wire:model.defer="nama_perusahaan" class="form-control"
                                id="nama_perusahaan">
                            @error('nama_perusahaan')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="mb-3 text-start">
                            <label for="alamat" class="form-label">Address</label>
                            <textarea wire:model.defer="alamat" class="form-control" id="alamat" rows="2"></textarea>
                            @error('alamat')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="mb-2 text-start">
                            <label for="no_hp" class="form-label">Phone Number</label>
                            <input type="number" wire:model.defer="no_hp" class="form-control" id="no_hp">
                            @error('no_hp')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-center gap-3">
                            {{-- <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">
                                Lewati
                            </button> --}}

                            <button type="button" wire:click="save"
                                class="btn btn-primary px-4 py-2 rounded-3">Save</button>
                            <button type="button" class="btn btn-secondary px-5 py-2 rounded-3" data-bs-dismiss="modal"
                                onclick="Livewire.dispatch('afterCloseGreeting')">
                                Skip
                            </button>
                        </div>
                    </div>
                </div>




                <p class="text-muted mb-2 mt-2">
                    Need help? Contact our support team at
                    <a href="https://wa.me/6285117031010?text=Hello,%20mau%20tanya%20dong%20min."
                        class="text-decoration-none darlk-blue fw-bold" target="_blank">
                        +62 851 1703 1010</a>.
                </p>

            </div>
        </div>
    </div>
</div>

