<div class="mt-lg-3">
    @if (session()->has('message'))
        <div class="alert alert-{{ session('alert-type') }} alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    <livewire:cashier.additem />

    <div class="row mt-2">
        <div class="d-flex gap-2 mb-search">
            <div class="d-flex col-md-12 gap-5 justify-content-between">
                <div class="col-sm-4 col-md-4" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                    <div class="form-group">
                        <div class="d-flex item-search-pop">
                            <input type="text" class="form-control" wire:model="form.itemname"
                                wire:model.live="search" placeholder="Search product" id="searchInput" autofocus
                                autocomplete="off"
                                @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                x-on:keydown.enter="
                                        if(selectedIndex == -1) {
                                            $wire.selectProductByName();
                                        } else {
                                            $wire.selectProduct(selectedIndex);
                                            selectedIndex = -1; 
                                        }"
                                x-on:keydown.tab.prevent="
                                        selectedIndex = Math.min(selectedIndex + 1, {{ count($products) - 1 }});
                                        event.preventDefault();
                                    "
                                @if (auth()->user()->whs_code == '-') disabled @endif>

                            @if ($selectedProduct === null && sizeof($products) > 0)
                                <div class="dropdown-menu d-block py-0 mt-lg-5">
                                    @foreach ($products as $index => $product)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndex === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    wire:click="selectProductByClick('{{ $product->barcode }}')"
                                                    :class="{ 'text-white': selectedIndex === {{ $index }} }">
                                                    {{ $product->code }} || {{ $product->name }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                            <h6 class="p-1 shortcut">F1</h6>
                        </div>
                    </div>
                </div>
                <div class="col-sm-2 col-md-2 d-flex justify-content-end" x-data="{ selectedIndexMember: null }"
                    x-init="selectedIndexMember = -1">
                    <div class="form-group">
                        <div class="d-flex guest-pop">
                            <input type="text" class="form-control" wire:model.debounce.100ms.live="searchmember"
                                id="searchMemberInput" placeholder="Search member"
                                @keydown.arrow-down.prevent="selectedIndexMember = Math.min(selectedIndexMember + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexMember = Math.max(selectedIndexMember - 1, -1)"
                                x-on:keydown.enter="
                            if(selectedIndexMember == -1) {
                                $wire.selectMemberByCode();
            
                            }else{
                                $wire.selectMember(selectedIndexMember);
                                selectedIndexMember = -1;
                            }"
                                autocomplete="off" @if (auth()->user()->whs_code == '-') disabled @endif>
                            <h6 class="p-1 shortcut">F2</h6>
                            {{-- <button class="badge bg-primary ms-2" data-bs-toggle="modal" data-bs-target="#createMemberModal">Buat Member</button> --}}

                        </div>
                        @if ($selectedMember === null && $isDropdownVisible && sizeof($members) > 0)
                            <div class="dropdown-menu d-block py-0">
                                @foreach ($members as $index => $member)
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexMember === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link" data-bs-target="#modalOTP"
                                                :class="{ 'text-white': selectedIndexMember === {{ $index }} }"
                                                data-bs-toggle="modal"
                                                wire:click="selectMemberByClick('{{ $member->code }}')">
                                                {{ $member->phone }} || {{ $member->name }} || {{ $member->email }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
                <input type="text" wire.model="form.itemname" class="form-control form-control-md" readonly
                    @if ($selectedProduct) value="{{ $selectedProduct->name }}" @endif hidden>
                <input type="text" wire.model="form.itemprice" placeholder="0"
                    class="form-control text-right form-control-md" readonly
                    @if ($selectedProduct) value="{{ $price }}" @endif hidden>
                <input type="text" wire.model="form.itemqty" placeholder="0"
                    class="form-control text-right form-control-md" readonly
                    @if ($selectedProduct) value="1" @endif hidden>
            </div>
        </div>

        @livewire('cashier.table')
        <livewire:cashier.invoice />
        <livewire:cashier.select-discount />
        <livewire:cashier.process-discount />
        <livewire:cashier.process-disc-bundling />
        <livewire:member.create-member />

        <div wire:ignore.self class="modal fade " id="salesModal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Sales</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                            wire:click="skipSalesModal"></button>

                    </div>
                    <div class="modal-body">
                        <div class="form-group">

                            <div class="" x-data="{ selectedIndexSales: null }" x-init="selectedIndexSales = -1">
                                <label class="small text-muted mb-1">Sales : {{ $searchsales }}</label>
                                <input type="text" class="form-control" wire:model.live="form.sales"
                                    placeholder="No Sales Employee" hidden>
                                <input type="text" class="form-control" wire:model.debounce.100ms.live="searchsales"
                                    placeholder="No Sales Employee" id="searchSalesModal" autofocus autocomplete="off"
                                    @keydown.arrow-down.prevent="selectedIndexSales = Math.min(selectedIndexSales + 1, {{ count($sales) - 1 }})"
                                    @keydown.arrow-up.prevent="selectedIndexSales = Math.max(selectedIndexSales - 1, -1)"
                                    x-on:keydown.enter="
                                        if(selectedIndexSales == -1) {
                                           
                                        } else {
                                            $wire.selectSalesModal(selectedIndexSales);
                                            selectedIndexSales = -1; 
                                        }"
                                    x-on:keydown.tab.prevent="
        selectedIndexSales = Math.min(selectedIndexSales + 1, {{ count($sales) - 1 }});
        event.preventDefault();
            ">
                                @if ($selectedSales === null && $isDropdownsalesVisible)
                                    <div class="dropdown-menu d-block py-0" style="width:469px;">
                                        @foreach ($sales as $index => $sale)
                                            <div class="px-2 py-1 border-bottom"
                                                :class="{ 'bg-primary': selectedIndexSales === {{ $index }} }">
                                                <div class="d-flex flex-column ml-3">

                                                    <button type="button" class="btn btn-link"
                                                        :class="{ 'text-white': selectedIndexSales === {{ $index }} }"
                                                        wire:click="selectSalesByClick('{{ $sale->code }}')">
                                                        {{ $sale->code }} || {{ $sale->name }}
                                                    </button>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        @if ($searchsales !== '')
                            <button type="button" class="btn btn-primary" wire:click="selectSalesBySave"
                                data-bs-dismiss="modal">Save</button>
                        @else
                            <button type="button" class="btn btn-primary" wire:click="skipSalesModal"
                                data-bs-dismiss="modal">Next</button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalZ" tabindex="-1"
            aria-labelledby="modalZLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <h2>Printer Not Found, Data Saved Without Printing !</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>

        <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="nonSales" tabindex="-1"
            aria-labelledby="nonSalesLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <h2>This item is non sales.</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>

        <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="nonPricelist" tabindex="-1"
            aria-labelledby="nonPricelistLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <h2>There is no pricelist on this item, please make a pricelist for this item on the pricelist
                            page!</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>

        <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="nonActive" tabindex="-1"
            aria-labelledby="nonActiveLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <h2>This item is non active.</h2>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>

        <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalOTP" tabindex="-1"
            aria-labelledby="modalOTPLabel" aria-hidden="true" data-bs-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Insert OTP</h5>
                        <h5>{{ $errMsg }}</h5>
                    </div>
                    <div class="modal-body">
                        <div class="col mb-3">
                            <div class="form-group">
                                <label class="small text-muted mb-1">OTP</label>
                                <div class="d-flex">
                                    <input type="text" class="form-control" wire:model.live="reqOTP" autofocus
                                        autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button id="resendButton" class="btn btn-warning" wire:click="resendOTP"
                                onclick="startCountdown()" @if ($enable) @else disabled @endif>
                                Resend OTP
                            </button>
                            <button class="btn btn-primary" wire:click="verifyOTP">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <livewire:cashier.add-cheapest-item />
    </div>
    <script>
        document.addEventListener('keydown', function(event) {
            if (event.key === 'F2') {
                event.preventDefault();
                if (@this.modalOpen) {
                    Livewire.dispatch('F2ModalOpen');

                } else {
                    document.getElementById('searchMemberInput').focus();
                }

            }
            if (event.key === 'F1') {
                event.preventDefault();
                if (@this.modalOpen) {
                    Livewire.dispatch('F1ModalOpen');

                } else {
                    document.getElementById('searchInput').focus();
                }

            }
        });

        window.addEventListener('keydown', function(event) {
            if (@this.isSalesModalVisible) {
                if (event.key === 'Enter') {
                    @this.selectSalesBySave();
                }
            } else {
                if (event.key === 'Enter') {
                    if (@this.openmodalDisc) {
                        @this.saveDiscount();
                    } else {
                        @this.save();
                    }
                }
            }

        });

        Livewire.on('focusInput', () => {
            setTimeout(() => {
                document.getElementById('searchInput').focus();
            }, 300);
        });

        Livewire.on('keepFocusSales', () => {
            setTimeout(() => {
                document.getElementById('searchSalesModal').focus();
            }, 100);
        });

        Livewire.on('selectedSalesChanged', () => {
            setTimeout(() => {
                $('#salesModal').modal('hide');
            }, 300);
        });
        Livewire.on('printernotfound', () => {
            $('#modalZ').modal('show');
        });

        Livewire.on('itemnonsales', () => {
            $('#nonSales').modal('show');
        });
        Livewire.on('itemnonpricelist', () => {
            $('#nonPricelist').modal('show');
        });

        Livewire.on('itemnonactive', () => {
            $('#nonActive').modal('show');
        });
        Livewire.on('openModalCreateMember', () => {
            $('#createMemberModal').modal('show');
            $('#createMemberModal').on('shown.bs.modal', function() {
                $('#name_member').focus();
            });
        });

        Livewire.on('itemnotfound', () => {
            $('#exampleModal').modal('show');
        });
        Livewire.on('closeModal', () => {
            $('#exampleModal').modal('hide');
        });
        Livewire.on('closeModalCheapest', () => {
            $('#modalCheapest').modal('hide');
        });
        Livewire.on('openTheModal', () => {
            $('#selectDiscount').modal('show');
        });
        Livewire.on('openModalCheapest', () => {
            $('#modalCheapest').modal('show');
        });
        Livewire.on('openModalOTP', () => {
            $('#modalOTP').modal('show');
        });
        Livewire.on('closeModalOTP', () => {
            $('#modalOTP').modal('hide');
        });

        Livewire.on('toPrint', (no) => {
            var url = "{{ route('welcome.print', ':no') }}".replace(':no', no);

            // Open new tab for printing
            var printWindow = window.open(url, "_blank");

            // Focus back on the current window
            window.focus();
        });

        Livewire.on('openModalProcessDiscountBlade', () => {
            $('#modalProcessDiscount').modal('show');
        });

        Livewire.on('openModalProcessDiscBundleBlade', () => {
            $('#modalDiscBundle').modal('show');
        });

        Livewire.on('salesModal', () => {
            $('#salesModal').modal('show');
            setTimeout(() => {
                var searchSalesModal = document.getElementById('searchSalesModal').focus();;
                if (searchSalesModal) {
                    searchSalesModal.focus();
                }
            }, 500); // Adjust the delay as needed after the page has finished reloading
        });

        // Function to update the clock time
        function updateClock() {
            var currentTime = new Date();
            var hours = currentTime.getHours();
            var minutes = currentTime.getMinutes();
            var seconds = currentTime.getSeconds();

            // Add leading zeroes to the time values if less than 10
            hours = (hours < 10 ? '0' : '') + hours;
            minutes = (minutes < 10 ? '0' : '') + minutes;
            seconds = (seconds < 10 ? '0' : '') + seconds;

            // Format the time
            var formattedTime = hours + ':' + minutes + ':' + seconds;

            // Display the time in the HTML element
            document.getElementById('realTimeClock').innerHTML = formattedTime + ' WITA';
        }

        // Update the clock initially
        updateClock();

        // Update the clock every second
        setInterval(updateClock, 1000);

        Livewire.on('countdown', () => {
            let countdown = 15;
            let button = document.getElementById('resendButton');

            Livewire.dispatch('disabledbutton')

            let interval = setInterval(function() {
                countdown--;
                if (countdown > 0) {
                    button.textContent = 'Resend OTP (' + countdown + 's)';
                } else {
                    clearInterval(interval);
                    button.textContent = 'Resend OTP';
                    button.disabled = false;
                    Livewire.dispatch('enablebutton')
                }
            }, 1000);
        });
    </script>
