<div>
    <div wire:ignore.self class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel"
        aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="form-group" wire:key="{{ $refreshKey }}">
                        <div x-data="{ isInputGroupVisible: false }">
                            <div class="form-check" @click="isInputGroupVisible = !isInputGroupVisible"
                                data-toggle="tooltip" title="Click to show/hide voucher">
                                <h5 class="modal-title" style="cursor: pointer;">Payment</h5>
                            </div>

                            <div x-show="isInputGroupVisible" class="form-check">
                                <div class="input-group">
                                    <input type="text" class="form-control" wire:model.live="searchvoucher">
                                    <button class="btn btn-primary" wire:click="applyVoucher">Apply</button>
                                </div>
                                <span class="text-danger">{{ $message }}</span>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        wire:click="closeModalInvoice"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group d-flex justify-content-center align-items-center">
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="cashOption" name="paymentOption"
                                    value="cash" wire:model.live="paymentOption">
                                <label class="form-check-label" for="cashOption">Cash</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F1</h4>
                            </div>

                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="qrisOption" name="paymentOption"
                                    value="qris" wire:model.live="paymentOption">
                                <label class="form-check-label" for="qrisOption">QRIS</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F2</h4>
                            </div>
                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="cardOption" name="paymentOption"
                                    value="card" wire:model.live="paymentOption">
                                <label class="form-check-label" for="cardOption">Card</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F3</h4>
                            </div>
                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="multiOption" name="paymentOption"
                                    value="multi" wire:model.live="paymentOption">
                                <label class="form-check-label" for="multiOption">Multi</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F4</h4>
                            </div>
                        </div>
                        @error('paymentOption')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <hr>
                    @if ($paymentOption !== 'card' && $paymentOption !== 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        @if ($isEnableService)
                            <div class="form-group mt-2 d-flex align-items-center">
                                <label for="serviceAmount" class="me-2">Service:</label>
                                <div class="input-group input-group-sm" style="width: 120px;">
                                    <input type="number" class="form-control form-control-sm"
                                        wire:model.live="customServicePercent" min="0" max="100"
                                        step="0.1">
                                    <span class="input-group-text input-group-text-sm">%</span>
                                </div>
                                <span class="ms-2">Rp. {{ number_format($serviceAmount, 0, ',', '.') }}</span>
                            </div>
                            <div class="form-group mt-2">
                                <label for="totalWithService">Total Amount + Service:</label>
                                <span id="totalWithService">Rp.
                                    {{ number_format($totalWithService, 0, ',', '.') }}</span>
                            </div>
                        @endif
                        @if ($paymentOption === 'cash')
                            <div class="form-group">
                                <label for="payment">Payment:</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp.</span>
                                    <input type="text" id="paymentInput" class="form-control"
                                        wire:model.live.debounce.500ms="payment" autofocus>
                                </div>
                            </div>
                            <div class="form-group mt-2">
                                <label class="fs-3" for="change">Change:</label>
                                <span class="fs-3">Rp. </span><span class="fw-bold text-success fs-3"
                                    wire:model="change">{{ number_format($change, 0, ',', '.') }}</span>
                            </div>
                        @endif
                    @endif
                    @if ($paymentOption === 'card')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        @if ($isEnableService)
                            <div class="form-group mt-2 d-flex align-items-center">
                                <label for="serviceAmount" class="me-2">Service:</label>
                                <div class="input-group input-group-sm" style="width: 120px;">
                                    <input type="number" class="form-control form-control-sm"
                                        wire:model.live="customServicePercent" min="0" max="100"
                                        step="0.1">
                                    <span class="input-group-text input-group-text-sm">%</span>
                                </div>
                                <span class="ms-2">Rp. {{ number_format($serviceAmount, 0, ',', '.') }}</span>
                            </div>
                            <div class="form-group mt-2">
                                <label for="totalWithService">Total Amount + Service:</label>
                                <span id="totalWithService">Rp.
                                    {{ number_format($totalWithService, 0, ',', '.') }}</span>
                            </div>
                        @endif
                        <div class="form-group">
                            <label for="namaBank">Bank Name</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Cardholder Name</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Card Number</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                    @if ($paymentOption === 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        @if ($isEnableService)
                            <div class="form-group mt-2 d-flex align-items-center">
                                <label for="serviceAmount" class="me-2">Service:</label>
                                <div class="input-group input-group-sm" style="width: 120px;">
                                    <input type="number" class="form-control form-control-sm"
                                        wire:model.live="customServicePercent" min="0" max="100"
                                        step="0.1">
                                    <span class="input-group-text input-group-text-sm">%</span>
                                </div>
                                <span class="ms-2">Rp. {{ number_format($serviceAmount, 0, ',', '.') }}</span>
                            </div>
                            <div class="form-group mt-2">
                                <label for="totalWithService">Total Amount + Service:</label>
                                <span id="totalWithService">Rp.
                                    {{ number_format($totalWithService, 0, ',', '.') }}</span>
                            </div>
                        @endif
                        <div class="form-group mt-2">
                            <label for="cash">Cash : </label>
                            <div class="input-group">
                                <span class="input-group-text">Rp.</span>
                                <input type="text" id="cashInput" class="form-control"
                                    wire:model.live.debounce.500ms="cash">
                            </div>
                            <div class="">
                                <label for="totalAmount">Transfer :</label>
                                <span>Rp. </span><span
                                    class="fw-bold">{{ number_format($transfer, 0, ',', '.') }}</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaBank">Bank Name</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Cardholder Name</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Card Number</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                    <hr>
                    <h5 class="mx-4">Customer Origin</h5>
                    <hr>
                    <div class="form-group row justify-content-center">
                        <div class="col-md-4">
                            <div x-data="{
                                open: false,
                                search: '',
                                negaraList: @js($negara),
                                selected: @entangle('selectedNegara'),
                                toggleSelection(code, name, id) {
                                    this.selected = [{ code, name, id }];
                                },
                                isChecked(code) {
                                    return this.selected.some(item => item.code === code);
                                },
                                getSelectedText() {
                                    return this.selected.length > 0 ? this.selected[0].name : 'Select Country';
                                },
                                focusSearchInput() {
                                    this.$refs.searchInputNegara.focus();
                                }
                            }" @click.away="open = false">
                                <label for="typeCardCode">Country</label>
                                <button class="form-control text-start"
                                    x-on:click="open = ! open; $nextTick(() => focusSearchInput())"
                                    x-text="getSelectedText()"></button>
                                <div x-show.important="open" x-transition
                                    class="form-control dropdown-menu d-block py-0 w-auto px-2"
                                    style="max-height: 200px; overflow-y: auto;">
                                    <div class="p-2">
                                        <input type="text" x-ref="searchInputNegara" x-model="search"
                                            placeholder="Search Country..." class="form-control">
                                    </div>
                                    <template
                                        x-for="(negara, index) in negaraList.filter(n => n.name.toLowerCase().includes(search.toLowerCase()))"
                                        :key="negara.code">
                                        <div class="ms-4">
                                            <input type="radio" :id="'radio' + (index + 1)" name="negara"
                                                :value="negara.code" :checked="isChecked(negara.code)"
                                                x-on:change="toggleSelection(negara.code, negara.name, negara.id)">
                                            <label class="ms-2" :for="'radio' + (index + 1)">
                                                <span x-text="negara.name"></span> - (<span
                                                    x-text="negara.code"></span>)
                                            </label>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label for="Usia">Age <span class="text-danger">(±)</span></label>
                            <input type="number" wire:model="usia" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="gender">Gender</label>
                            <select id="gender" name="gender" class="form-control" wire:model="gender">
                                <option value="Man">Man</option>
                                <option value="Ladies">Ladies</option>
                                <option value="Couple">Couple</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    @if ($carts->isNotEmpty())
                        @if ($paymentOption === 'cash')
                            <button type="button" class="btn btn-primary" wire:click="save"
                                {{ $paymentOption === 'cash' && ($payment === '' || $payment == 0) ? 'disabled' : '' }}
                                {{ $paymentOption === 'cash' && $totalAmount > str_replace('.', '', $payment) ? 'disabled' : '' }}>Save</button>
                        @elseif ($paymentOption === 'multi')
                            <button type="button" class="btn btn-primary" wire:click="save"
                                {{ $paymentOption === 'multi' && ($cash === '' || $cash == 0) ? 'disabled' : '' }}>Save</button>
                        @else
                            <button type="button" class="btn btn-primary" wire:click="save">Save</button>
                        @endif
                    @else
                        <button type="button" class="btn btn-primary" disabled>Save</button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function updateChangeUI(changeValue) {
        const changeElement = document.querySelector('.change'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    function updateChangeTransfer(changeValue) {
        const changeElement = document.querySelector('.transfer'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    const paymentInput = document.getElementById('paymentInput');
    const cashInput = document.getElementById('cashInput');
    const totalAmountElement = document.getElementById('totalAmount');
    const totalWithServiceElement = document.getElementById('totalWithService');

    function extractNumericValue(element) {
        if (element) {
            const numericValue = parseFloat(element.textContent.replace(/[^\d]/g, ''));
            return isNaN(numericValue) ? 0 : numericValue;
        }
        return 0;
    }

    const totalAmount = extractNumericValue(totalAmountElement);
    const totalWithService = extractNumericValue(totalWithServiceElement);

    function calculateChange() {
        let inputValue = parseFloat(paymentInput.value.replace(/\./g, ''));

        if (!isNaN(inputValue)) {
            // Check if isEnableService is true by looking for the totalWithService element
            const isServiceEnabled = totalWithServiceElement !== null;
            const totalToUse = isServiceEnabled ? totalWithService : totalAmount;
            const change = inputValue - totalToUse;
            updateChangeUI(change);
        }
    }

    paymentInput.addEventListener('input', calculateChange);
    calculateChange();

    window.addEventListener('keydown', function(event) {
        if (event.ctrlKey && event.key === 'i') {

            if (@this.modalOpen) {
                var paymentInput = document.getElementById('paymentInput');
                var cashInput = document.getElementById('cashInput');
                if (paymentInput) {
                    paymentInput.focus();
                } else {
                    cashInput.focus();
                }
            } else {}
        }

        if (event.ctrlKey && event.key === '1') {
            event.preventDefault();

            if (@this.modalOpen) {
                document.getElementById('namaPemegangKartu').focus();
            } else {}
        }
        if (event.ctrlKey && event.key === '2') {
            event.preventDefault();

            if (@this.modalOpen) {
                document.getElementById('nomorKartu').focus();
            } else {}
        }

        if (event.key === 'Escape' || event.key === 'Esc') {
            event.preventDefault();

            if (@this.modalOpen) {
                @this.closeModalInvoice();
                $('#invoiceModal').modal('hide');

            } else {}
        }
        if (event.ctrlKey && event.key === 's') {
            event.preventDefault();

            if (@this.modalOpen) {
                if (@this.cashfulfil || @this.paymentfulfil || @this.paymentOption == 'qris') {
                    if (@this.selectedSales) {
                        @this.save();
                    } else {
                        @this.save();
                    }
                } else {}

            } else {}
        }
    });
    Livewire.on('openModalInvoice', () => {
        $('#invoiceModal').modal('show');
    });

    Livewire.on('reloadTheInv', () => {
        setTimeout(() => {
            window.location.reload(true);
        }, 5000);
    });

    var rupiah = document.getElementById('paymentInput');
    rupiah.addEventListener('keyup', function(e) {
        // tambahkan 'Rp.' pada saat form di ketik
        // gunakan fungsi formatRupiah() untuk mengubah angka yang di ketik menjadi format angka
        rupiah.value = formatRupiah(this.value);
    });

    /* Fungsi formatRupiah */
    function formatRupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        // tambahkan titik jika yang di input sudah menjadi angka ribuan
        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? +rupiah : '');
    }

    Livewire.on('updatedPaymentOption', () => {
        setTimeout(() => {
            const paymentInput = document.getElementById('paymentInput');
            const cashInput = document.getElementById('cashInput');
            if (paymentInput) {
                paymentInput.addEventListener('keyup', function(e) {
                    this.value = formatRupiah(this.value);
                });
            }

            if (cashInput) {
                cashInput.addEventListener('keyup', function(e) {
                    this.value = formatRupiah(this.value);
                });
            }
        }, 1000);
    });

    Livewire.on('refreshInvoice', () => {
        setTimeout(() => {
            window.location.reload(true);
        }, 3000);
    });
</script>
