<div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalCheapest" tabindex="-1"
    aria-labelledby="modalCheapestLabel" aria-hidden="true" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Cheapest Item</h5>
            </div>
            <div class="modal-body">
                <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                    <div class="form-group">
                        <label class="small text-muted mb-1">Product Code</label>
                        <div class="d-flex">
                            <input type="text" class="form-control" wire:model.live="searchcheapest"
                                placeholder="Search Product"
                                id="searchInputModal" autofocus autocomplete="off"
                                @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }">
                        </div>

                        @if ($selectedProduct === null && sizeof($products) > 0)
                            <div class="dropdown-menu d-block py-0" style="width: 770px">
                                @foreach ($products as $index => $product)
                                <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndex === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button"
                                                wire:click="selectProductByClick('{{ $product->code }}')"
                                                class="btn btn-link"
                                                :class="{ 'text-white': selectedIndex === {{ $index }} }">
                                                {{ $product->code }} || {{ $product->name }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" id="saveButton" class="btn btn-primary" data-bs-dismiss="modal"
                        wire:click="save" wire:keydown.enter="save"
                        @if (!$selectedProduct) disabled @endif>Save</button>
                </div>
            </div>
        </div>
    </div>
