<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="">

<head>
    <script>
        (function() {
            const storedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const theme = storedTheme || (prefersDark ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', theme);
        })();
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-192x192.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-512x512.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/apple-touch-icon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-16x16.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-32x32.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon.ico') }}" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Softcomp.io</title>

    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="{{ asset('assets/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.css" />

    <style>
        .modal {
            backdrop-filter: blur(5px);
        }

        .sidebar-icon .dropdown-menu {
            display: none;
            margin-top: .5rem;
            margin-bottom: 1.5rem;
            background-color: transparent;
            border: none;
        }

        .sidebar-icon .dropdown-menu.show {
            display: block;
        }

        .nav-link.active {
            background-color: purple;
            color: white;
            /* Agar teksnya terlihat jelas */
        }
    </style>
    @stack('styles')
    @livewireStyles
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body>

    <div id="app" class="bg-home">
        <div class="d-flex justify-content-center align-items-center">
            <div class="">
                @auth
                    <button id="sidebarToggleBtn" class="sidebar-pop">
                        <div id="sidebarToggle" class="">
                            <img id="arrowImage" src="{{ asset('assets/right-arrow (1).png') }}"
                                style="height: 13px; width: auto" alt="Image Description">
                        </div>
                    </button>

                    <div id="overlay" class="overlay"></div>

                    <div id="sidebar" class="sidebar">
                        <div class="p-4">
                            <div id="" class="d-flex justify-content-center logo">
                                <img id="" src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}"
                                    alt="Image Description">
                            </div>
                            <div class="mt-4 gap-5"
                                style="display: flex; justify-content: space-between; flex-direction: column">
                                <div>
                                    <div class="sidebar-icon">
                                        <button id="toggleThemeButton" class="bg-transparent" style="border: none;"
                                            data-toggle="tooltip" rel="tooltip" data-placement="right" title="color mode"
                                            height="25px" width="25px">
                                            <i id="themeIcon" class="bi bi-moon-fill"></i>
                                        </button>
                                    </div>
                                    <div class="sidebar-icon">
                                        <a class="navbar-brand" href="{{ url('/') }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                                            </svg>
                                            <h2>Home</h2>
                                        </a>
                                    </div>
                                    {{-- <div class="sidebar-icon">
                                        <a class="nav-link {{ request()->routeIs('welcome.*') ? 'active' : '' }}"
                                            href="{{ route('welcome.dashboard') }}">{{ __('') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px"
                                                title="cashier">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                                            </svg>
                                            <h2>Cashier</h2>
                                        </a>
                                    </div> --}}

                                    <div class="sidebar-icon">
                                        <a class="nav-link {{ request()->routeIs('member.*') ? 'active' : '' }}"
                                            href="{{ route('member.index') }}">{{ __('') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px"
                                                title="member">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                                            </svg>
                                            <h2>Member</h2>
                                        </a>
                                    </div>
                                    <div class="sidebar-icon">
                                        <a class="nav-link {{ request()->routeIs('item') ? 'active' : '' }}"
                                            href="{{ route('item') }}">{{ __('') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px"
                                                title="item">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                            </svg>
                                            <h2>Item</h2>
                                        </a>
                                    </div>
                                    <div class="sidebar-icon">
                                        <a class="nav-link {{ request()->routeIs('activity-log') ? 'active' : '' }}"
                                            href="{{ route('activity-log') }}">{{ __('') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="1.5" stroke="currentColor" height="30px" width="30px"
                                                title="activity-log">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
                                            </svg>
                                            <h2>Activity Log</h2>
                                        </a>
                                    </div>
                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo"
                                        aria-expanded="{{ request()->routeIs('item.*') || request()->routeIs('warehouse.*') || request()->routeIs('salesemp') || request()->routeIs('promo.*') || request()->routeIs('user.*') ? 'true' : 'false' }}"
                                        aria-controls="collapseTwo">
                                        <div class="accordion" id="accordionExample">
                                            <div class="">
                                                <h2 class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('item.*', 'warehouse.*', 'salesemp', 'promo.*', 'user.*') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            height="30px" width="30px" title="master">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="m7.875 14.25 1.214 1.942a2.25 2.25 0 0 0 1.908 1.058h2.006c.776 0 1.497-.4 1.908-1.058l1.214-1.942M2.41 9h4.636a2.25 2.25 0 0 1 1.872 1.002l.164.246a2.25 2.25 0 0 0 1.872 1.002h2.092a2.25 2.25 0 0 0 1.872-1.002l.164-.246A2.25 2.25 0 0 1 16.954 9h4.636M2.41 9a2.25 2.25 0 0 0-.16.832V12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 12V9.832c0-.287-.055-.57-.16-.832M2.41 9a2.25 2.25 0 0 1 .382-.632l3.285-3.832a2.25 2.25 0 0 1 1.708-.786h8.43c.657 0 1.281.287 1.709.786l3.284 3.832c.163.19.291.404.382.632M4.5 20.25h15A2.25 2.25 0 0 0 21.75 18v-2.625c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125V18a2.25 2.25 0 0 0 2.25 2.25Z" />
                                                        </svg>
                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseTwo" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Master
                                                        </div>
                                                    </a>
                                                </h2>
                                                <div id="collapseTwo" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="">
                                                        <div class="accordion" id="sub-accordionExample">
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingTwo">
                                                                    <div class="collapsed d-flex justify-content-between"
                                                                        type="" data-bs-toggle="collapse"
                                                                        data-bs-target="#sub-collapseTwo"
                                                                        aria-expanded="false"
                                                                        aria-controls="sub-collapseTwo">
                                                                        <div class="sidebar-icon">
                                                                            <a class="nav-link dropdown-toggle">
                                                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                                                    fill="none" viewBox="0 0 24 24"
                                                                                    stroke-width="1.5"
                                                                                    stroke="currentColor" height="30px"
                                                                                    width="30px" title="item">
                                                                                    <path stroke-linecap="round"
                                                                                        stroke-linejoin="round"
                                                                                        d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                                </svg>
                                                                                <h2>Product</h2>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </h2>
                                                                <div id="sub-collapseTwo"
                                                                    class="accordion-collapse accordion-body collapse"
                                                                    aria-labelledby="sub-headingTwo"
                                                                    data-bs-parent="#sub-accordionExample">
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Brand')">
                                                                                    Brand
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Category')">
                                                                                    Category
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Unit')">
                                                                                    Unit
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Size')">
                                                                                    Size
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Pricelist')">
                                                                                    Pricelist
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    @admin
                                                                                        @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('item.input') }}')"
                                                                                        @else
                                                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Item Pricelist')" @endif
                                                                                    @else
                                                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Item Pricelist')"
                                                                                    @endadmin>
                                                                                    Item Pricelist
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Item')">
                                                                                    Item
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                    <div class="accordion-item p-1">
                                                                        <h2 class="accordion-header" id="sub-headingOne">
                                                                            <div class="sidebar-icon">
                                                                                <a class="nav-link"
                                                                                    href="{{ route('item.input') }}"
                                                                                    onclick="navigate(event, '{{ route('item.input') }}', 'Supplier')">
                                                                                    Supplier
                                                                                </a>
                                                                            </div>
                                                                        </h2>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('promo.*') ? 'active' : '' }}"
                                                                            href="{{ route('promo.index') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9.568 3H5.25A2.25 2.25 0 0 0 3 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 0 0 5.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 0 0 9.568 3Z" />
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M6 6h.008v.008H6V6Z" />
                                                                            </svg>

                                                                            <h2>Promo</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            @admin
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('warehouse.*') ? 'active' : '' }}"
                                                                            href="{{ route('warehouse.index') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                                            </svg>
                                                                            <h2>Toko</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            @endadmin
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('salesemp') ? 'active' : '' }}"
                                                                            href="{{ route('salesemp') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="salesemp">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z" />
                                                                            </svg>
                                                                            <h2>Sales Employees</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            @admin
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('user.*') ? 'active' : '' }}"
                                                                            href="{{ route('user.index') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M15 19.128a9.38 9.38 0 0 0 2.625.372 9.337 9.337 0 0 0 4.121-.952 4.125 4.125 0 0 0-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 0 1 8.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0 1 11.964-3.07M12 6.375a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0Zm8.25 2.25a2.625 2.625 0 1 1-5.25 0 2.625 2.625 0 0 1 5.25 0Z" />
                                                                            </svg>
                                                                            <h2>User Management</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            @endadmin
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne">

                                        <div class="accordion" id="accordionExample" style="border: none">
                                            <div class="">
                                                <h2 class="" id="headingOne">
                                                    <a
                                                        class="nav-link dropdown-toggle {{ request()->routeIs('welcome.dashboard', 'po.index', 'pr.index', 'item-transfer.index', 'opname') ? 'active' : '' }}">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M7.5 21 3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5" />
                                                        </svg>
                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseOne" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Transaction
                                                        </div>
                                                    </a>
                                                </h2>
                                                <div id="collapseOne" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="">
                                                        <div class="accordion" id="sub-accordionExample">
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header nav-link" id="sub-headingOne">
                                                                    <div class="sidebar-icon">

                                                                        <a class="nav-link {{ request()->routeIs('welcome.*') ? 'active' : '' }}"
                                                                            @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('welcome.dashboard') }}')" @endif
                                                                            href="{{ route('welcome.dashboard') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M13.5 21v-7.5a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349M3.75 21V9.349m0 0a3.001 3.001 0 0 0 3.75-.615A2.993 2.993 0 0 0 9.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 0 0 2.25 1.016c.896 0 1.7-.393 2.25-1.015a3.001 3.001 0 0 0 3.75.614m-16.5 0a3.004 3.004 0 0 1-.621-4.72l1.189-1.19A1.5 1.5 0 0 1 5.378 3h13.243a1.5 1.5 0 0 1 1.06.44l1.19 1.189a3 3 0 0 1-.621 4.72M6.75 18h3.75a.75.75 0 0 0 .75-.75V13.5a.75.75 0 0 0-.75-.75H6.75a.75.75 0 0 0-.75.75v3.75c0 .414.336.75.75.75Z" />
                                                                            </svg>
                                                                            <h2>POS</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('po.*') ? 'active' : '' }}"
                                                                            href="{{ route('po.index') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Receipt">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" />
                                                                            </svg>
                                                                            <h2>Goods Receipt</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('pr.*') ? 'active' : '' }}"
                                                                            href="{{ route('pr.index') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Return">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                                            </svg>
                                                                            <h2>Goods Return</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('item-transfer.*') ? 'active' : '' }}"
                                                                            href="{{ route('item-transfer.index') }}"
                                                                            @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('item-transfer.index') }}')" @endif>{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Item Transfer">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                            </svg>
                                                                            <h2>Item Transfer</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('opname') ? 'active' : '' }}"
                                                                            href="{{ route('opname') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="opname">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
                                                                            </svg>
                                                                            <h2>Opname</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                        data-bs-target="#collapseThree">

                                        <div class="accordion" id="accordionExample" style="border: none">
                                            <div class="">
                                                <h2 class="" id="headingOne">
                                                    <a class="nav-link dropdown-toggle">{{ __('') }}
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                                                        </svg>

                                                        <div class="" type="" data-bs-toggle="collapse"
                                                            data-bs-target="#collapseThree" aria-expanded="true"
                                                            aria-controls="collapseOne">
                                                            Report
                                                        </div>
                                                    </a>
                                                </h2>
                                                <div id="collapseThree" class="accordion-collapse collapse"
                                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                    <div class="">
                                                        <div class="accordion" id="sub-accordionExample">

                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportinvoicereturnsale') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportinvoicereturnsale') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 0 0 2.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 0 0-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 0 0 .75-.75 2.25 2.25 0 0 0-.1-.664m-5.8 0A2.251 2.251 0 0 1 13.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25ZM6.75 12h.008v.008H6.75V12Zm0 3h.008v.008H6.75V15Zm0 3h.008v.008H6.75V18Z" />
                                                                            </svg>

                                                                            <h2>Report Sale & Return Sale</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reporttransactionmember') ? 'active' : '' }}"
                                                                            href="{{ route('report.reporttransactionmember') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="member">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M15.75 6a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0ZM4.501 20.118a7.5 7.5 0 0 1 14.998 0A17.933 17.933 0 0 1 12 21.75c-2.676 0-5.216-.584-7.499-1.632Z" />
                                                                            </svg>
                                                                            <h2>Report Transaction Member</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.voucher') ? 'active' : '' }}"
                                                                            href="{{ route('report.voucher') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z" />
                                                                            </svg>

                                                                            <h2>Report Voucher</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportgoodsreceipt') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportgoodsreceipt') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Receipt">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" />
                                                                            </svg>

                                                                            <h2>Report Goods Receipt</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportgoodsreturn') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportgoodsreturn') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Goods Return">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                                            </svg>

                                                                            <h2>Report Goods Return</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportopname') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportopname') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="opname">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
                                                                            </svg>

                                                                            <h2>Report Opname</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reporttransfer') ? 'active' : '' }}"
                                                                            href="{{ route('report.reporttransfer') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                height="30px" width="30px"
                                                                                title="Item Transfer">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0-3-3m3 3 3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                                                            </svg>

                                                                            <h2>Report Item Transfer</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportstock') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportstock') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z" />
                                                                            </svg>

                                                                            <h2>Report Stock</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                            <div class="accordion-item">
                                                                <h2 class="accordion-header" id="sub-headingOne">
                                                                    <div class="sidebar-icon">
                                                                        <a class="nav-link {{ request()->routeIs('report.reportstockcard') ? 'active' : '' }}"
                                                                            href="{{ route('report.reportstockcard') }}">{{ __('') }}
                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                fill="none" viewBox="0 0 24 24"
                                                                                stroke-width="1.5" stroke="currentColor"
                                                                                class="size-6">
                                                                                <path stroke-linecap="round"
                                                                                    stroke-linejoin="round"
                                                                                    d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z" />
                                                                            </svg>

                                                                            <h2>Report Stock Card</h2>
                                                                        </a>
                                                                    </div>
                                                                </h2>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="sidebar-icon" style="cursor: pointer" data-bs-toggle="collapse"
                                    data-bs-target="#collapseFour">

                                    <div class="accordion" id="accordionExample" style="border: none">
                                        <div class="">
                                            <h2 class="" id="headingOne">
                                                <a class="nav-link dropdown-toggle">{{ Auth::user()->name }}
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                        height="30px" width="30px" title="Logout">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                    </svg>
                                                    <div class="" type="" data-bs-toggle="collapse"
                                                        data-bs-target="#collapseFour" aria-expanded="true"
                                                        aria-controls="collapseOne">
                                                        Logout
                                                    </div>
                                                </a>
                                            </h2>
                                            <div id="collapseFour" class="accordion-collapse collapse"
                                                aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                <div class="">
                                                    <div class="accordion" id="sub-accordionExample">
                                                        <div class="accordion-item">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('changepass') ? 'active' : '' }}"
                                                                        href="{{ route('changepass') }}">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            height="30px" width="30px"
                                                                            title="Change Password">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="m15 15 6-6m0 0-6-6m6 6H9a6 6 0 0 0 0 12h3" />
                                                                        </svg>
                                                                        <h2>Change Password</h2>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('settings') ? 'active' : '' }}"
                                                                        href="{{ route('settings') }}"
                                                                        @if (auth()->user()->whs_code == '-') onclick="navigateToSelectItem(event, '{{ route('settings') }}')" @endif>
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            class="size-6">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M10.343 3.94c.09-.542.56-.94 1.11-.94h1.093c.55 0 1.02.398 1.11.94l.149.894c.07.424.384.764.78.93.398.164.855.142 1.205-.108l.737-.527a1.125 1.125 0 0 1 1.45.12l.773.774c.39.389.44 1.002.12 1.45l-.527.737c-.25.35-.272.806-.107 1.204.165.397.505.71.93.78l.893.15c.543.09.94.559.94 1.109v1.094c0 .55-.397 1.02-.94 1.11l-.894.149c-.424.07-.764.383-.929.78-.165.398-.143.854.107 1.204l.527.738c.32.447.269 1.06-.12 1.45l-.774.773a1.125 1.125 0 0 1-1.449.12l-.738-.527c-.35-.25-.806-.272-1.203-.107-.398.165-.71.505-.781.929l-.149.894c-.09.542-.56.94-1.11.94h-1.094c-.55 0-1.019-.398-1.11-.94l-.148-.894c-.071-.424-.384-.764-.781-.93-.398-.164-.854-.142-1.204.108l-.738.527c-.447.32-1.06.269-1.45-.12l-.773-.774a1.125 1.125 0 0 1-.12-1.45l.527-.737c.25-.35.272-.806.108-1.204-.165-.397-.506-.71-.93-.78l-.894-.15c-.542-.09-.94-.56-.94-1.109v-1.094c0-.55.398-1.02.94-1.11l.894-.149c.424-.07.765-.383.93-.78.165-.398.143-.854-.108-1.204l-.526-.738a1.125 1.125 0 0 1 .12-1.45l.773-.773a1.125 1.125 0 0 1 1.45-.12l.737.527c.35.25.807.272 1.204.107.397-.165.71-.505.78-.929l.15-.894Z" />
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                                                                        </svg>

                                                                        <h2>Settings</h2>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <div class="accordion-item">
                                                            <h2 class="accordion-header" id="sub-headingOne">
                                                                <div class="sidebar-icon">
                                                                    <a class="nav-link {{ request()->routeIs('logouts') ? 'active' : '' }}"
                                                                        href="{{ route('logouts') }}"
                                                                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            fill="none" viewBox="0 0 24 24"
                                                                            stroke-width="1.5" stroke="currentColor"
                                                                            height="30px" width="30px" title="Logout">
                                                                            <path stroke-linecap="round"
                                                                                stroke-linejoin="round"
                                                                                d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                                                                        </svg>
                                                                        <h2>Logout</h2>
                                                                    </a>
                                                                </div>
                                                            </h2>
                                                        </div>

                                                        <form id="logout-form" action="{{ route('logouts') }}"
                                                            method="POST" class="d-none">
                                                            @csrf
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                @endauth
            </div>

            <div class="container">
                <main>
                    @yield('content')
                    <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>
                    <x-livewire-alert::scripts />
                </main>
            </div>
        </div>
        
    </div>
    <script src="https://cdn.jsdelivr.net/npm/driver.js@1.0.1/dist/driver.js.iife.js"></script>

    <!-- Include jQuery -->
    <script src="{{ asset('assets/js/jquery-3.7.0.js') }}"></script>
    <!-- Include Bootstrap 5 JS -->
    {{-- <script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script> --}}
    <!-- Include DataTables core script -->
    <script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>
    <!-- Include DataTables Bootstrap 5 extension script -->
    <script src="{{ asset('assets/js/dataTables.bootstrap5.min.js') }}"></script>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });

        function navigate(event, url, item) {
            event.preventDefault();
            $.ajax({
                url: '/set-session',
                method: 'POST',
                data: {
                    item: item,
                    _token: $('meta[name="csrf-token"]').attr('content') // Add CSRF token for Laravel
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = url;
                    } else {
                        console.error('Failed to set session value.');
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed.');
                }
            });
        }

        function navigateToSelectItem(event, url) {
            event.preventDefault();

            $.ajax({
                url: '/set-session-to-url',
                method: 'POST',
                data: {
                    toUrl: url,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = "{{ route('select-warehouse') }}";
                    } else {
                        console.error('Failed to set session value.');
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed.');
                }
            });
        }


        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            new DataTable('#example', {
                order: [],
            });
        });

        const sidebarToggle = document.getElementById('sidebarToggleBtn');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');

        function toggleSidebar() {
            sidebar.classList.toggle('sidebar-open');
            overlay.classList.toggle('show');
        }

        sidebarToggle.addEventListener('click', toggleSidebar);

        overlay.addEventListener('click', () => {
            sidebar.classList.remove('sidebar-open');
            overlay.classList.remove('show');
        });

        document.addEventListener('keydown', (event) => {
            if (event.key === '`') { 
                toggleSidebar();
                
            }
        });


        document.addEventListener("DOMContentLoaded", function() {
            const currentTheme = localStorage.getItem('theme') || 'light';

            document.documentElement.setAttribute('data-bs-theme', currentTheme);

            // Set the icon based on the theme
            const themeIcon = document.getElementById('themeIcon');
            if (currentTheme === 'dark') {
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            } else {
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            }
        });

        const toggleThemeButton = document.getElementById('toggleThemeButton');
        toggleThemeButton.addEventListener('click', () => {
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            let newTheme = 'dark';

            if (currentTheme === 'dark') {
                newTheme = 'light';
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                newTheme = 'dark';
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }

            document.documentElement.setAttribute('data-bs-theme', newTheme);
            localStorage.setItem('theme', newTheme); // Store the theme in local storage
        });

        document.addEventListener("DOMContentLoaded", function() {
            const myNavbar = document.getElementById('myNavbar');

            // Hide the navbar initially
            myNavbar.style.display = 'none';

            // Listen for the 'keydown' event anywhere on the document
            document.addEventListener('keydown', function(event) {
                // Check if '/' key is pressed (key code 191 for '/')
                if (event.key === '/') {
                    // Toggle the visibility of the navbar
                    myNavbar.style.display = myNavbar.style.display === 'none' ? 'block' : 'none';
                }
            });
        });
        document.addEventListener("DOMContentLoaded", function() {
            var navLinks = document.querySelectorAll('.nav-link');
            var currentPage = window.location.pathname.split('/').pop();

            navLinks.forEach(function(link) {
                if (link.getAttribute('href') === currentPage) {
                    link.classList.add('active');
                }
            });
        });
        
        document.addEventListener('DOMContentLoaded', function() {
            var reportDropdown = document.getElementById('reportDropdown');
            var dropdownMenu = document.getElementById('reportDropdownMenu');
            var content = document.querySelector('.content');

            reportDropdown.addEventListener('click', function(e) {
                e.preventDefault();
                dropdownMenu.classList.toggle('show');

                if (dropdownMenu.classList.contains('show')) {
                    content.style.marginTop = dropdownMenu.clientHeight + 'px';
                } else {
                    content.style.marginTop = '0';
                }
            });

            document.addEventListener('click', function(e) {
                if (!reportDropdown.contains(e.target) && !dropdownMenu.contains(e.target)) {
                    dropdownMenu.classList.remove('show');
                    content.style.marginTop = '0';
                }
            });
        });
        document.getElementById('logoutDropdown').addEventListener('click', function(event) {
            event.preventDefault();
            var logoutDropdownMenu = document.getElementById('logoutDropdownMenu');
            logoutDropdownMenu.style.display = (logoutDropdownMenu.style.display === 'block') ? 'none' : 'block';
        });

        window.addEventListener('click', function(event) {
            var logoutDropdownMenu = document.getElementById('logoutDropdownMenu');

            if (!document.getElementById('logoutDropdown').contains(event.target)) {
                logoutDropdownMenu.style.display = 'none';
            }
        });
    </script>
    @if (auth()->user()->tutorials == 'Y')
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                setTimeout(() => {
                    if (document.querySelector('.cashier-page')) {
                        cashierPopup();
                    } else if (document.querySelector('.member-page')) {
                        memberPopup();
                    } else if (document.querySelector('.master-page')) {
                        masterPopup();
                    } else if (document.querySelector('.opname-page')) {
                        opnamePopup();
                    } else if (document.querySelector('.goods-receipt-page')) {
                        goodsReceiptsPopup();
                    } else if (document.querySelector('.goods-return-page')) {
                        goodsReturnPopup();
                    } else if (document.querySelector('.it-page')) {
                        itemTransferPopup();
                    }
                }, 1000);
            });
        </script>
    @endif
    @stack('scripts')
</body>

</html>
