<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <title>IT Request Out</title>

    <!-- Favicon -->
    <link rel="icon" href="./images/favicon.png" type="image/x-icon" />

    <!-- Invoice styling -->
    <style>
        body {
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            text-align: center;
            color: #777;
        }

        body h1 {
            font-weight: 300;
            margin-bottom: 0px;
            padding-bottom: 0px;
            color: #000;
        }

        body h3 {
            font-weight: 300;
            margin-top: 10px;
            margin-bottom: 20px;
            font-style: italic;
            color: #555;
        }

        body a {
            color: #06f;
        }

        .paid-stamp {
            position: absolute;
            top: 3px;
            right: 15px;
            padding: 5px;
            font-size: 16px;
            line-height: 24px;
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
            font-weight: bold;
            text-transform: uppercase;
        }

        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            /* border: 1px solid #eee;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.15); */
            font-size: 16px;
            line-height: 24px;
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
            border-collapse: collapse;
        }

        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(2) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 40px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        .dashed-hr {
            border: none;
            border-top: 1px dashed #000;
            /* Change #000 to your desired color */
            color: #fff;
            /* Change to match your background color */
            background-color: #fff;
            /* Change to match your background color */
            height: 1px;
            width: 100%;
            /* Adjust the width as needed */
            margin: 10px 0;
            /* Add margin to separate from other elements */
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        .float-right {
            text-align: right;
            /* Align text to the right */
        }

        .document-table,
        .document-table td {
            border: none;
            /* No border for the document details table */
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .data-table th,
        .data-table td {
            border: none;
            /* Remove all borders */
            padding: 8px;
            /* Add padding to data table cells */
            text-align: center;
            /* Center align text in data table cells */
            border-bottom: 1px solid #000;
            /* Add border-bottom to data table cells */
        }

        .data-table th.float-right,
        .data-table td.float-right {
            text-align: right;
            /* Align text to the right */
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <div class="paid-stamp">

        </div>
        <table>
            <tr class="top">
                <td colspan="2">
                    <table>
                        <tr>
                            <td class="title">
                                <img src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}"
                                    style="width: 100%; max-width: 100px" />
                            </td>

                            <td>
                                <strong>Inventory Transfer Request Out</strong><br>

                                <span style="font-size: 12px;">Document Number :
                                    <strong>{{ $no->no }}</strong><br /></span>

                                <span style="font-size: 12px;">Document Date : <strong>{{ $no->date }}</strong>
                                </span> <br>
                                <span style="font-size: 12px;">Sending Warehouse :
                                    <strong>{{ $no->whs->name }}</strong>
                                </span>

                                <br />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            
            <table class="data-table">
                <hr class="dashed-hr">
                <div style="float: left; margin-bottom:10px;">
                    <span style="font-size: 15px;">Receiving Warehouse :
                       
                        <strong>{{ $no->whsTo->name }}</strong><br /></span>
                </div>
                <thead>
                    <tr style="border-top: 1px solid #000">
                        <th scope="col">{{ __('Item Code') }}</th>
                        <th scope="col">{{ __('Barcode') }}</th>
                        <th scope="col">{{ __('Name') }}</th>
                        <th scope="col">{{ __('Qty') }}</th>
                        <th scope="col" class="float-right">{{ __('Qty Send') }}</th>
                    </tr>
                </thead>
                <tbody class="small">
                    @foreach ($details as $key => $detail)
                        <tr>
                            <td style="text-align: center;"><strong>{{ $detail->code }}</strong></td>
                            <td style="text-align: center;"><strong>{{ $detail->barcode }}</strong></td>
                            <td style="text-align: center;"><strong>{{ $detail->name }}</strong></td>
                            <td style="text-align: center;"><strong>{{ number_format($detail->qty) }}</strong></td>
                            <td class="float-right"><strong>{{ $detail->qty_send }}</strong></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <table id="example" class="" style="width:100%; ">


                <tr class="top">
                    <td colspan="2">
                        <table>
                            <tr>
                                <td style="width: 350px;">

                                </td>

                                <td style="width: 150px; border-bottom: 3px double #000;"><strong>Total</strong></td>
                                <td style="text-align: center; border-bottom: 3px double #000;">{{ $sumQty }}
                                </td>
                                <td class="float-right" style="border-bottom: 3px double #000;">{{ $sumQtySend }}
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <tr class="top">
                <td colspan="2">
                    <table style="margin-top: 20px;">
                        <tr>
                            <td class="title" style="text-align:center;">
                                Recipient,
                                <br>
                                <br>
                                <br>
                                <br>
                                (&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;)
                            </td>

                            <td class="title" style="text-align:center;">
                                Sender,
                                <br>
                                <br>
                                <br>
                                <br>
                                (&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;)
                            </td>

                            <td class="title" style="text-align:center;">
                                Warehouse,
                                <br>
                                <br>
                                <br>
                                <br>
                                (&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;)
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

</body>
<script>
    window.addEventListener('load', function() {
        window.print();
    });

    window.onafterprint = function() {
        window.close();
    };
</script>

</html>
