@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }

        .toggle-container {
            display: inline-block;
            position: relative;
        }

        .toggle-checkbox {
            display: none;
        }

        .toggle-label {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 50px;
            height: 25px;
            background-color: #cecdcd;
            border-radius: 25px;
            cursor: pointer;
            position: relative;
            transition: background-color 0.3s ease;
        }

        .toggle-checkbox:checked+.toggle-label {
            background-color: #4f52ff;
        }

        .toggle-circle {
            width: 20px;
            height: 20px;
            background-color: white;
            border-radius: 50%;
            position: absolute;
            top: 2.5px;
            left: 3px;
            transition: transform 0.3s ease;
        }

        .toggle-checkbox:checked+.toggle-label .toggle-circle {
            transform: translateX(25px);
        }

        .p-2 div {
            display: flex;
            align-items: center;
            gap: 10px;
        }
    </style>
    <div class="">
        <div class="row justify-content-center">
            <div class="col">
                <div class="">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Help') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                    </div>

                    <nav class="page-breadcrumb">
                        <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a livewire:navigate href="/">{{ __('Main') }}</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Help') }}
                                </li>
                            </ol>
                        </div>
                    </nav>

                    <div class="card-body" id="cashier">
                        <div>
                            <div class="fs-4 fw-bold mb-3">Tutorial Center</div>

                            <div class="row d-flex">
                                @if ($menuItems['Tutorial'])
                                <div class="col-md-3 mb-4">
                                    <div class="card p-3" id="card-tutorial">
                                        <div class="fw-bold fs-5">Video Tutorials</div>
                                        <span>Page: Cashier</span>
                                        <div class="p-2 mt-2 mb-2">
                                            <div style="display: flex; align-items: center; gap: 10px;">
                                                <div class="toggle-container">
                                                    <input type="checkbox" id="toggleTutorial" class="toggle-checkbox"
                                                        onchange="changeStatusDriver(this, 'Tutorial')"
                                                        {{ $menuItems['Tutorial']->active == 'Y' ? 'checked' : '' }}>
                                                    <label for="toggleTutorial" class="toggle-label">
                                                        <span class="toggle-circle"></span>
                                                    </label>
                                                </div>
                                                <div style="white-space: nowrap;">Active</div>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                <a href="{{ url('/cashier') }}">
                                                    <div style="width: 18px; height: auto;">
                                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                            class="size-6">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                        </svg>
                                                    </div>
                                                    <div class="fw-semibold">View Popups</div>
                                                </a>
                                            </div>
                                            <div class="card col-md-5 col-sm-5 youtube">
                                                <a href="https://youtu.be/02QAwEqm6Bw?si=LlH-NqQmnPQ1vPYB" target="_blank"
                                                    rel="noopener noreferrer" class="p-2">
                                                    <div style="width: 18px; height: auto;">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                            fill="currentColor" class="size-6">
                                                            <path fill-rule="evenodd"
                                                                d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                clip-rule="evenodd" />
                                                        </svg>
                                                    </div>
                                                    <div class="fw-semibold">Youtube</div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                @if ($menuItems['Home'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">View the entire POS menu</div>
                                            <span>Page: Home </span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleHome" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Home')"
                                                            {{ $menuItems['Home']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleHome" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ url('/') }}">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                                class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/71VNp_N3e6A?si=W-TSsVoUnsLHPJzs" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Dashboard'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">View sales statistics</div>
                                            <span>Page: Statistics</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleDashboard" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Dashboard')"
                                                            {{ $menuItems['Dashboard']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleDashboard" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('welcome.page-dashboard') }}">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                                class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/5dotFLmBKq4?si=FZKFUdHFYifRfCsZ" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Warehouse'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to add a shop</div>
                                            <span>Page: Shop</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleWarehouse" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Warehouse')"
                                                            {{ $menuItems['Warehouse']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleWarehouse" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('warehouse.index') }}" onclick="navigate(event, '{{ route('warehouse.index') }}')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/R6lCRiYDWLs?si=t1L5hmO--jCQ58tj" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Supplier'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input supplier</div>
                                            <span>Page: Supplier</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleSupplier" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Supplier')"
                                                            {{ $menuItems['Supplier']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleSupplier" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('item.input') }}"
                                                        onclick="navigate(event, '{{ route('item.input') }}', 'Supplier')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/yLo18KwR2J0?si=2B3iaRFYkPylQ5bO" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['SalesEmployee'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input store staff</div>
                                            <span>Page: Store Staff</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleSalesEmployee" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'SalesEmployee')"
                                                            {{ $menuItems['SalesEmployee']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleSalesEmployee" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('salesemp') }}" onclick="navigate(event, '{{ route('salesemp') }}')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/1wlgdVnuG6c?si=Dm4ytxyJjbQbf_KP" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Product'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input products</div>
                                            <span>Page: Product</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleProduct" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Product')"
                                                            {{ $menuItems['Product']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleProduct" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('item.input') }}" onclick="navigate(event, '{{ route('item.input') }}', 'Item')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/YKKItKaRZ4Q?si=fW-GA-hosZWcq7ty" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Brand'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input brand</div>
                                            <span>Page: Brand</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleBrand" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Brand')"
                                                            {{ $menuItems['Brand']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleBrand" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('item.input') }}" onclick="navigate(event, '{{ route('item.input') }}', 'Brand')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/Y5cCgeUYns8?si=i5oDcsiqtcxFiQoi" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Pricelist'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input pricelist</div>
                                            <span>Page: Pricelist</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="togglePricelist" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Pricelist')"
                                                            {{ $menuItems['Pricelist']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="togglePricelist" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('item.input') }}" onclick="navigate(event, '{{ route('item.input') }}', 'Pricelist')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://www.youtube.com/" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Goods Receipt'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to view goods receipts</div>
                                            <span>Page: Reception</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleGoodsReceipt" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Goods Receipt')"
                                                            {{ $menuItems['Goods Receipt']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleGoodsReceipt" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('po.index') }}" onclick="navigate(event, '{{ route('po.index') }}')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/FBiTxo9-3U8?si=e83YogqY7HkOYto_" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Cashier'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input sales</div>
                                            <span>Page: Sale</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="toggleSales" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Cashier')"
                                                            {{ $menuItems['Cashier']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="toggleSales" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('welcome.dashboard') }}">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://youtu.be/q2P-JBxHzt8?si=IrYSFK4W_G4GTgv-" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($menuItems['Promo'])
                                    <div class="col-md-3 mb-4">
                                        <div class="card p-3" id="card-tutorial">
                                            <div class="fw-bold fs-5">How to input promo</div>
                                            <span>Page: Promo</span>
                                            <div class="p-2 mt-2 mb-2">
                                                <div style="display: flex; align-items: center; gap: 10px;">
                                                    <div class="toggle-container">
                                                        <input type="checkbox" id="togglePromo" class="toggle-checkbox"
                                                            onchange="changeStatusDriver(this, 'Promo')"
                                                            {{ $menuItems['Promo']->active == 'Y' ? 'checked' : '' }}>
                                                        <label for="togglePromo" class="toggle-label">
                                                            <span class="toggle-circle"></span>
                                                        </label>
                                                    </div>
                                                    <div style="white-space: nowrap;">Active</div>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <div class="card p-2 col-md-5 col-sm-5" id="lihat-popup">
                                                    <a href="{{ route('promo.index') }}" onclick="navigate(event, '{{ route('promo.index') }}')">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                viewBox="0 0 24 24" stroke-width="1.5"
                                                                stroke="currentColor" class="size-6">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">View Popups</div>
                                                    </a>
                                                </div>
                                                <div class="card col-md-5 col-sm-5 youtube">
                                                    <a href="https://www.youtube.com/" target="_blank"
                                                        rel="noopener noreferrer" class="p-2">
                                                        <div style="width: 18px; height: auto;">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="size-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M4.5 5.653c0-1.427 1.529-2.33 2.779-1.643l11.54 6.347c1.295.712 1.295 2.573 0 3.286L7.28 19.99c-1.25.687-2.779-.217-2.779-1.643V5.653Z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </div>
                                                        <div class="fw-semibold">Youtube</div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function changeStatusDriver(checkbox, menu) {
            $.ajax({
                url: '/change-status-driver',
                type: 'POST',
                data: {
                    menu: menu,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {},
                error: function(xhr) {
                }
            });
        }

        function navigate(event, url, item) {
            event.preventDefault();
            $.ajax({
                url: '/set-session',
                method: 'POST',
                data: {
                    item: item,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        window.location.href = url;
                    } else {
                        console.error('Failed to set session value.');
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed.');
                }
            });
        }
    </script>
@endsection
