<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Purchase Return</title>
    <style>
        @page {
            margin: 30px;
        }

        body {
            font-family: Tahoma, sans-serif;
            font-size: 7pt;
            line-height: 1.2;
            margin: 0;
            padding: 0;
        }

        .header {
            margin-bottom: 15px;
        }

        .company-name {
            float: left;
            font-weight: bold;
        }

        .document-info {
            float: right;
            text-align: right;
        }

        .document-info div {
            line-height: 1.3;
        }

        .clear {
            clear: both;
        }

        .dotted-line {
            border-top: 1px dotted #000;
            margin: 10px 0;
        }

        .sub-header {
            margin: 5px 0;
        }

        .source {
            float: left;
        }

        .destination {
            float: right;
        }

        .label {
            font-size: 9pt;
            font-weight: bold;
            opacity: 0.6;
        }

        .value {
            font-size: 9pt;
            font-weight: bold;
        }


        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }

        th,
        td {
            border-bottom: 1px solid rgba(0, 0, 0, 0.2);
            padding: 2px 4px;
            font-size: 7pt;
            padding-right: 10px;
        }

        thead tr {
            border-bottom: 1px solid rgba(0, 0, 0, 0.2);
        }

        thead th {
            font-size: 8pt;
            font-weight: normal;
        }


        th {
            background-color: #ffffff;
            text-align: left;
            border-top: 1px solid rgba(0, 0, 0, 0.2);

        }

        .text-right {
            text-align: right;
        }

        .text-right-10px {
            text-align: right;
            margin-left: -10px;
            /* Adjust the value to move it left */
        }

        .text-left {
            text-align: left;
        }


        .text-center {
            text-align: center;
        }

        .footer {
            margin-top: 10px;
            font-size: 7pt;
            border-top: 1px dotted #000;
            padding-top: 10px;
        }

        .col-no {
            width: 20px;
        }

        .col-code {
            width: 60px;
        }

        .col-barcode {
            width: 60px;
        }

        .col-desc {
            width: auto;
        }

        .col-size {
            width: 60px;
        }

        .col-unit {
            width: 40px;
        }

        .col-qty {
            width: 30px;
            /* Increase width */
            text-align: right;
            padding-right: 15px;
            /* Add spacing to push it left */
        }

        .col-price {
            width: 80px;
            text-align: right;
            padding-left: 20px;
            /* Push Harga Jual further right */
        }

        .col-total {
            width: 80px;
        }

        .remarks {
            margin-top: 20px;
            margin-bottom: 10px;
            color: #000;
        }

        .total-section {
            margin-top: 20px;
            margin-bottom: 10px;
            text-align: right;
            color: #000;
        }

        .signature-section {
            margin-top: 50px;
            margin-bottom: 100px;
        }

        .signature-row {
            display: flex;
            justify-content: space-between;
            width: 100%;
            margin-bottom: 80px;
        }

        .signature-box {
            width: 200px;
        }

        .signature-title {
            margin-bottom: 80px;
        }

        .signature-parentheses {
            display: flex;
            justify-content: center;
            gap: 100px;
        }

        tr {
            height: 20px;
        }

        .col-desc {
            width: 10.95rem;
            height: 1.20rem;
            word-wrap: break-word;
        }

        tr {
            height: 15.3px;
        }

        table {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 2px 4px;
            font-size: 7pt;
            height: 15px;
        }


        .col-itemcode {
            width: 4.95rem;
            height: 1.20rem;
            text-align: left;
        }

        .col-barcode {
            width: 4.17rem;
            height: 1.20rem;
            text-align: left;
        }

        .col-number {
            width: 1.89rem;
            height: 1.17rem;
            text-align: center;
        }

        .col-size {
            width: 2.09rem;
            height: 1.20rem;
            left: 51.77rem;
            top: 0.80rem;
        }

        .col-unit {
            width: 0.33rem;
            height: 1.20rem;
            left: 56.73rem;
            top: 0.42rem;
            text-align: center;
        }

        .col-qty {
            width: 2.25rem;
            height: 1.70rem;
            left: 60.86rem;
            top: 0.80rem;
            text-align: right;
        }

        .col-price {
            width: 0.83;
            min-width: 0.83;
            max-width: 0.83;
            height: 1.17rem;
            left: 65.90rem;
            top: 0.42rem;
            text-align: right;
            white-space: nowrap;
            word-wrap: break-word;
        }


        .col-total {
            width: 1.32rem;
            height: 1.20rem;
            left: 72.71rem;
            top: 0.80rem;
            text-align: right;
        }

        .footer {
            position: fixed;
            bottom: 10px;
            left: 0;
            width: 100%;
            text-align: left;
            font-size: 7pt;
            border-top: 1px dotted #000;
            padding-top: 5px;
            background-color: white;
        }

        @media print {
            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }

            tr {
                page-break-inside: avoid;
            }

            table {
                page-break-after: auto;
            }
        }
    </style>
</head>

<body>
    @foreach ($dataPages as $data)
        <div class="header">
            <div class="company-name" style="font-size: 11pt;">{{ $data['company'] }}</div>
            <div class="document-info">
                <div style="font-weight: bold; font-size: 14pt;">{{ $label }}</div>
                <div style="font-size: 8pt; margin-bottom: 2px; margin-top: 5px;"><span style="opacity: 0.6;">Document
                        Number :
                    </span>{{ $data['documentNumber'] }}</div>
                <div style="font-size: 8pt;"><span style="opacity: 0.6;">Document Date :
                    </span>{{ $data['documentDate'] }}</div>
            </div>
            <div class="clear"></div>
        </div>

        <div class="dotted-line"></div>
        <div class="sub-header">
            <div class="source">
                <span class="label">Source Location:</span> <span class="value">{{ $data['asal'] }}</span>
            </div>
            <div class="destination">
                <span class="label">Destination:</span> <span class="value">{{ $data['tujuan'] }}</span>
            </div>

            <div class="clear"></div>
        </div>
        @if (!$data['isEmptyPage'])
            <div style="margin-top: 16px;">
                <table>
                    <thead>
                        <tr>
                            <th class="col-no">#</th>
                            <th class="col-code">ItemCode</th>
                            <th class="col-barcode">Barcode</th>
                            <th class="col-desc">Description</th>
                            <th class="text-left col-size">Size</th>
                            <th class="col-unit">&nbsp;Unit</th>
                            <th class="col-qty text-right">Qty</th>
                            <th class="col-price text-right">Selling Price</th>
                            <th class="col-total text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data['items'] as $index => $item)
                            <tr>
                                <td style="text-align: center;">{{ $item['number'] }}</td>
                                <td>{{ $item['item_code'] }}</td>
                                <td>{{ $item['barcode'] }}</td>
                                <td class="col-desc">{{ $item['description'] }}</td>
                                <td class="text-left">{{ $item['size'] }}</td>
                                <td class="text-right">PCS</td>
                                <td style="text-align: right; padding-right: 15px;">{{ $item['qty'] }}</td>
                                <td class="text-right">{{ number_format($item['price'], 0, ',', '.') }}</td>
                                <td class="text-right">{{ number_format($item['total'], 0, ',', '.') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
        @if ($data['isLastPage'])
            <div style="position: relative; height: 50px;">
                <div class="remarks" style="position: absolute; left: 0; top: 0; text-align: left;">
                    <span class="label">Remark :</span><span style="font-size: 8pt;">&nbsp; {{ $data['remark'] }}
                    </span>

                </div>
                <div class="total-section" style="position: absolute; right: 0; bottom: 0; top: 0; text-align: right;">
                    <span class="label" style="margin-right: 45px; font-size: 8pt;">Total</span>
                    @if ($data['totalItems'] < 100)
                        <span style="margin-right: 85px; font-size: 8pt;">{{ $data['totalItems'] }}</span>
                    @else
                        <span style="margin-right: 55px; font-size: 8pt;">{{ $data['totalItems'] }}</span>
                    @endif
                    <span style="font-size: 8pt;">{{ number_format($data['grandTotal'], 0, ',', '.') }}</span>
                    <div style="margin-top: 8px;">
                        <hr
                            style="border: none; border-top: 2px solid black; margin: 2px 0; width: 100%; opacity: 0.6;">
                        <hr
                            style="border: none; border-top: 1px solid black; margin: 0 auto; width: 99%; opacity: 0.6;">
                    </div>

                </div>

            </div>

            <div class="signature-section" style="position: relative; margin-top: 10px; height: 50px;"">
                <div class="signature-row">
                    <div class="signature-box" style="position: absolute; left: 15px; top: 25px; text-align: left;">
                        <div class="signature-title" style="margin-left: 45px; font-size: 8pt;">Receiver,</div>
                        <div class="signature-parentheses">
                            <span>&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;(&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; )</span>
                        </div>
                    </div>
                    <div class="signature-box" style="position: absolute; right: 300px; top: 25px;">
                        <div class="signature-title" style="margin-left: 45px; font-size: 8pt;">Sender,</div>
                        <div class="signature-parentheses">
                            <span>&nbsp; &nbsp; &nbsp;&nbsp; &nbsp;(&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                                &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; )</span>
                        </div>
                    </div>
                </div>

            </div>
        @endif

        <div class="footer" style="font-size: 8pt;">
            Page : {{ $data['currentPage'] }}/{{ $data['totalPages'] }}
        </div>

        @if (!$data['isLastPage'])
            <div style="page-break-after: always;"></div>
        @endif
    @endforeach

    {{-- <div class="footer">
        Page : {{ $data['currentPage'] }}/{{ $data['totalPages'] }}
    </div> --}}
</body>

</html>
<script>
    window.addEventListener('load', function() {
        window.print();
    });

    window.onafterprint = function() {
        window.close();
    };
</script>
