<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Account and Company</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            background-color: #ffffff;
            margin: 20px auto;
            padding: 20px;
            max-width: 600px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            padding: 20px 0;
        }

        .header h1 {
            color: #333333;
        }

        .content {
            margin: 20px 0;
        }

        .content p {
            font-size: 16px;
            color: #555555;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            color: #888888;
            font-size: 12px;
        }

        .btn-verify {
            display: inline-block;
            background-color: #007bff;
            color: black;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1>Verify Your Account and Company</h1>
        </div>
        <div class="content">
            <p>Welcome to Softcomp.io</p>
            <p>A modern POS system solution specifically designed for non-F&B businesses. Softcomp.io is capable of managing thousands of products and various categories efficiently.</p>
            <p>Equipped with excellent features such as:</p>
            <ul>
                <li>Consignment System</li>
                <li>More than 14 types of automatic promotions</li>
                {{-- <li>Auto Reporting & Automatic Restocking System (ARS)</li> --}}
            </ul>
            <p>Your Username: <strong>{{ $name }}</strong></p>
            <p>Your Password: {{ $name }}</p>
            <p>Welcome to Softcomp RMS! Please verify your account by clicking the button below.</p>

            <p>
                <button class="btn-verify">
                    <a href="{{ route('verify.email', ['encrypted' => $companycode]) }}"
                        style="text-decoration: none; color: white;">Verify Your Account and Company</a>
                </button>
            </p>
            <p>If you need assistance or have any questions, feel free to contact us via
                WhatsApp at: <a
                    href="https://wa.me/6285117031010?text=Hello,%20I%20have%20a%20question.">+6285117031010</a></p>
        </div>
        <div class="footer">
            <p>Thank you for using our service!</p>
            <p>&copy; {{ date('Y') }} Softcomp. All rights reserved.</p>
        </div>
    </div>
</body>

</html>
