@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }

        #salesChart {
            width: 100%;
            height: 400px;
        }

        .card-chart {
            border: none;
            border-radius: 1rem;
            box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s ease, box-shadow 0.3s ease;
            position: relative;
            min-height: 300px;
        }

        .card-chart:hover {
            transform: translateY(-5px);
            box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.15);
        }

        .form-control {
            background: transparent;
        }

        .card.sale-pop {
            border: none !important;
            border-radius: 1rem !important;
            background: linear-gradient(135deg, #516deb 0%, #3f57c9 100%) !important;
            color: white !important;
            box-shadow: 0 10px 20px rgba(81, 109, 235, 0.2) !important;
            overflow: hidden !important;
            position: relative !important;
        }

        .card.sale-pop::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: scale(0);
            transition: transform 0.5s ease;
        }

        .card.sale-pop:hover {
            transform: translateY(-5px) !important;
            box-shadow: 0 15px 30px rgba(81, 109, 235, 0.3) !important;
        }

        .card.sale-pop:hover::before {
            transform: scale(3);
        }

        .card.sale-pop .card-body {
            padding: 1.5rem !important;
            z-index: 1;
            position: relative;
        }

        .card.sale-pop .fw-semibold {
            letter-spacing: 0.5px;
        }

        .card.sale-pop .fs-4 {
            font-weight: 700 !important;
            letter-spacing: -0.5px;
            margin-top: 0.25rem;
            font-size: 2rem !important;
        }

        .card.sale-pop .d-flex>div:last-child {
            background: rgba(255, 255, 255, 0.15) !important;
            border-radius: 1rem !important;
            padding: 0.75rem !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1) !important;
            transition: all 0.3s ease !important;
        }

        .card.sale-pop:hover .d-flex>div:last-child {
            transform: rotate(5deg);
            background: rgba(255, 255, 255, 0.25) !important;
        }

        .card.sale-pop svg {
            width: 24px !important;
            height: 24px !important;
            stroke-width: 2;
            transition: all 0.3s ease;
        }

        .card.sale-pop:hover svg {
            transform: scale(1.1);
        }

        .card.sale-pop blockquote {
            border-left: 3px solid rgba(255, 255, 255, 0.3);
            padding-left: 0.75rem;
            margin-top: 1rem !important;
        }

        .card.sale-pop blockquote p {
            font-size: 0.75rem !important;
            opacity: 0.8;
            font-weight: 500;
            letter-spacing: 0.3px;
            margin-bottom: 0;
        }

        .card.atv-pop {
            border: none !important;
            border-radius: 1rem !important;
            background: linear-gradient(135deg, #ed8751 0%, #e06f37 100%) !important;
            color: white !important;
            box-shadow: 0 10px 20px rgba(237, 135, 81, 0.2) !important;
            overflow: hidden !important;
            position: relative !important;
        }

        .card.atv-pop::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: scale(0);
            transition: transform 0.5s ease;
        }

        .card.atv-pop:hover {
            transform: translateY(-5px) !important;
            box-shadow: 0 15px 30px rgba(237, 135, 81, 0.3) !important;
        }

        .card.atv-pop:hover::before {
            transform: scale(3);
        }

        .card.atv-pop .card-body {
            padding: 1.5rem !important;
            z-index: 1;
            position: relative;
        }

        .card.atv-pop .fw-semibold {
            letter-spacing: 0.5px;
        }

        .card.atv-pop .fs-4 {
            font-weight: 700 !important;
            letter-spacing: -0.5px;
            margin-top: 0.25rem;
            font-size: 2rem !important;
        }

        .card.atv-pop .d-flex>div:last-child {
            background: rgba(255, 255, 255, 0.15) !important;
            border-radius: 1rem !important;
            padding: 0.75rem !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1) !important;
            transition: all 0.3s ease !important;
        }

        .card.atv-pop:hover .d-flex>div:last-child {
            transform: rotate(5deg);
            background: rgba(255, 255, 255, 0.25) !important;
        }

        .card.atv-pop svg {
            width: 24px !important;
            height: 24px !important;
            stroke-width: 2;
            transition: all 0.3s ease;
        }

        .card.atv-pop:hover svg {
            transform: scale(1.1);
        }

        .card.atv-pop blockquote {
            border-left: 3px solid rgba(255, 255, 255, 0.3);
            padding-left: 0.75rem;
            margin-top: 1rem !important;
        }

        .card.atv-pop blockquote p {
            font-size: 0.75rem !important;
            opacity: 0.8;
            font-weight: 500;
            letter-spacing: 0.3px;
            margin-bottom: 0;
        }

        .card.upt-pop {
            border: none !important;
            border-radius: 1rem !important;
            background: linear-gradient(135deg, #14d5c8 0%, #0bb8ac 100%) !important;
            color: white !important;
            box-shadow: 0 10px 20px rgba(20, 213, 200, 0.2) !important;
            overflow: hidden !important;
            position: relative !important;
        }

        .card.upt-pop::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: scale(0);
            transition: transform 0.5s ease;
        }

        .card.upt-pop:hover {
            transform: translateY(-5px) !important;
            box-shadow: 0 15px 30px rgba(20, 213, 200, 0.3) !important;
        }

        .card.upt-pop:hover::before {
            transform: scale(3);
        }

        .card.upt-pop .card-body {
            padding: 1.5rem !important;
            z-index: 1;
            position: relative;
        }

        .card.upt-pop .fw-semibold {
            letter-spacing: 0.5px;
        }

        .card.upt-pop .fs-4 {
            font-weight: 700 !important;
            letter-spacing: -0.5px;
            margin-top: 0.25rem;
            font-size: 2rem !important;
        }

        .card.upt-pop .d-flex>div:last-child {
            background: rgba(255, 255, 255, 0.15) !important;
            border-radius: 1rem !important;
            padding: 0.75rem !important;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1) !important;
            transition: all 0.3s ease !important;
        }

        .card.upt-pop:hover .d-flex>div:last-child {
            transform: rotate(5deg);
            background: rgba(255, 255, 255, 0.25) !important;
        }

        .card.upt-pop svg {
            width: 24px !important;
            height: 24px !important;
            stroke-width: 2;
            transition: all 0.3s ease;
        }

        .card.upt-pop:hover svg {
            transform: scale(1.1);
        }

        .card.upt-pop blockquote {
            border-left: 3px solid rgba(255, 255, 255, 0.3);
            padding-left: 0.75rem;
            margin-top: 1rem !important;
        }

        .card.upt-pop blockquote p {
            font-size: 0.75rem !important;
            opacity: 0.8;
            font-weight: 500;
            letter-spacing: 0.3px;
            margin-bottom: 0;
        }

        .apexcharts-tooltip {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
            padding: 0;
            overflow: hidden;
        }

        .tooltip-header {
            background: #f8f9fa;
            padding: 8px 12px;
            font-weight: bold;
            border-bottom: 1px solid #eee;
        }

        .tooltip-body {
            padding: 8px 12px;
        }

        .tooltip-row {
            white-space: nowrap;
            font-size: 13px;
        }

        .tooltip-row span {
            display: inline-block;
        }

        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .loading-spinner {
            width: 40px;
            height: 40px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>

    <!-- Move scripts to top -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/gsap@3.12.5/dist/gsap.min.js" defer></script>
    <script src="https://unpkg.com/@dotlottie/player-component@2.7.12/dist/dotlottie-player.mjs" type="module" defer>
    </script>

    <div class="dashboard-page">
        @if (!$rate)
            <div class="row justify-content-center mt-2">
                <div class="col-md-8">
                    <div x-data="npsComponent()" x-show="visible" x-transition class="row justify-content-center mb-4">
                        <div class="col-md-8 card p-4">
                            <template x-if="!submitted">
                                <div>
                                    <h5 class="text-center mb-3">How helpful and satisfied are you with this system?</h5>
                                    <div class="d-flex justify-content-center mb-3">
                                        <template x-for="n in 11" :key="n">
                                            <button type="button" class="btn m-1"
                                                :class="{ 'btn-primary': score === (n - 1) }" @click="score = n-1">
                                                <span x-text="n-1"></span>
                                            </button>
                                        </template>
                                    </div>
                                    <div x-show="score !== null" class="mb-3">
                                        <textarea x-model="comment" class="form-control" placeholder="Leave your comments..."></textarea>
                                    </div>
                                    <div class="text-danger mb-2" x-text="error"></div>
                                    <div class="d-flex justify-content-between">
                                        <button class="btn btn-secondary" @click="skip()">Skip</button>
                                        <button class="btn btn-success" @click="submit()">Send</button>
                                    </div>
                                </div>
                            </template>

                            <template x-if="submitted">
                                <div class="text-center">
                                    <h5>Thank you for your feedback!</h5>
                                </div>
                            </template>
                        </div>
                    </div>

                    <script>
                        function npsComponent() {
                            return {
                                score: null,
                                comment: '',
                                submitted: false,
                                error: '',
                                visible: true,
                                skip() {
                                    this.submitted = true;
                                    setTimeout(() => {
                                        this.visible = false;
                                        this.resetForm();
                                    }, 5000);
                                    fetch('/nps-response', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/json',
                                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                        },
                                        body: JSON.stringify({
                                            skipped: true
                                        })
                                    });
                                },
                                submit() {
                                    if (this.score === null) {
                                        this.error = 'Please select the score first.';
                                        return;
                                    }

                                    if (this.score < 8 && this.comment.trim() === '') {
                                        this.error = 'Comments are required for scores below 8.';
                                        return;
                                    }

                                    this.error = '';
                                    fetch('/nps-response', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/json',
                                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                        },
                                        body: JSON.stringify({
                                            score: this.score,
                                            comment: this.comment
                                        })
                                    }).then(() => {
                                        this.submitted = true;
                                        setTimeout(() => {
                                            this.visible = false;
                                            this.resetForm();
                                        }, 5000);
                                    });
                                },
                                resetForm() {
                                    this.score = null;
                                    this.comment = '';
                                    this.error = '';
                                    this.submitted = false;
                                }
                            }
                        }
                    </script>


                    <div class="card-body text-center">
                        <template x-if="!submitted">
                            <div>
                                <p class="card-text mb-3">
                                    How helpful is this system to you and how satisfied are you with using it?
                                </p>
                                <div class="d-flex justify-content-center flex-wrap gap-2">
                                    <template x-for="i in 11" :key="i">
                                        <button class="btn"
                                            :class="score === i - 1 ? 'btn-primary' : 'btn-outline-primary'"
                                            @click="score = i - 1" x-text="i - 1"></button>
                                    </template>
                                </div>
                                <div class="mt-3 text-muted" style="font-size: 0.9rem;">
                                    0 = Very less &nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp; 10 = Very good
                                </div>

                                <div class="mt-3" x-show="score !== null && score < 8">
                                    <textarea class="form-control" rows="3" placeholder="What can we improve?" x-model="comment"></textarea>
                                </div>

                                <div class="text-danger mt-2" x-show="error" x-text="error"></div>

                                <div class="mt-4 d-flex justify-content-center gap-2">
                                    <button class="btn btn-success" @click="submit">
                                        Send
                                    </button>
                                    <button class="btn btn-secondary" @click="skip">
                                        Skip
                                    </button>
                                </div>
                            </div>
                        </template>

                        <template x-if="submitted">
                            <div>
                                <h5 class="text-success">Thank you for your feedback! ðŸ™</h5>
                            </div>
                        </template>
                    </div>

                </div>
            </div>
        @endif


        <div class="col">
            <div class="">
                <div class="head-cashier pay-pop">
                    <div class="logo">
                        <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                    </div>

                    <div class="d-flex align-items-center mb-2">
                        @php
                            $warehouseName = userWarehouse();
                            $words = explode(' ', $warehouseName);
                            $firstWord = $words[0] ?? '';
                            $remainingWords = implode(' ', array_slice($words, 1));
                        @endphp
                        @admin
                            <a href="{{ route('select-warehouse') }}" class="text-decoration-none">
                                <div class="flex-grow-1">
                                    <h5 class="mb-0 head-cashier-2" style="font-weight: 300;">{{ $firstWord }}</h5>
                                    <h2 class="head-cashier-2" style="font-weight: 600;">{{ $remainingWords }}</h2>
                                </div>
                            </a>
                        @else
                            <a class="text-decoration-none">
                                <div class="flex-grow-1">
                                    <h5 class="mb-0 head-cashier-2" style="font-weight: 300;">{{ $firstWord }}</h5>
                                    <h2 class="head-cashier-2" style="font-weight: 600;">{{ $remainingWords }}</h2>
                                </div>
                            </a>
                        @endadmin
                    </div>


                    <div class="d-flex gap-3">
                        <div class="shadow-md clock2">
                            <livewire:clock />
                        </div>
                    </div>

                </div>
                <div class="card-body" id="cashier">
                    <div class="fs-3 fw-bold">Welcome back,
                        {{ ucwords(explode('@', auth()->user()->username)[0]) }}!
                    </div>
                    <div>Dashboard Overview</div>
                    <div class="d-flex gap-5 justify-content-center">
                        <div class="card col-4"
                            style="border: none; border-radius: 1rem; display: flex; justify-content: center; align-items: center; background: transparent">
                            <dotlottie-player
                                src="https://lottie.host/7d6dbde1-5f17-415a-8013-fce08d28220f/ftyIVazhzJ.lottie"
                                background="transparent" speed="1"
                                style="width: 450px; height: 450px; transform: scaleX(-1);" loop
                                autoplay></dotlottie-player>
                        </div>

                        <div class="d-flex gap-3 justify-content-center" style="align-items: center">
                            <div class="card shadow-sm sale-pop gsap-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="">
                                            <div class="fw-semibold">Total sales (Rp)</div>

                                            @if (!empty($totalSales) && is_numeric($totalSales))
                                                <div class="fw-semibold fs-4" style="padding-right: 1rem">
                                                    {{ number_format($totalSales, 0, ',', '.') }}</div>
                                            @else
                                                0
                                            @endif

                                        </div>

                                        <div>
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="2" stroke="currentColor" class="size-6">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5M9 11.25v1.5M12 9v3.75m3-6v6" />
                                            </svg>
                                        </div>
                                    </div>

                                    <blockquote class="blockquote mb-0 mt-3">
                                        <p style="font-size: 12px">Total income from transactions</p>
                                    </blockquote>
                                </div>
                            </div>
                            <div class="card shadow-sm atv-pop gsap-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="">
                                            <div class="fw-semibold">ATV (Rp)</div>
                                            @if (!empty($atv) && is_numeric($atv))
                                                <div class="fw-semibold fs-4" style="padding-right: 1rem">
                                                    {{ number_format($atv, 0, ',', '.') }}
                                                </div>
                                            @else
                                                0
                                            @endif

                                        </div>

                                        <div>
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="2" stroke="currentColor" class="size-6">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
                                            </svg>
                                        </div>
                                    </div>

                                    <blockquote class="blockquote mb-0 mt-3">
                                        <p style="font-size: 12px">Average value per transaction</p>
                                    </blockquote>
                                </div>
                            </div>

                            <div class="card shadow-sm upt-pop gsap-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="">
                                            <div class="fw-semibold">UPT</div>
                                            @if (!empty($upt) && is_numeric($upt))
                                                <div class="fw-semibold fs-4" style="padding-right: 1rem">
                                                    {{ number_format($upt, 2, ',', '.') }}</div>
                                            @else
                                                0
                                            @endif

                                        </div>

                                        <div>
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke-width="2" stroke="currentColor" class="size-6">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                    d="m20.25 7.5-.625 10.632a2.25 2.25 0 0 1-2.247 2.118H6.622a2.25 2.25 0 0 1-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125Z" />
                                            </svg>
                                        </div>
                                    </div>

                                    <blockquote class="blockquote mb-0 mt-3">
                                        <p style="font-size: 12px">Average items per transaction</p>
                                    </blockquote>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="container">
                        <div class="row">
                            <div class="col-md-6 col-lg-6 mb-4">
                                <div class="card-chart shadow-sm p-3">
                                    <h5 class="mb-3">Total Sales Graph</h5>
                                    <form id="" class="row align-items-end mb-2">
                                        <div class="col-md-4">
                                            <label for="start_date_sales" class="form-label">Start date:</label>
                                            <input type="date" id="start_date_sales" class="form-control"
                                                name="start_date_sales" value="{{ $startDateSales }}">
                                        </div>

                                        <div class="col-md-4">
                                            <label for="end_date_sales" class="form-label">End date:</label>
                                            <input type="date" id="end_date_sales" class="form-control"
                                                name="end_date_sales" value="{{ $endDateSales }}">
                                        </div>

                                        <div class="col-md-4">
                                            <button type="button" id="updateSalesBtn"
                                                class="btn btn-primary w-100">Update</button>
                                        </div>
                                    </form>

                                    <div id="salesChartMain" style="height: 300px;"></div>
                                    <div id="salesChartBrush" style="height: 130px;"></div>
                                </div>
                            </div>


                            <div class="col-md-6 col-lg-6 mb-4">
                                <div class="card-chart shadow-sm p-3">
                                    <h5 class="mb-3">Sales Chart by Shift</h5>
                                    <form id="" class="row align-items-end mb-2">
                                        <div class="col-md-4">
                                            <label for="start_date_shift" class="form-label">Start date:</label>
                                            <input type="date" id="start_date_shift" class="form-control"
                                                name="start_date_shift" value="{{ $startDateShift }}">
                                        </div>

                                        <div class="col-md-4">
                                            <label for="end_date_shift" class="form-label">End date:</label>
                                            <input type="date" id="end_date_shift" class="form-control"
                                                name="end_date_shift" value="{{ $endDateShift }}">
                                        </div>

                                        <div class="col-md-4">
                                            <button type="button" id="updateShiftBtn"
                                                class="btn btn-primary w-100">Update</button>
                                        </div>
                                    </form>

                                    <div id="shiftChartMain" style="height: 300px;"></div>
                                    <div id="shiftChartBrush"></div>
                                </div>
                            </div>

                            <div class="col-md-6 col-lg-6 mb-4">
                                <div class="card-chart shadow-sm p-3">
                                    <h5 class="mb-3">Sales and Transfer Item Comparison Chart</h5>

                                    <form id="" class="row align-items-end mb-2">
                                        <div class="col-md-3">
                                            <label for="warehouseSelect">Select warehouse:</label>
                                            <select id="warehouseSelect" class="form-select">
                                                {{-- @foreach ($itrData as $whs_code => $data)
                                                    <option value="{{ $whs_code }}">{{ $whs_code }}</option>
                                                @endforeach --}}

                                                @foreach ($itrData as $whs_code => $data)
                                                    <option value="{{ $whs_code }}">
                                                        {{ $data->whs_name ?? $whs_code }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="start_date_itr" class="form-label">Start date:</label>
                                            <input type="date" id="start_date_itr" class="form-control"
                                                name="start_date_itr" value="{{ $startDateItr }}">
                                        </div>

                                        <div class="col-md-3">
                                            <label for="end_date_itr" class="form-label">End date:</label>
                                            <input type="date" id="end_date_itr" class="form-control"
                                                name="end_date_itr" value="{{ $endDateItr }}">
                                        </div>

                                        <div class="col-md-3">
                                            <button type="button" id="updateItrBtn"
                                                class="btn btn-primary w-100">Update</button>
                                        </div>
                                    </form>

                                    <div id="itrChart" style="height: 300px;"></div>
                                    <div id="itrChartBrush"></div>
                                </div>
                            </div>


                            <div class="col-md-6 col-lg-6 mb-4">
                                <div class="card-chart shadow-sm p-3">
                                    <h5 class="mb-3">Normal Price and Discount Price Comparison Chart</h5>

                                    <form id="" class="row align-items-end mb-2">
                                        <div class="col-md-3">
                                            <label for="warehouseSelectPrice">Select warehouse:</label>
                                            <select id="warehouseSelectPrice" class="form-select">
                                                @foreach (collect($priceData)->sortBy('name') as $whs_code => $data)
                                                    <option value="{{ $whs_code }}">{{ $data->name ?? $whs_code }}
                                                    </option>
                                                @endforeach

                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label for="start_date_price" class="form-label">Start date:</label>
                                            <input type="date" id="start_date_price" class="form-control"
                                                name="start_date_price" value="{{ $startDatePrice }}">
                                        </div>

                                        <div class="col-md-3">
                                            <label for="end_date_price" class="form-label">End date:</label>
                                            <input type="date" id="end_date_price" class="form-control"
                                                name="end_date_price" value="{{ $endDatePrice }}">
                                        </div>

                                        <div class="col-md-3">
                                            <button type="button" id="updatePriceBtn"
                                                class="btn btn-primary w-100">Update</button>
                                        </div>
                                    </form>

                                    <div id="priceChart" style="height: 300px;"></div>
                                    <div id="priceChartBrush"></div>
                                </div>
                            </div>

                            <div class="col-md-12 col-lg-12 mb-4">
                                <div class="card-chart shadow-sm p-3">
                                    <h5 class="mb-3">Sales Chart by Category</h5>
                                    <form id="" class="row align-items-end mb-2">
                                        <div class="col-md-4">
                                            <label for="start_date_category" class="form-label">Start date:</label>
                                            <input type="date" id="start_date_category" class="form-control"
                                                name="start_date_category" value="{{ $startDateCategory }}">
                                        </div>

                                        <div class="col-md-4">
                                            <label for="end_date_category" class="form-label">End date:</label>
                                            <input type="date" id="end_date_category" class="form-control"
                                                name="end_date_category" value="{{ $endDateCategory }}">
                                        </div>

                                        <div class="col-md-4">
                                            <button type="button" id="updateCategoryBtn"
                                                class="btn btn-primary w-100">Update</button>
                                        </div>
                                    </form>

                                    <div id="categoryMainChart" style="height: 300px;"></div>
                                    <div id="categoryBrushChart"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <script>
        gsap.from(".gsap-card", {
            duration: 2,
            y: 50,
            opacity: 0,
            stagger: 0.3,
            ease: "power3.out"
        });
    </script>

    <script>
        // Global error handler
        window.onerror = function(msg, url, lineNo, columnNo, error) {
            return false;
        };

        document.addEventListener("DOMContentLoaded", function() {
            if (typeof ApexCharts === 'undefined') {
                return;
            }

            try {
                const baseOptions = {
                    series: [],
                    chart: {
                        height: 300,
                        animations: {
                            enabled: true,
                            easing: 'easeinout',
                            speed: 800
                        },
                        toolbar: {
                            show: true
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 2
                    },
                    xaxis: {
                        type: 'datetime'
                    },
                    tooltip: {
                        shared: true,
                        custom: function({
                            series,
                            seriesIndex,
                            dataPointIndex,
                            w
                        }) {
                            const timestamp = w.globals.seriesX[0][dataPointIndex];
                            const date = new Date(timestamp);

                            let points = w.globals.series.map((seriesData, index) => ({
                                name: w.globals.seriesNames[index],
                                value: seriesData[dataPointIndex],
                                color: w.globals.colors[index]
                            }));

                            points.sort((a, b) => b.value - a.value);

                            const formattedDate = date.toLocaleDateString('id-ID', {
                                day: 'numeric',
                                month: 'long',
                                year: 'numeric'
                            });

                            let html = `<div class="tooltip-header">${formattedDate}</div>`;
                            html += `<div class="tooltip-body">`;
                            points.forEach(point => {
                                if (!isNaN(point.value)) {
                                    html += `
                                        <div class="tooltip-row" style="display: flex; justify-content: space-between; margin: 4px 0;">
                                            <span style="color: ${point.color}">â— ${point.name}:</span>
                                            <span style="margin-left: 16px; font-weight: bold;">${point.value.toLocaleString()}</span>
                                        </div>
                                    `;
                                }
                            });
                            html += `</div>`;

                            return html;
                        }
                    },
                    noData: {
                        text: 'Loading...',
                        align: 'center',
                        verticalAlign: 'middle',
                        style: {
                            fontSize: '14px'
                        }
                    }
                };

                const salesOptions = {
                    ...baseOptions,
                    series: [{
                        name: 'Sales',
                        data: []
                    }],
                    chart: {
                        id: 'salesChartMain',
                        type: 'line',
                        height: 300,
                        toolbar: {
                            autoSelected: 'pan',
                            show: false
                        }
                    },
                    colors: ['#516deb', '#ed8751'],
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    fill: {
                        opacity: 0.5,
                    }
                };

                const salesBrushOptions = {
                    ...baseOptions,
                    series: [{
                        name: 'Sales',
                        data: []
                    }],
                    chart: {
                        id: 'salesChartBrush',
                        height: 130,
                        type: 'area',
                        brush: {
                            target: 'salesChartMain',
                            enabled: true
                        },
                        selection: {
                            enabled: true,
                            xaxis: {
                                type: 'datetime'
                            }
                        }
                    },
                    colors: ['#516deb', '#ed8751'],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            opacityFrom: 0.91,
                            opacityTo: 0.1,
                        }
                    }
                };

                let mainChart = null;
                let brushChart = null;

                const mainChartElement = document.querySelector("#salesChartMain");
                const brushChartElement = document.querySelector("#salesChartBrush");

                if (mainChartElement && brushChartElement) {
                    mainChart = new ApexCharts(mainChartElement, salesOptions);
                    brushChart = new ApexCharts(brushChartElement, salesBrushOptions);

                    Promise.all([
                        mainChart.render(),
                        brushChart.render()
                    ]).then(() => {
                        fetchDataAndUpdateSalesChart();
                    });
                }

                function safeUpdateChartSeries(chart, newSeries) {
                    if (chart && typeof chart.updateSeries === 'function') {
                        try {
                            chart.updateSeries(newSeries);
                        } catch (error) {
                            console.error('Error updating chart series:', error);
                        }
                    }
                }

                function fetchDataAndUpdateSalesChart() {
                    fetch("{{ route('welcome.get-sales-data') }}")
                        .then(response => response.json())
                        .then(data => {
                            if (!data.success || Object.keys(data.salesData).length === 0) {
                                console.warn("No sales data available.");
                                salesOptions.series = [];
                                salesBrushOptions.series = [];
                                mainChart.updateOptions(salesOptions);
                                brushChart.updateOptions(salesBrushOptions);
                                return;
                            }

                            const salesData = data.salesData;

                            // Ambil nama-nama series
                            const seriesNames = Object.keys(salesData);

                            const generateDateTimeSeries = (dataMap) => {
                                return Object.entries(dataMap).map(([dateStr, value]) => {
                                    return [new Date(dateStr).getTime(), value];
                                });
                            };

                            const updatedSeries = seriesNames.map(name => ({
                                name: name,
                                data: generateDateTimeSeries(salesData[name])
                            }));

                            // Update kedua chart
                            mainChart.updateSeries(updatedSeries);
                            brushChart.updateSeries(updatedSeries);
                        })
                        .catch(error => {
                            console.error('Error fetching chart data:', error);
                        });
                }


                const updateSalesBtn = document.getElementById("updateSalesBtn");
                if (updateSalesBtn) {
                    updateSalesBtn.addEventListener("click", async function() {
                        const startDate = document.getElementById("start_date_sales")?.value;
                        const endDate = document.getElementById("end_date_sales")?.value;

                        if (!startDate || !endDate) {
                            alert('Please select both start and end dates');
                            return;
                        }

                        // showLoading('salesChartMain');
                        try {
                            const response = await fetch("{{ route('welcome.update-sales-range') }}", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/json",
                                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                },
                                body: JSON.stringify({
                                    start_date_sales: startDate,
                                    end_date_sales: endDate
                                })
                            });

                            if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
                            const data = await response.json();

                            if (data.success) {
                                await fetchDataAndUpdateSalesChart();
                            } else {
                                alert('Failed to update: ' + (data.message || 'Unknown error'));
                            }
                        } catch (error) {
                            console.error('Error updating sales range:', error);
                            alert('Error updating date range: ' + error.message);
                        } finally {
                            // hideLoading('salesChartMain');
                        }
                    });
                }

                // category chart
                const categoryMainOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'categoryMainChart',
                        type: 'line',
                        height: 300,
                        toolbar: {
                            autoSelected: 'pan',
                            show: false
                        }
                    },
                    colors: ['#14B8A6', '#8B5CF6', '#F59E0B', '#EF4444', '#0EA5E9', '#F97316'],
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    fill: {
                        opacity: 0.5,
                    }
                };

                const categoryBrushOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'categoryBrushChart',
                        height: 130,
                        type: 'area',
                        brush: {
                            target: 'categoryMainChart',
                            enabled: true
                        },
                        selection: {
                            enabled: true,
                            xaxis: {
                                type: 'datetime'
                            }
                        }
                    },
                    colors: ['#14B8A6', '#8B5CF6', '#F59E0B', '#EF4444'],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            opacityFrom: 0.91,
                            opacityTo: 0.1,
                        }
                    }
                };

                const categoryMainChartEl = document.querySelector("#categoryMainChart");
                const categoryBrushChartEl = document.querySelector("#categoryBrushChart");

                let categoryMainChart = null;
                let categoryBrushChart = null;

                if (categoryMainChartEl && categoryBrushChartEl) {
                    categoryMainChart = new ApexCharts(categoryMainChartEl, categoryMainOptions);
                    categoryBrushChart = new ApexCharts(categoryBrushChartEl, categoryBrushOptions);

                    Promise.all([
                        categoryMainChart.render(),
                        categoryBrushChart.render()
                    ]).then(() => {
                        fetchDataAndUpdateCategoryChart();
                    });
                }

                function getXRangeFromSeries(series) {
                    const allX = series.flatMap(s => s.data.map(d => d.x));
                    const min = Math.min(...allX);
                    const max = Math.max(...allX);
                    return {
                        min,
                        max
                    };
                }

                function safeUpdateCategorySeries(chart, series) {
                    if (chart && typeof chart.updateOptions === 'function') {
                        try {
                            const xRange = getXRangeFromSeries(series);

                            chart.updateOptions({
                                series: series,
                                xaxis: {
                                    min: xRange.min,
                                    max: xRange.max
                                }
                            });
                        } catch (error) {
                            console.error('Error updating category chart:', error);
                        }
                    }
                }


                async function fetchDataAndUpdateCategoryChart() {
                    // showLoading('categoryMainChart');
                    try {
                        const response = await fetch("{{ route('welcome.get-category-data') }}");
                        if (!response.ok) throw new Error('Network response was not ok');
                        const data = await response.json();

                        if (data.success && data.categorySalesData) {
                            const series = Object.keys(data.categorySalesData).map(category => ({
                                name: category,
                                data: Object.entries(data.categorySalesData[category])
                                    .map(([date, value]) => ({
                                        x: new Date(date).getTime(),
                                        y: value
                                    }))
                                    .sort((a, b) => a.x - b.x)
                            }));

                            safeUpdateCategorySeries(categoryMainChart, series);
                            safeUpdateCategorySeries(categoryBrushChart, series);
                        }
                    } catch (error) {
                        console.error('Error fetching category data:', error);
                        safeUpdateCategorySeries(categoryMainChart, []);
                        safeUpdateCategorySeries(categoryBrushChart, []);
                    } finally {
                        // hideLoading('categoryMainChart');
                    }
                }

                const updateCategoryBtn = document.getElementById("updateCategoryBtn");
                if (updateCategoryBtn) {
                    updateCategoryBtn.addEventListener("click", async function() {
                        const startDate = document.getElementById("start_date_category")?.value;
                        const endDate = document.getElementById("end_date_category")?.value;

                        if (!startDate || !endDate) {
                            alert('Please select both start and end dates');
                            return;
                        }

                        // showLoading('categoryMainChart');
                        try {
                            const response = await fetch(
                                "{{ route('welcome.update-category-range') }}", {
                                    method: "POST",
                                    headers: {
                                        "Content-Type": "application/json",
                                        "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                    },
                                    body: JSON.stringify({
                                        start_date_category: startDate,
                                        end_date_category: endDate
                                    })
                                });

                            if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
                            const data = await response.json();

                            if (data.success) {
                                await fetchDataAndUpdateCategoryChart();
                            } else {
                                alert('Failed to update: ' + (data.message || 'Unknown error'));
                            }
                        } catch (error) {
                            console.error('Error updating category range:', error);
                            alert('Error updating date range: ' + error.message);
                        } finally {
                            // hideLoading('categoryMainChart');
                        }
                    });
                }

                // shift chart
                const shiftMainOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'shiftMainChart',
                        type: 'line',
                        height: 300,
                        toolbar: {
                            autoSelected: 'pan',
                            show: false
                        }
                    },
                    colors: ['#10B981', '#6366F1'],
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    fill: {
                        opacity: 0.5,
                    }
                };

                const shiftBrushOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'shiftBrushChart',
                        height: 130,
                        type: 'area',
                        brush: {
                            target: 'shiftMainChart',
                            enabled: true
                        },
                        selection: {
                            enabled: true,
                            xaxis: {
                                type: 'datetime'
                            }
                        }
                    },
                    colors: ['#10B981', '#6366F1'],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            opacityFrom: 0.9,
                            opacityTo: 0.1
                        }
                    }
                };

                let shiftMainChart = null;
                let shiftBrushChart = null;

                const shiftMainChartElement = document.querySelector("#shiftChartMain");
                const shiftBrushChartElement = document.querySelector("#shiftChartBrush");

                if (shiftMainChartElement && shiftBrushChartElement) {
                    shiftMainChart = new ApexCharts(shiftMainChartElement, shiftMainOptions);
                    shiftBrushChart = new ApexCharts(shiftBrushChartElement, shiftBrushOptions);

                    Promise.all([
                        shiftMainChart.render(),
                        shiftBrushChart.render()
                    ]).then(() => {
                        fetchDataAndUpdateShiftChart();
                    });
                }

                function safeUpdateShiftSeries(chart, newSeries) {
                    if (chart && typeof chart.updateSeries === 'function') {
                        try {
                            chart.updateSeries(newSeries);
                        } catch (error) {
                            console.error('Error updating shift series:', error);
                        }
                    }
                }

                async function fetchDataAndUpdateShiftChart() {
                    // showLoading('shiftChartMain');
                    try {
                        const response = await fetch("{{ route('welcome.get-shift-data') }}");
                        if (!response.ok) throw new Error('Network response was not ok');
                        const data = await response.json();

                        if (data.success && data.shiftSalesData) {
                            const transformedData = Object.entries(data.shiftSalesData).map(([date, shifts]) =>
                                ({
                                    date,
                                    Pagi: shifts.Pagi || 0,
                                    Malam: shifts.Malam || 0
                                }));

                            const series = [{
                                    name: 'Pagi',
                                    data: transformedData.map(item => ({
                                        x: new Date(item.date).getTime(),
                                        y: item.Pagi
                                    }))
                                },
                                {
                                    name: 'Malam',
                                    data: transformedData.map(item => ({
                                        x: new Date(item.date).getTime(),
                                        y: item.Malam
                                    }))
                                }
                            ];

                            safeUpdateShiftSeries(shiftMainChart, series);
                            safeUpdateShiftSeries(shiftBrushChart, series);
                        }
                    } catch (error) {
                        console.error('Error fetching shift data:', error);
                    } finally {
                        // hideLoading('shiftChartMain');
                    }
                }

                const updateShiftBtn = document.getElementById("updateShiftBtn");
                if (updateShiftBtn) {
                    updateShiftBtn.addEventListener("click", async function() {
                        const startDate = document.getElementById("start_date_shift")?.value;
                        const endDate = document.getElementById("end_date_shift")?.value;

                        if (!startDate || !endDate) {
                            alert('Please select both start and end dates');
                            return;
                        }

                        // showLoading('shiftChartMain');
                        try {
                            const response = await fetch("{{ route('welcome.update-shift-range') }}", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/json",
                                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                },
                                body: JSON.stringify({
                                    start_date_shift: startDate,
                                    end_date_shift: endDate
                                })
                            });

                            if (!response.ok) {
                                throw new Error(`HTTP error! status: ${response.status}`);
                            }
                            const data = await response.json();
                            if (data.success) {
                                await fetchDataAndUpdateShiftChart();
                            } else {
                                console.error('Update failed:', data.message || 'Unknown error');
                                alert('Failed to update: ' + (data.message || 'Unknown error'));
                            }
                        } catch (error) {
                            console.error('Error updating price date range:', error);
                            alert('Error updating date range: ' + error.message);
                        }
                    });
                }
                // price chart

                const priceOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'priceChartMain',
                        type: 'line',
                        height: 300,
                        toolbar: {
                            autoSelected: 'pan',
                            show: false
                        },
                        zoom: {
                            enabled: false
                        },
                    },
                    colors: ['#0891B2', '#DB2777'],
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    fill: {
                        opacity: 0.5,
                    },
                    xaxis: {
                        type: 'datetime',
                        labels: {
                            format: 'dd MMM GG'
                        },
                        tooltip: {
                            enabled: false
                        }
                    },
                    yaxis: {
                        labels: {
                            formatter: function(value) {
                                return new Intl.NumberFormat('id-ID').format(value);
                            }
                        }
                    }
                };

                const priceBrushOptions = {
                    ...baseOptions,
                    series: [],
                    chart: {
                        id: 'priceChartBrush',
                        height: 130,
                        type: 'area',
                        brush: {
                            target: 'priceChartMain',
                            enabled: true
                        },
                        selection: {
                            enabled: true,
                            xaxis: {
                                type: 'datetime'
                            }
                        },
                        toolbar: {
                            show: false
                        },
                    },
                    colors: ['#0891B2', '#DB2777'],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            opacityFrom: 0.91,
                            opacityTo: 0.1,
                        }
                    },
                    xaxis: {
                        type: 'datetime',
                        labels: {
                            format: 'dd MMM GG'
                        },
                        tooltip: {
                            enabled: false
                        }
                    },
                    yaxis: {
                        tickAmount: 2,
                        labels: {
                            show: false
                        }
                    }
                };

                let priceMainChart = null;
                let priceBrushChart = null;

                // Add debug logging for DOM elements
                const priceMainEl = document.querySelector("#priceChart");
                const priceBrushEl = document.querySelector("#priceChartBrush");

                // Check if ApexCharts is available
                if (priceMainEl && priceBrushEl) {
                    try {
                        priceMainChart = new ApexCharts(priceMainEl, priceOptions);
                        priceBrushChart = new ApexCharts(priceBrushEl, priceBrushOptions);

                        Promise.all([
                            priceMainChart.render(),
                            priceBrushChart.render()
                        ]).then(() => {
                            const defaultWarehouse = document.getElementById('warehouseSelectPrice')?.value;
                            if (defaultWarehouse) {
                                fetchDataAndUpdatePriceChart(defaultWarehouse);
                            } else {
                                console.warn(
                                    "No default warehouse found on load. Attempting to fetch with null whsCode."
                                    );
                                fetchDataAndUpdatePriceChart();
                            }
                        }).catch(error => {
                            console.error("Error rendering ApexCharts:", error);
                        });
                    } catch (error) {
                        console.error("Error creating ApexCharts instances:", error);
                    }
                } else {
                    console.error(
                        "One or both chart elements not found! Make sure #priceChart and #priceChartBrush exist in your HTML."
                        );
                }

                /**
                 * Fungsi untuk mengambil data harga dan memperbarui chart.
                 * Jika whsCode diberikan, akan memperbarui chart untuk warehouse tersebut.
                 * Jika tidak, akan mengambil warehouse pertama dari data.
                 */
                async function fetchDataAndUpdatePriceChart(whsCode = null) {
                    try {
                        const response = await fetch("{{ route('welcome.get-price-data') }}");

                        if (!response.ok) {
                            console.error('Network response was not ok:', response.status, response.statusText);
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }

                        const data = await response.json();

                        if (data.success && data.priceData && Object.keys(data.priceData).length > 0) {
                            const allWhsCodes = Object.keys(data.priceData);
                            const actualWhsCode = whsCode || allWhsCodes[0];

                            const warehouseData = data.priceData[actualWhsCode];
                            if (!warehouseData) {
                                console.warn("No data available for selected/first warehouse:", actualWhsCode);
                                priceMainChart?.updateSeries([]);
                                priceBrushChart?.updateSeries([]);
                                return;
                            }

                            // âœ… Ambil hanya tanggal (bukan key "name")
                            const dates = Object.keys(warehouseData)
                                .filter(key => /^\d{4}-\d{2}-\d{2}$/.test(key))
                                .sort();

                            const series = [{
                                    name: 'Harga Normal',
                                    data: dates.map(date => ({
                                        x: new Date(date).getTime(),
                                        y: parseFloat(warehouseData[date]?.harga_normal || 0)
                                    })).filter(item => !isNaN(item.y))
                                },
                                {
                                    name: 'Harga Discount',
                                    data: dates.map(date => ({
                                        x: new Date(date).getTime(),
                                        y: parseFloat(warehouseData[date]?.harga_discount || 0)
                                    })).filter(item => !isNaN(item.y))
                                }
                            ];

                            priceMainChart?.updateSeries(series);
                            priceBrushChart?.updateSeries(series);

                            // Optional: update label nama gudang
                            const warehouseSelectEl = document.getElementById('warehouseSelectPrice');
                            if (warehouseSelectEl && warehouseSelectEl.value !== actualWhsCode) {
                                warehouseSelectEl.value = actualWhsCode;
                            }

                        } else {
                            console.warn("No valid price data received.");
                            priceMainChart?.updateSeries([]);
                            priceBrushChart?.updateSeries([]);
                        }
                    } catch (error) {
                        console.error('Error in fetchDataAndUpdatePriceChart:', error);
                        priceMainChart?.updateSeries([]);
                        priceBrushChart?.updateSeries([]);
                    }
                }


                // Event listener untuk dropdown warehouse
                const warehouseSelectPrice = document.getElementById('warehouseSelectPrice');
                if (warehouseSelectPrice) {
                    warehouseSelectPrice.addEventListener('change', function() {
                        const selectedWhsCode = this.value;
                        if (selectedWhsCode) {
                            fetchDataAndUpdatePriceChart(selectedWhsCode);
                        } else {
                            console.warn("No warehouse selected from dropdown.");
                            if (priceMainChart) priceMainChart.updateSeries([]);
                            if (priceBrushChart) priceBrushChart.updateSeries([]);
                        }
                    });
                } else {
                    console.error("Warehouse select dropdown #warehouseSelectPrice not found!");
                }

                // Event listener untuk tombol "Update"
                const updatePriceBtn = document.getElementById("updatePriceBtn");
                if (updatePriceBtn) {
                    updatePriceBtn.addEventListener("click", async function() {
                        const startDate = document.getElementById("start_date_price")?.value;
                        const endDate = document.getElementById("end_date_price")?.value;
                        const selectedWarehouse = warehouseSelectPrice?.value;

                        if (!startDate || !endDate || !selectedWarehouse) {
                            alert('Please select warehouse and start/end date');
                            console.warn("Missing required input for update.");
                            return;
                        }

                        try {
                            const response = await fetch("{{ route('welcome.update-price-range') }}", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/json",
                                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                },
                                body: JSON.stringify({
                                    start_date_price: startDate,
                                    end_date_price: endDate
                                })
                            });

                            if (!response.ok) {
                                console.error(`HTTP error! status: ${response.status}`, await response
                                    .text());
                                throw new Error(`HTTP error! status: ${response.status}`);
                            }
                            const data = await response.json();
                            if (data.success) {
                                await fetchDataAndUpdatePriceChart(selectedWarehouse);
                            } else {
                                console.error('Update failed:', data.message || 'Unknown error');
                                alert('Failed to update: ' + (data.message || 'Unknown error'));
                            }
                        } catch (error) {
                            console.error('Error updating price date range:', error);
                            alert('Error updating date range: ' + error.message);
                        }
                    });
                } else {
                    console.error("Update price button #updatePriceBtn not found!");
                }

                // itr chart
                const itrOptions = {
                    ...baseOptions,
                    chart: {
                        id: 'itrMainChart',
                        type: 'line',
                        height: 300,
                        toolbar: {
                            autoSelected: 'pan',
                            show: false
                        }
                    },
                    colors: ['#0EA5E9', '#F97316'],
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    fill: {
                        opacity: 0.5
                    },
                    xaxis: {
                        type: 'datetime',
                        labels: {
                            format: 'dd MMM'
                        }
                    },
                    series: [{
                        name: 'Penjualan',
                        data: []
                    }, {
                        name: 'ITR',
                        data: []
                    }]
                };

                const itrBrushOptions = {
                    ...baseOptions,
                    chart: {
                        id: 'itrBrushChart',
                        height: 130,
                        type: 'area',
                        brush: {
                            target: 'itrMainChart',
                            enabled: true
                        },
                        selection: {
                            enabled: true,
                            xaxis: {
                                type: 'datetime'
                            }
                        }
                    },
                    colors: ['#0EA5E9', '#F97316'],
                    fill: {
                        type: 'gradient',
                        gradient: {
                            opacityFrom: 0.91,
                            opacityTo: 0.1
                        }
                    },
                    xaxis: {
                        type: 'datetime',
                        labels: {
                            format: 'dd MMM'
                        }
                    },
                    series: [{
                        name: 'Penjualan',
                        data: []
                    }, {
                        name: 'ITR',
                        data: []
                    }]
                };

                let itrMainChart = null;
                let itrBrushChart = null;

                const itrMainEl = document.querySelector("#itrChart");
                const itrBrushEl = document.querySelector("#itrChartBrush");

                if (itrMainEl && itrBrushEl) {
                    try {
                        itrMainChart = new ApexCharts(itrMainEl, itrOptions);
                        itrBrushChart = new ApexCharts(itrBrushEl, itrBrushOptions);

                        Promise.all([
                            itrMainChart.render(),
                            itrBrushChart.render()
                        ]).then(() => {
                            const defaultWarehouse = document.getElementById('warehouseSelect')?.value;
                            if (defaultWarehouse) {
                                fetchDataAndUpdateItrChart(defaultWarehouse);
                            }
                        });
                    } catch (error) {
                        console.error("Error creating ITR charts:", error);
                    }
                }


                function safeUpdateItrSeries(chart, series) {
                    if (chart && typeof chart.updateSeries === 'function') {
                        try {
                            chart.updateSeries(series);
                        } catch (err) {
                            console.error("Error updating ITR chart series:", err);
                        }
                    }
                }

                async function fetchDataAndUpdateItrChart(whsCode) {
                    if (!whsCode) {
                        console.warn("No warehouse code provided");
                        return;
                    }

                    try {
                        const response = await fetch("{{ route('welcome.get-itr-data') }}");
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        const data = await response.json();

                        if (data.success && data.itrData && data.itrData[whsCode]) {
                            const penjualanData = data.itrData[whsCode]['PENJUALAN'] || [];
                            const itrData = data.itrData[whsCode]['ITR'] || [];

                            const series = [{
                                name: 'Penjualan',
                                data: penjualanData.map(item => ({
                                    x: new Date(item.date).getTime(),
                                    y: parseFloat(item.total_qty)
                                })).sort((a, b) => a.x - b.x)
                            }, {
                                name: 'ITR',
                                data: itrData.map(item => ({
                                    x: new Date(item.date).getTime(),
                                    y: parseFloat(item.total_qty)
                                })).sort((a, b) => a.x - b.x)
                            }];

                            if (itrMainChart) {
                                itrMainChart.updateSeries(series);
                            }
                            if (itrBrushChart) {
                                itrBrushChart.updateSeries(series);
                            }
                        } else {
                            console.warn("No ITR data available for warehouse:", whsCode);
                            if (itrMainChart) itrMainChart.updateSeries([]);
                            if (itrBrushChart) itrBrushChart.updateSeries([]);
                        }
                    } catch (error) {
                        console.error('Error fetching ITR data:', error);
                        if (itrMainChart) itrMainChart.updateSeries([]);
                        if (itrBrushChart) itrBrushChart.updateSeries([]);
                    }
                }


                const warehouseSelect = document.getElementById('warehouseSelect');
                if (warehouseSelect) {
                    warehouseSelect.addEventListener('change', function() {
                        const selectedWhsCode = this.value;
                        if (selectedWhsCode) {
                            fetchDataAndUpdateItrChart(selectedWhsCode);
                        }
                    });
                }

                const updateItrBtn = document.getElementById("updateItrBtn");
                if (updateItrBtn) {
                    updateItrBtn.addEventListener("click", async function() {
                        const startDate = document.getElementById("start_date_itr")?.value;
                        const endDate = document.getElementById("end_date_itr")?.value;
                        const selectedWarehouse = warehouseSelect?.value;

                        if (!startDate || !endDate || !selectedWarehouse) {
                            alert('Please select warehouse and start/end date');
                            return;
                        }

                        try {
                            const response = await fetch("{{ route('welcome.update-itr-range') }}", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/json",
                                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                                },
                                body: JSON.stringify({
                                    start_date_itr: startDate,
                                    end_date_itr: endDate
                                })
                            });

                            if (!response.ok) {
                                throw new Error(`HTTP error! status: ${response.status}`);
                            }
                            const data = await response.json();

                            if (data.success) {
                                await fetchDataAndUpdateItrChart(selectedWarehouse);
                            } else {
                                alert('Failed to update: ' + (data.message || 'Unknown error'));
                            }
                        } catch (error) {
                            console.error('Error updating ITR range:', error);
                            alert('Error updating date range:: ' + error.message);
                        }
                    });
                }

            } catch (error) {
                console.error('Error in main script:', error);
            }
        });
    </script>

    {{-- @if ($istutorials)
        <script>
            const dashboardPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [{
                            element: '.dashboard-pop',
                            popover: {
                                description: 'Selamat datang di Dashboard Statistik. Di sini, kamu bisa melihat ringkasan performa penjualanmu dengan cepat'
                            }
                        },
                        {
                            element: '.sale-pop',
                            popover: {
                                description: 'Total penjualan dari semua toko'
                            }
                        },
                        {
                            element: '.atv-pop',
                            popover: {
                                description: 'Rata-rata nilai rupiah dalam satu struk'
                            }
                        },
                        {
                            element: '.upt-pop',
                            popover: {
                                description: 'Rata-rata jumlah barang yang di beli dalam satu struk'
                            }
                        },
                        {
                            element: '.chart-pop',
                            popover: {
                                description: 'Grafik visual performa penjualan outlet anda'
                            }
                        },
                        {
                            element: '.sidebar-pop',
                            popover: {
                                description: 'akses menu "sidebar" dengan mengklik tombol ini'
                            }
                        },
                        {
                            element: '.go-setting-pop',
                            popover: {
                                description: 'Di "sidebar" kamu bisa mengelola berbagai pengaturan sistem. Pertama, silakan akses menu Pengaturan, lalu pilih submenu Gudang'
                            }
                        },
                    ],
                    onDeselected: () => {
                        $.ajax({
                            type: "POST",
                            url: '/update-status-driver',
                            data: {
                                menu: "Dashboard",
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                                console.log(data);
                            },
                            error: function(data, textStatus, errorThrown) {
                                console.log(data);
                            },
                        });

                    }
                });

                driverObj.drive();
            }
        </script>
    @endif --}}
@endsection
