<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;

    protected $table = 'Luv2_item';
    public $timestamps = false;
    public $incrementing = false;
    public $keyType = 'string';
    protected $primaryKey = 'code';


    protected $fillable =
        [
            'company_code',
            'code',
            'barcode',
            'name',
            'brand_code',
            'category_code',
            'size_code',
            'status',
            'inventory',
            'sales',
            'purchase',
            'active',
            'avgprice',
            'created_at',
            'updated_at',
            'consignment',
        ];

    public function itemPrices()
    {
        return $this->hasMany(ItemPrice::class, 'code', 'item_code');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class, 'brand_code', 'code');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_code', 'code');
    }

    public function size()
    {
        return $this->belongsTo(Size::class, 'size_code', 'code');
    }



}
