<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItReqOut extends Model
{
    use HasFactory;

    protected $table = 'Luv2_it_req_out';
    protected $fillable = [
        'company_code',
        'whs_code',
        'whs_code_to',
        'date',
        'no',
        'entry',
        'canceled',
        'comments',
        'detail',
    ];

    public function whs()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code', 'code');
    }

    public function whsTo()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code_to', 'code');
    }

    public function details()
    {
        return $this->belongsTo(ItReqOutDetail::class, 'no', 'no');
    }
}
