<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;
    protected $table = 'Luv2_invoice';

    protected $fillable =
    [
        'id',
        'company_code',
        'whs_code',
        'user_code',
        'member_code',
        'no',
        'payment',
        'paid',
        'change',
        'must_paid',
        'date',
        'note',
        'promo',
        'no_inv',
        'sync',
        'created_at',
        'updated_at',
        'subtotal',
        'disc_total',
        'sales_code',
        'total_qty',
        'cardcode',
        'sandbox',
        'cashback',
        'service',
        'service_percent'
    ];

    public function detailInvoices()
    {
        return $this->hasMany(DetailInvoice::class, 'no', 'no');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_code', 'code');
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_code', 'code');
    }
    
}
