<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetailInvoice extends Model
{
    use HasFactory;
    protected $table = 'Luv2_invoice_detail';
    protected $fillable = 
    [
        'company_code',
        'no',
        'whs_code',
        'code',
        'barcode',
        'name',
        'qty',
        'price',
        'nprice',
        'disc',
        'total_price',
        'sandbox',
        'linenum',
        'promo',
        'promo_tipe',
        'pack',
        'benefit',
        'status,',
        'user_code',
        'sales_code',
        'created_at',
        'updated_at'

    ];

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_code', 'code');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'code', 'code');
    }

    public function kasir()
    {
        return $this->belongsTo(User::class, 'user_code', 'code');
    }

    public function sales()
    {
        return $this->belongsTo(Sales::class, 'sales_code', 'code');
    }
    
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'no', 'no');
    }
}
