<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;


class Cart extends Model
{
    use HasFactory, LogsActivity;
    
    protected $table = 'Luv2_carts';
    protected static $logOnlyDirty = true;
    protected static $recordEvents = ['deleted', 'updated'];
    protected $fillable = 
    [
        'company_code',
        'whs_code',
        'user_code',
        'sales_code',
        'member_code',
        'id',
        'linenum',
        'code',
        'barcode',	
        'name',
        'qty',
        'price',
        'nprice',
        'discount',
        'total_price',
        'sandbox',
        'promo',
        'promo_tipe',
        'pack',
        'benefit',
        'grouping',
        'created_at',
        'updated_at',
        'unit',
        'qty_unit',
        'cost',
        'consignment',
        'shared_margin',
        'lostsale',
        'keterangan',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('Scan')
        ->logFillable()
        ->setDescriptionForEvent(fn(string $eventName) => "This data has been {$eventName}");
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->company_code = auth()->user()->company_code;
        $activity->whs_code = auth()->user()->whs_code;
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'id_member', 'code');
    }

    public function kasir()
    {
        return $this->belongsTo(Member::class, 'id_user', 'id');
    }

    public function sales()
    {
        return $this->belongsTo(Member::class, 'id_sales', 'code');
    }
}
