<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentStatusUpdated extends Mailable
{
    use Queueable, SerializesModels;

    public $orderId;
    public $status;
    public $company;

    public function __construct($orderId, $status, $company)
    {
        $this->orderId = $orderId;
        $this->status = $status;
        $this->company = $company;

    }

    public function build()
    {
        return $this->subject('Payment Status Updated')
            ->view('email.orderemail');
    }
}
