<?php

namespace App\Mail;

use App\Models\Warehouse;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;

class ItRequestMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public $itemSelisih;
    public $header;
    public $warehouse;

    public function __construct($itemSelisih, $header)
    {
        $user = Auth::user();
        $warehouse = Warehouse::where('code', $user->whs_code)->first();
        $this->warehouse = $warehouse;
        $this->itemSelisih = $itemSelisih;
        $this->header = $header;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'It Request Mail',
        );
    }

    /**
     * Get the message content definition.
     */
    public function build()
    {
        return $this->view('report.reportitreq')
        ->with([
            'items' => $this->itemSelisih,
            'header' => $this->header,
        ]);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
