<?php

namespace App\Livewire\Returnsale;

use App\Models\DetailInvoice;
use App\Models\ItemPrice;
use App\Models\Member;
use App\Models\Sales;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;
use Symfony\Component\Console\Input\Input;

class Table extends Component
{
    public $selectedCarts;
    public $member;
    public $sales;
    public $invoice;
    public $datas;
    public $selectedItems = [];
    public $selectedItemsPrice;
    public $selectedItemsDetails;
    public $itemReturnDetails;
    public $selectAll = false;
    public $bulkDisabled = true;
    public $showInputReturn = false;
    public $modalOpen = false;

    #[On('clearSelectedAfterReturn')]
    public function selectedItemsAfterReturn($data)
    {
        $this->selectedItems = $data;
        $this->showInputReturn = false;
        $this->selectedCarts = [];
    }
    #[On('selectedCartsReceived')]
    public function selectedCartsReceived($data, $datas)
    {
        $this->selectedCarts = $data;
        $this->selectedItems = $datas;
    }

    public function render()
    {
        return view('livewire.returnsale.table');
    }

    public function showSelected($invoice)
    {

        $show = DetailInvoice::query()
                                ->where('invoice', $invoice)
                                ->whereNotIn('code', $this->selectedItems)
                                ->get();

        $prices = $show->pluck('price', 'id')->toArray();

        $this->selectedItems = [];

    }

    public function updatedSelectAll($value)
    {
        if($value){
            $this->selectedItems = collect($this->selectedCarts)->pluck('id')->toArray();
            $this->showInputReturn = false;

        }else{
            $this->selectedItems = [];
            $this->showInputReturn = false;

        }
    }

    #[On('updateTotalPrice')]
    public function updatedSelectedItems($data)
    {
        // Check if there are selected items
        if (!empty($this->selectedItems)) {
            // Get the prices of the selected items
            // $selectedItemsPrice = collect($this->selectedCarts)
            //     ->whereIn('id', $this->selectedItems)
            //     ->pluck('total_price')
            //     ->sum();
            //     $this->showInputReturn = false;

            // // Update the selectedItemsPrice property
            $this->selectedItemsPrice = $data;
        } else {
            // If no items are selected, reset the selectedItemsPrice to 0
            $this->selectedItemsPrice = 0;
            $this->showInputReturn = false;

        }
    }

    public function openModal()
    {
        $selectedItems = collect($this->selectedCarts)
        ->whereIn('code', $this->selectedItems)
        ->all();
        $selectedItemsPrice = collect($this->selectedCarts)
        ->whereIn('code', $this->selectedItems)
        ->pluck('price')
        ->sum();

        // foreach ($selectedItems as &$item) {

        //     $filteredProducts = DB::table('Luv2_item')
        //         ->join('Luv2_item_pricelist', 'Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
        //         ->where('Luv2_item_pricelist.id_pricelist', '1') // Replace 'your_price_list' with the desired price list
        //         ->where('Luv2_item_pricelist.price', '<=', $selectedItemsPrice)
        //         ->select('Luv2_item.*')
        //         ->get();

        //     $item['filteredProducts'] = $filteredProducts;
        //     foreach ($item['filteredProducts'] as &$filteredProduct) {
        //         $itemPrice = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $filteredProduct->code)->first();
        //         $filteredProduct->itemPrice = $itemPrice;
        //     }
        // }
        $this->dispatch('openModalWithSelectedData', $selectedItems, $selectedItemsPrice);
    }

    #[On('afterSelect')]
    public function openInput($data, $datas)
    {
        $selectedItemsDetails = collect($this->selectedCarts)
        ->whereIn('code', $this->selectedItems)
        ->all();
        $this->selectedItemsDetails = $selectedItemsDetails;
        $selectedItemsPrice = $data;
        //Get Member
        $selectedItemMembers = collect($this->selectedCarts)
        ->whereIn('code', $this->selectedItems)
        ->first();

        $this->itemReturnDetails = $datas;
        
        $itemReturnDetails = $this->itemReturnDetails;
        
        $this->member = Member::where('code', $selectedItemMembers['member_code'])->first();
        $this->sales = Sales::where('code', $selectedItemMembers['sales_code'])->first();
        $sales = $this->sales;
        $this->invoice = $selectedItemMembers['no'];
        $invoice = $this->invoice;
        if ($this->member === null) {
            $member = '';
        } else {
            $member = $this->member;
        }
        // foreach ($selectedItemsDetails as &$item) {

        //     $filteredProducts = DB::table('Luv2_item')
        //         ->join('Luv2_item_pricelist', 'Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
        //         ->where('Luv2_item_pricelist.id_pricelist', '1')
        //         ->where('Luv2_item_pricelist.price', '<=', $selectedItemsPrice)
        //         ->select('Luv2_item.*')
        //         ->get();

        //     $item['filteredProducts'] = $filteredProducts;
        //     foreach ($item['filteredProducts'] as &$filteredProduct) {
        //         $itemPrice = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $filteredProduct->code)->first();
        //         $filteredProduct->itemPrice = $itemPrice;
        //     }
        // }
        $this->showInputReturn = true;
        $this->dispatch('openInputWithSelectedData', $selectedItemsDetails, $selectedItemsPrice, $member, $sales, $invoice, $itemReturnDetails);
    }

    #[On('openthemodal')]
    public function F1Open()
    {
        $this->modalOpen = true;
        $this->dispatch('openModal');
    }
}
