<?php

namespace App\Livewire\Report;

use App\Exports\ExportTransferDetail;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class TransferDetail extends Component
{
    public $details;
    public $no;

    public function exportExcel()
    {
        $filename = "Transfer Detail Report No. {$this->no->no}.xlsx";
        return Excel::download(new ExportTransferDetail($this->details), $filename);
    }

    public function render()
    {
        return view('livewire.report.transfer-detail');
    }

    public function mount($id)
    {
        $this->details = DB::table('Luv2_transfer_detail as pd')
            ->join('Luv2_transfer as p', 'pd.no', '=', 'p.no')
            ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
            ->select(
                'i.code',
                'i.barcode',
                'i.name',
                DB::raw('SUM(pd.qty_open) as qty_open'),
                DB::raw('SUM(pd.qty_close) as qty_close')
            )
            ->where('p.no', $id)
            ->groupBy(
                'i.code',
                'i.barcode',
                'i.name',
            )
            ->get();

        $this->no = DB::table('Luv2_transfer')
            ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
            ->leftJoin('Luv2_warehouse as whs_to', 'Luv2_transfer.whs_code_to', '=', 'whs_to.code')
            ->where('no', $id)
            ->select('Luv2_transfer.*', 'whs.name as whs_name', 'whs_to.name as whs_to_name')
            ->first();
    }
}
