<?php

namespace App\Livewire\Report;

use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportMemberTransaction;
use App\Mail\MyTestMail;
use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Member;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class Transactionmember extends Component
{
    public $startDate;
    public $endDate;
    public $members;
    public $selectedDate;
    public $dataDetail;

    public $whs_code;

    #[On('refresh')]
    public function mount()
    {
        if (auth()->user()->role == 'Admin') {
            $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->first();
            $user = auth()->user();
            if ($user->whs_code == '-') {
                $user->whs_code = $warehouse->code;
                $user->save();
            }

        }
        $members = Member::with([
            'invoices' => function ($query) {
                $query->where('whs_code', auth()->user()->whs_code);

                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);

                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);

                }
            }
        ])
            ->withCount([
                'invoices' => function ($query) {
                    $query->where('whs_code', auth()->user()->whs_code);

                    if ($this->startDate && $this->endDate) {
                        $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                    } elseif ($this->startDate) {
                        $query->whereDate('created_at', '=', $this->startDate);

                    } elseif ($this->endDate) {
                        $query->whereDate('created_at', '<=', $this->endDate);

                    }
                }
            ])
            ->orderBy('invoices_count', 'desc')
            ->get();

        $members = $members->where('invoices_count', '>', 0);
       

        $this->members = $members->isNotEmpty() ? $members : collect();

        // dd($this->members);
    }

    public function filters()
    {
        $members = Member::with([
            'invoices' => function ($query) {
                $query->where('whs_code', auth()->user()->whs_code);

                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);


                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);


                }
            }
        ])
            ->withCount([
                'invoices' => function ($query) {
                    $query->where('whs_code', auth()->user()->whs_code);

                    if ($this->startDate && $this->endDate) {
                        $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                    } elseif ($this->startDate) {
                        $query->whereDate('created_at', '=', $this->startDate);

                    } elseif ($this->endDate) {
                        $query->whereDate('created_at', '<=', $this->endDate);

                    }
                }
            ])
            ->orderBy('invoices_count', 'desc')
            ->get();
        $members = $members->where('invoices_count', '>', 0);

        $this->members = $members->isNotEmpty() ? $members : collect();


    }

    public function clearfilters()
    {
        $members = Member::whereHas('invoices', function ($query) {
            $query->where('whs_code', auth()->user()->whs_code);
        })->withCount([
                    'invoices' => function ($query) {
                        $query->where('whs_code', auth()->user()->whs_code);
                    }
                ])->orderBy('invoices_count', 'desc')->get();
        $members = $members->where('invoices_count', '>', 0);
        $this->startDate = '';
        $this->endDate = '';
        $this->members = $members->isNotEmpty() ? $members : collect();
    }


    public function exportExcel()
    {
        //Get member with invoices

        $members = Member::with([
            'invoices' => function ($query) {
                $query->where('whs_code', auth()->user()->whs_code);

                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);

                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);

                }
            }
        ])
            ->withCount([
                'invoices' => function ($query) {
                    $query->where('whs_code', auth()->user()->whs_code);

                    if ($this->startDate && $this->endDate) {
                        $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                    } elseif ($this->startDate) {
                        $query->whereDate('created_at', '=', $this->startDate);

                    } elseif ($this->endDate) {
                        $query->whereDate('created_at', '<=', $this->endDate);

                    }
                }
            ])
            ->orderBy('invoices_count', 'desc')
            ->get();


        $members = $members->where('invoices_count', '>', 0);

        $this->members = $members->isNotEmpty() ? $members : collect();

        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Member Transaction Report - {$now}.xlsx";
        } else {
            $filename = "Member Transaction Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        return Excel::download(new ExportMemberTransaction($members), $filename);

    }

    public function openModal($code)
    {
        $members = Member::withCount([
            'invoices' => function ($query) {
                $query->where('whs_code', auth()->user()->whs_code);

                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);

                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);

                }
            }
        ])->orderBy('invoices_count', 'desc')->get();

        $members = $members->where('invoices_count', '>', 0);
        $this->members = $members;

        $data = Invoice::where('member_code', $code)
            ->where('whs_code', auth()->user()->whs_code)
            ->when($this->startDate && $this->endDate, function ($query) {
                $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
            })
            ->when($this->startDate && !$this->endDate, function ($query) {
                $query->whereDate('created_at', '=', $this->startDate);
            })
            ->when(!$this->startDate && $this->endDate, function ($query) {
                $query->whereDate('created_at', '<=', $this->endDate);
            })
            ->get();
        $data->load('detailInvoices');

        $this->dataDetail = $data;
    }

    public function exportExcelDetail($code)
    {
        $data = DetailInvoice::where('no', $code)->get();
        $invoicesdetail = $data;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Member Invoice Detail Report - {$now}.xlsx";
        } else {
            $filename = "Member Invoice Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refresh');
        return Excel::download(new ExportInvoiceDetail($invoicesdetail), $filename);
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;
        $user->save();

        $members = Member::with([
            'invoices' => function ($query) {
                $query->where('whs_code', auth()->user()->whs_code);

                if ($this->startDate && $this->endDate) {
                    $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                } elseif ($this->startDate) {
                    $query->whereDate('created_at', '=', $this->startDate);


                } elseif ($this->endDate) {
                    $query->whereDate('created_at', '<=', $this->endDate);


                }
            }
        ])
            ->withCount([
                'invoices' => function ($query) {
                    $query->where('whs_code', auth()->user()->whs_code);
                    if ($this->startDate && $this->endDate) {
                        $query->whereBetween('created_at', [$this->startDate, $this->endDate]);

                    } elseif ($this->startDate) {
                        $query->whereDate('created_at', '=', $this->startDate);

                    } elseif ($this->endDate) {
                        $query->whereDate('created_at', '<=', $this->endDate);

                    }
                }
            ])
            ->orderBy('invoices_count', 'desc')
            ->get();
        $members = $members->where('invoices_count', '>', 0);

        $this->members = $members->isNotEmpty() ? $members : collect();


        // dd($this->members);
    }

    public function rara()
    {
        dd($this->members);
    }

    public function render()
    {
        $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();

        return view('livewire.report.transactionmember', [
            'members' => $this->members,
            'data' => $this->dataDetail,
            'warehouse' => $warehouse,
        ]);
    }
}
