<?php

namespace App\Livewire\Report;

use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Settings;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Syncall extends Component
{

    use LivewireAlert;
    public $startDate;
    public $invoices;
    public $isCheckedAll = false;
    public $isSync = false;

    public $isloading = false;
    public $success = 0;
    public $exists = 0;
    public $fail = 0;
    public $failures = [];
    public $existence = [];

    public function render()
    {
        if ($this->isCheckedAll) {
            $this->startDate = ''; // Set startDate to empty if isCheckedAll is true
        }

        $query = DB::table('Luv2_invoice')->where('sync' , 'N');

        if ($this->startDate) {
            $query->whereDate('created_at', '=', $this->startDate);
        }
        $this->invoices = $query->orderBy('created_at', 'DESC')->get();
        return view('livewire.report.syncall');
    }


    public function clickSyncal()
    {
        $this->isloading = true;
        $this->dispatch('syncmasal');
    }

    public function filter()
    {
        if ($this->isCheckedAll) {
            $this->startDate = ''; // Set startDate to empty if isCheckedAll is true
        }
        $query = DB::table('Luv2_invoice')->where('sync' , 'N');

        if ($this->startDate) {
            $query->whereDate('created_at', '=', $this->startDate);
        }

        $this->invoices = $query->orderBy('created_at', 'DESC')->get();
        $this->alert('info', 'There is ' . $query->count() . ' invoices to sync', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        if($this->invoices->isEmpty()){
            $this->invoices = Invoice::where('sync' , 'N')->get();
            $this->alert('error', 'No Data at Date : ' . $this->startDate, [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
       }
    }

    #[On('syncmasal')]
    public function syncAll()
    {
        set_time_limit(2000);

        foreach ($this->invoices as $invoice) {
            $code = $invoice->no;
            if($invoice->no_inv != null){
                $this->syncreturn($code);
            }else{
                $invoice = Invoice::where('no', $code)->first();
                if($invoice->sandbox == 'Y'){
                    $this->syncSandbox($code);
                }else{
                    $this->sync($code);
                }
            }
        }
        
        if (!empty($this->failures)) {
            $this->dispatch('downloadFailureTxt', ['failureData' => $this->failures]);
        }
        $this->dispatch('syncCompletedBrowser');
        $this->dispatch('syncCompleted');
        $this->dispatch('refreshBrowser');
        $this->isloading = false;

    }

    public function syncSandbox($code)
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoice = DetailInvoice::where('invoice', $code)->get();
        $invoice = Invoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        }
       
        foreach ($detailinvoice as $data) {
            $checkItems[] =
                [
                    'ItemCode' => $data->code,
                    'CodeBars' => $data->barcode,
                ];
        }

        foreach ($checkItems as $item) {
            $response = Http::post($url . '/api/search', [
                "Select" => "\"ItemCode\" ",
                "From" => "OITM",
                "Where" => "\"ItemCode\"='" . $item['ItemCode'] . "';",
            ]);
            $jsonData1 = $response->json();
            $itemcode = $item['ItemCode'];
            if($jsonData1[0]['ItemCode'] == ''){
                $response2 = Http::post($url . '/api/search', [
                    "Select" => "\"CodeBars\" , \"ItemCode\", \"ItemName\"",
                    "From" => "OITM",
                    "Where" => "\"CodeBars\"='" . $item['CodeBars'] . "';",
                ]);
                $jsonData2 = $response2->json();
                if($jsonData2[0]['CodeBars'] != ''){
                    $item = DB::table('Luv2_item')->where('barcode', $jsonData2[0]['CodeBars'])->first();
                    $itemprice = DB::table('Luv2_item_pricelist')->where('item_code', $item->code)->first();
                    $detailinvoice = DB::table('Luv2_detailinvoice')->where('invoice', $code)->where('code', $itemcode)->first();
                    if ($item) {
                        DB::table('Luv2_item')
                            ->where('barcode', $jsonData2[0]['CodeBars'])
                            ->update([
                                'code' => $jsonData2[0]['ItemCode'],
                                'name' => $jsonData2[0]['ItemName']
                            ]);
                    }
                    
                    if ($itemprice) {
                        DB::table('Luv2_item_pricelist')
                            ->where('item_code', $item->code)
                            ->update(['item_code' => $jsonData2[0]['ItemCode']]);
                    }
                    
                    if ($detailinvoice) {
                        DB::table('Luv2_detailinvoice')
                            ->where('invoice', $code)
                            ->where('code', $itemcode)
                            ->update(['code' => $jsonData2[0]['ItemCode']]);
                    }
                }
            }
        }

        $cartData = DetailInvoice::where('invoice', $code)->get();
        foreach ($cartData as $cart){
            $syncItemsAfterchange[] = [
                'ItemCode' => $cart->code,
                'Quantity' => $cart->qty,
                'UnitPrice' => $cart->nprice,
                'LineTotal' => $cart->total_price,
                'WhsCode' => $setting->wh_code,
                'SBU' => $setting->sbu,
            ];
        }

        $lines = [];
        foreach ($syncItemsAfterchange as $item) {
            $lines[] = $item;
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $data = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "CashAccount" => $cashAccount,
            "CashSum" => $cash,
            "TransferAccount" => $transferAccount,
            "TransferSum" => $card,
            "TransferDate" => $currentDate,
            "DocType" => "C",
            "Lines" => $lines,
        ];
       
        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);


        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if($responseData[0]['Comments'] == $commentcode){ 
            $invoice = Invoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->exists += 1;
            $this->existence[$this->exists] = 'Invoice : '. $invoice->no . ' With ' . $commentcode . ' already exists on ADD AR Invoice'; // Store the error message in $failures array

            $this->handlealreadySync();
        }else{
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $whscode = $setting->wh_code;
                $client = new Client();
                $response = $client->post($url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);
    
                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($errorCode);
                if ($errorCode !== 0) {
                    $this->fail += 1;
                    $errorMessage = $responseData['Message']; // Capture the error message
                    $this->failures[$this->fail] = 'Invoice : '. $invoice->no . ' ' . $errorMessage; // Store the error message in $failures array
                    $this->handlealreadySync();
                } else {
                    $this->success += 1;
                    $invoice = Invoice::where('no', $code)->first();
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->handlealreadySync();

                }
                } catch (\Exception $e) {
                    $this->alert('error', 'No Internet Connection to Sync', [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }   
        }
        $this->isloading = false;
        
    }


    public function sync($code)
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoice = DetailInvoice::where('invoice', $code)->get();
        $invoice = Invoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        }
       

        foreach ($detailinvoice as $data) {
            $syncItems[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => $data->qty,
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => $data->total_price,
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                    
                ];
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $data = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "CashAccount" => $cashAccount,
            "CashSum" => $cash,
            "TransferAccount" => $transferAccount,
            "TransferSum" => $card,
            "TransferDate" => $currentDate,
            "DocType" => "C",
            "Lines" => $syncItems,
        ];
       
        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);


        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if($responseData[0]['Comments'] == $commentcode){ 
            $invoice = Invoice::where('no', $invoice->no)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->exists += 1;
            $this->existence[$this->exists] = 'Invoice : '. $invoice->no . ' With ' . $commentcode . ' already exists on ADD AR Invoice'; // Store the error message in $failures array

            $this->handlealreadySync();
        }else{
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $client = new Client();
                $response = $client->post($url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);
    
                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($errorCode);
                if ($errorCode !== 0) {
                    $this->fail += 1;
                    $errorMessage = $responseData['Message']; // Capture the error message
                    $this->failures[$this->fail] = 'Invoice : '. $invoice->no . ' ' . $errorMessage; // Store the error message in $failures array
                    $this->handlealreadySync();
                } else {
                    $this->success += 1;
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->handlealreadySync();
                }

                } catch (\Exception $e) {
                    
                }   
        }
        
    }

    public function syncreturn($code)
    {

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoicememo = DetailInvoice::where('invoice', $code)->where('status', 1)->get();
        $detailinvoicear = DetailInvoice::where('invoice', $code)->where('status', 0)->get();

        $invoice = Invoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } 
        // elseif ($invoice->payment === "") { //mzdihilangkan
        //     $cash = 0;
        //     $card = 0;
        //     $cashAccount = $setting->cashacc;
        //     $transferAccount = $setting->cardacc;
        // }
       

        foreach ($detailinvoicememo as $data) {
            $syncItemsmemo[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => ltrim($data->qty, '-'),
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => ltrim($data->total_price, '-'),
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                    
                ];
        }
        foreach ($detailinvoicear as $data) {
            $syncItemsar[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => $data->qty,
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => $data->total_price,
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                    
                ];
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $datamemo = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "DocType" => "C",
            "Lines" => $syncItemsmemo,
        ];

        if($invoice->subtotal <= 0){ //mztambahin jika kurang dari atau sama dengan 0
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        }else{
                $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        }
                
        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);

        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if($responseData[0]['Comments'] == $commentcode){ 
            $invoice = Invoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->exists += 1;
            $this->existence[$this->exists] = 'Invoice : '. $invoice->no . ' With ' . $commentcode . ' already exists on SAP'; // Store the error message in $failures array

            $this->handlealreadySync();
        }else{
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $client = new Client();
                $route = ($invoice->subtotal <= 0) ? '/api/addarexchange' : '/api/addarexchangepayment'; //mzdiubah jika rs

                $response = $client->post($url . $route, [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);
               
    
                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                if ($errorCode !== 0) {
                    $this->fail += 1;
                    $errorMessage = $responseData['Message']; // Capture the error message
                    $this->failures[$this->fail] = 'Invoice : '. $invoice->no . ' ' . $errorMessage; // Store the error message in $failures array
                    $this->handlealreadySync();
                } else {
                    $invoice = Invoice::where('no', $code)->first();
                    $this->success += 1;
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->handlealreadySync();
                    // $this->creditmemo($code, $commentcode, $datamemo);
                }
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
                $this->dispatch('refreshBrowser');

                } catch (\Exception $e) {
                    $this->alert('error', 'No Internet Connection to Sync', [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('refreshBrowser');
                    $this->dispatch('syncCompletedBrowser');
                    $this->dispatch('syncCompleted');

                }   
        }
    }


    public function handlealreadySync()
    {
        $message = '';

        if ($this->success > 0) {
            $message .= 'Success: ' . $this->success;
        }

        if ($this->exists > 0) {
            if ($message !== '') {
                $message .= ', ';
            }

            $message .= 'Exists: ' . $this->exists;
        }

        if ($this->fail > 0) {
            if ($message !== '') {
                $message .= ', ';
            }

            $message .= 'Fail: ' . $this->fail;
        }
        $this->alert('info', 'Sync SAP', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
            'text' => $message,
        ]);
        $this->dispatch('syncCompletedBrowserAll');
        $this->dispatch('syncCompleted');
    }
}
