<?php

namespace App\Livewire\Report;

use App\Exports\ExportStock;
use App\Exports\ExportStockCard;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class StockCard extends Component
{
    use LivewireAlert;

    public $supplier;
    public $startDate;
    public $endDate;
    public $selectedDate;
    public $dataDetail;
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $selectedItem = null;
    public $selectedCodeItem;
    public $selectedIndexItem;
    public $searchitem;
    public $item;
    public $stockcard;
    public $stockstart;

    // public $whsCheckboxes = [];
    // public $whsSelectAll = false;
    // public $flagWhs = true;
    // public $whs;

    public function mount()
    {
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        // $this->dispatch('getWhs');
    }

    public function filters()
    {
        $startDate = Carbon::parse($this->startDate)->subDay()->format('Y-m-d');

        if ($this->selectedItem) {
            $this->stockstart = DB::table('Luv2_item_trans')
                ->leftJoin('Luv2_item', 'Luv2_item_trans.item_code', '=', 'Luv2_item.code')
                ->leftJoin('Luv2_warehouse', 'Luv2_item_trans.whs_code', '=', 'Luv2_warehouse.code')
                ->where('Luv2_item_trans.date', '<', $this->startDate)
                ->when($this->selectedWarehouse, function ($query) {
                    $query->where('Luv2_item_trans.whs_code', $this->selectedWarehouse->code);
                })
                ->when($this->selectedItem, function ($query) {
                    $query->where('Luv2_item_trans.item_code', $this->selectedItem->code);
                }, function ($query) {
                    $query->where('Luv2_item_trans.item_code', '');
                })
                ->select(
                    'Luv2_item.code',
                    'Luv2_item.barcode',
                    'Luv2_item.name',
                    DB::raw("'" . $startDate . "' as date"),
                    DB::raw("0 as tipe"),
                    DB::raw("'' as no_trans"),
                    DB::raw("'' as whs_name"),
                    DB::raw('SUM("Luv2_item_trans".qty) as total_qty')
                )
                ->groupBy(
                    'Luv2_item.code',
                    'Luv2_item.barcode',
                    'Luv2_item.name',
                )
                ->get();

            $this->stockcard = DB::table('Luv2_item_trans')
                ->leftJoin('Luv2_item', 'Luv2_item_trans.item_code', '=', 'Luv2_item.code')
                ->leftJoin('Luv2_warehouse', 'Luv2_item_trans.whs_code', '=', 'Luv2_warehouse.code')
                ->where('Luv2_item_trans.date', '>=', $this->startDate)
                ->where('Luv2_item_trans.date', '<=', $this->endDate)
                ->when($this->selectedWarehouse, function ($query) {
                    $query->where('Luv2_item_trans.whs_code', $this->selectedWarehouse->code);
                })
                ->when($this->selectedItem, function ($query) {
                    $query->where('Luv2_item_trans.item_code', $this->selectedItem->code);
                }, function ($query) {
                    $query->where('Luv2_item_trans.item_code', '');
                })
                ->select(
                    'Luv2_item.code',
                    'Luv2_item.barcode',
                    'Luv2_item.name',
                    'Luv2_item_trans.date',
                    'Luv2_item_trans.tipe',
                    'Luv2_item_trans.no_trans',
                    'Luv2_warehouse.name as whs_name',
                    DB::raw('SUM("Luv2_item_trans".qty) as total_qty')
                )
                ->groupBy(
                    'Luv2_item.code',
                    'Luv2_item.barcode',
                    'Luv2_item.name',
                    'Luv2_item_trans.date',
                    'Luv2_item_trans.tipe',
                    'Luv2_item_trans.no_trans',
                    'Luv2_warehouse.name',
                )
                ->orderBy('Luv2_item.code', 'ASC')
                ->orderBy('Luv2_item_trans.date', 'ASC')
                ->orderBy('Luv2_item_trans.tipe', 'ASC')
                ->get();

            if ($this->stockstart->isNotEmpty() || $this->stockcard->isNotEmpty()) {
                $this->stockcard = $this->stockstart->merge($this->stockcard);
            } else {
                $this->stockcard = $this->stockstart;
            }
        } else {
            $this->alert('warning', 'Please select item first', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch('refreshjs');
    }

    public function exportExcel()
    {
        if ($this->stockcard->isNotEmpty()) {
            if ($this->selectedWarehouse) {
                if ($this->startDate == $this->endDate) {
                    $filename = "Stock Card Report " . $this->selectedWarehouse->name . " " . $this->selectedItem->name . " - {$this->startDate}.xlsx";
                } else {
                    $filename = "Stock Card Report " . $this->selectedWarehouse->name . " " . $this->selectedItem->name . " - {$this->startDate} - {$this->endDate}.xlsx";
                }
            } else {
                if ($this->startDate == $this->endDate) {
                    $filename = "Stock Card Report " . $this->selectedItem->name . " - {$this->startDate}.xlsx";
                } else {
                    $filename = "Stock Card Report " . $this->selectedItem->name . " - {$this->startDate} - {$this->endDate}.xlsx";
                }
            }
            $this->dispatch('refreshjs');
            return Excel::download(new ExportStockCard($this->stockcard), $filename);
        } else {
            $this->alert('warning', 'No data to export', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshjs');
        }
    }

    public function updated()
    {
        $this->dispatch('refreshjs');
    }

    // #[On('getWhs')]
    // public function getWhs()
    // {
    //     $this->whs = Warehouse::where('active', 'Y')->orderBy('name', 'asc')->get();
    // }

    public function render()
    {
        $startDate = Carbon::parse($this->startDate)->subDay()->format('Y-m-d');
        // $this->whs = Warehouse::where('active', 'Y')->orderBy('name', 'asc')->get();

        $resultwarehouse = [];

        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }

        $resultitem = [];

        if (strlen($this->searchitem) >= 1) {
            $resultitem = DB::table('Luv2_item')
                ->where(function ($query) {
                    $query->where('code', 'ILIKE', '%' . $this->searchitem . '%')
                        ->orWhere('barcode', 'ILIKE', '%' . $this->searchitem . '%')
                        ->orWhere('name', 'ILIKE', '%' . $this->searchitem . '%');
                })
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->item = $resultitem;
        }
        $user = Auth::user();
        if ($user->role != 'Admin') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)
                ->where('company_code', auth()->user()->company_code)
                ->first();

            if ($warehouse) {

                $this->searchwarehouse = $warehouse->name;
                $this->selectedWarehouse = $warehouse;
            }
        }
        $this->stockstart = DB::table('Luv2_item_trans')
            ->leftJoin('Luv2_item', 'Luv2_item_trans.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_item_trans.whs_code', '=', 'Luv2_warehouse.code')
            ->where('Luv2_item_trans.date', '<', $this->startDate)
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_item_trans.whs_code', $this->selectedWarehouse->code);
            })
            ->when($this->selectedItem, function ($query) {
                $query->where('Luv2_item_trans.item_code', $this->selectedItem->code);
            }, function ($query) {
                $query->where('Luv2_item_trans.item_code', '');
            })
            ->select(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
                DB::raw("'" . $startDate . "' as date"),
                DB::raw("0 as tipe"),
                DB::raw("'' as no_trans"),
                DB::raw("'' as whs_name"),
                DB::raw('SUM("Luv2_item_trans".qty) as total_qty')
            )
            ->groupBy(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
            )
            ->get();

        $this->stockcard = DB::table('Luv2_item_trans')
            ->leftJoin('Luv2_item', 'Luv2_item_trans.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_item_trans.whs_code', '=', 'Luv2_warehouse.code')
            ->where('Luv2_item_trans.date', '>=', $this->startDate)
            ->where('Luv2_item_trans.date', '<=', $this->endDate)
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_item_trans.whs_code', $this->selectedWarehouse->code);
            })
            ->when($this->selectedItem, function ($query) {
                $query->where('Luv2_item_trans.item_code', $this->selectedItem->code);
            }, function ($query) {
                $query->where('Luv2_item_trans.item_code', '');
            })
            ->select(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
                'Luv2_item_trans.date',
                'Luv2_item_trans.tipe',
                'Luv2_item_trans.no_trans',
                'Luv2_warehouse.name as whs_name',
                DB::raw('SUM("Luv2_item_trans".qty) as total_qty')
            )
            ->groupBy(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
                'Luv2_item_trans.date',
                'Luv2_item_trans.tipe',
                'Luv2_item_trans.no_trans',
                'Luv2_warehouse.name',
            )
            ->orderBy('Luv2_item.code', 'ASC')
            ->orderBy('Luv2_item_trans.date', 'ASC')
            ->orderBy('Luv2_item_trans.tipe', 'ASC')
            ->get();

        if ($this->stockstart->isNotEmpty() || $this->stockcard->isNotEmpty()) {
            $this->stockcard = $this->stockstart->merge($this->stockcard);
        } else {
            $this->stockcard = $this->stockstart;
        }

        return view('livewire.report.stockcard', [
            'resultwarehouse' => $resultwarehouse,
            'resultitem' => $resultitem,
            'stockcard' => $this->stockcard,
            // 'whs' => $whs,
        ]);
    }

    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
        $this->dispatch('refreshjs');
    }

    public function selectItem($index)
    {
        $this->selectedIndexItem = $index;
        $this->selectedCodeItem = $this->item[$index]->code;

        $item = DB::table('Luv2_item')->where('code', $this->selectedCodeItem)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($item) {

            $this->searchitem = $item->name;
            $this->selectedItem = $item;

            $this->selectedCodeItem = null;
            $this->selectedIndexItem = null;

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function selectItemByClick($itemCode)
    {
        $item = DB::table('Luv2_item')->where('code', $itemCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($item) {

            $this->searchitem = $item->name;
            $this->selectedItem = $item;

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function updatedSearchitem()
    {
        $this->selectedItem = null;
        $this->dispatch('refreshjs');
    }

    // public function updateWhsCheckboxes($i)
    // {
    //     $this->whsCheckboxes[$i] = !$this->checkboxes[$i];
    // }
}
