<?php

namespace App\Livewire\Report;

use App\Exports\ExportGoodsReturn;
use App\Exports\ExportGoodsReturnDet;
use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportMemberTransaction;
use App\Mail\MyTestMail;
use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Member;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class GoodsReturn extends Component
{
    use LivewireAlert;

    public $focusedHeader = true;
    public $supplier;
    public $startDate;
    public $endDate;
    // public $return;
    public $selectedDate;
    public $dataDetail;
    public $searchsupplier = '';
    public $selectedSupplier = null;
    public $selectedIndex;
    public $selectedCode = '';
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $return;
    public $returnDet;

    public function mount()
    {
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        $user = Auth::user();
        
        if ($user->role != 'Admin') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)
                ->where('company_code', auth()->user()->company_code)
                ->first();

            if ($warehouse) {

                $this->searchwarehouse = $warehouse->name;
                $this->selectedWarehouse = $warehouse;
            }
        }
    }

    public function focusedHeaderTrue()
    {
        $this->focusedHeader = true;
        $this->dispatch('refreshjs');
    }

    public function focusedHeaderFalse()
    {
        $this->focusedHeader = false;
        $this->dispatch('refreshjs');
    }

    public function filters()
    {
        $this->return = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->returnDet = DB::table('Luv2_return')
            ->join('Luv2_return_detail', 'Luv2_return.no', '=', 'Luv2_return_detail.no')
            ->join('Luv2_item', 'Luv2_return_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.no', 'Luv2_return.date', 'Luv2_return.remark', 'Luv2_return_detail.qty', 'Luv2_item.*', 'Luv2_supplier.name as supp', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->dispatch('refreshjs');

        // dd($this->selectedSupplier, $this->selectedWarehouse, $this->return, $this->returnDet);
    }

    public function exportExcel()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Goods Return Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Goods Return Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');

        return Excel::download(new ExportGoodsReturn($this->return), $filename);
    }

    public function exportExcelDetail()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Goods Return Detail Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Goods Return Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportGoodsReturnDet($this->returnDet), $filename);
    }

    public function updated()
    {
        $this->dispatch('refreshjs');
    }

    public function render()
    {
        $results = [];
        $resultwarehouse = [];

        if (strlen($this->searchsupplier) >= 1) {
            $results = DB::table('Luv2_supplier')->where('name', 'ILIKE', '%' . $this->searchsupplier . '%')->limit(10)
                ->where('company_code', auth()->user()->company_code)
                ->get();
            $this->supplier = $results;
        }
        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }
        $this->return = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->returnDet = DB::table('Luv2_return')
            ->join('Luv2_return_detail', 'Luv2_return.no', '=', 'Luv2_return_detail.no')
            ->join('Luv2_item', 'Luv2_return_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.no', 'Luv2_return.date', 'Luv2_return_detail.linenum', 'Luv2_return_detail.qty', 'Luv2_return_detail.total', 'Luv2_item.*', 'Luv2_supplier.name as supp', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->orderBy('Luv2_return.date', 'ASC')
            ->orderBy('Luv2_return.no', 'ASC')
            ->orderBy('Luv2_return_detail.linenum', 'ASC')
            ->get();

        return view('livewire.report.goods-return', [
            'results' => $results,
            'resultwarehouse' => $resultwarehouse,
            'return' => $this->return,
            'returnDet' => $this->returnDet,
        ]);
    }

    public function clearfilters()
    {
        $this->searchsupplier = '';
        $this->searchwarehouse = '';
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        $this->selectedSupplier = null;
        $this->selectedWarehouse = null;

        $this->return = collect();
        $this->returnDet = collect();
        $this->dispatch('refreshjs');

    }


    public function selectSupplier($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->supplier[$index]->code;

        $supplier = DB::table('Luv2_supplier')->where('code', $this->selectedCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->selectedCode = null;
            $this->selectedIndex = null;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function selectSupplierByClick($supplierCode)
    {

        $supplier = DB::table('Luv2_supplier')->where('code', $supplierCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshjs');
        }
    }


    public function updatedSearchsupplier()
    {
        $this->selectedSupplier = null;
        $this->dispatch('refreshjs');
    }

    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
        $this->dispatch('refreshjs');
    }
}
