<?php

namespace App\Livewire\Report;

use App\Models\Invoice;
use App\Models\ItemTemp;
use App\Models\Settings;
use App\Models\Warehouse;
use App\Traits\GetItemTraits;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class GetSAP extends Component
{
    use LivewireAlert;
    use GetItemTraits;

    public $startDate;
    public $endDate;
    public $isloading = false;
    public $isCheckedAll = true;
    public $isPeriod = false;
    public $countData;


    protected function isConnectionResetError($e)
    {
        return $e instanceof \GuzzleHttp\Exception\RequestException &&
            (
                strpos($e->getMessage(), 'cURL error 56: Recv failure: Connection was reset') !== false ||
                strpos($e->getMessage(), 'cURL error 28: Connection timed out') !== false ||
                strpos($e->getMessage(), 'cURL error 7: Failed to connect') !== false
            );
    }

    protected function reDoFunction($function, $args = [])
    {
        call_user_func_array([$this, $function], $args);
    }


    public function render()
    {
        return view('livewire.report.get-s-a-p');
    }

    public function mount()
    {
        $this->startDate = Carbon::now()->toDateString();
        $this->endDate = Carbon::now()->toDateString();
    }

    public function updatedIsCheckedAll($value)
    {
        if ($value) {
            $this->isPeriod = false;
        } else {
            $this->isPeriod = true;
        }
    }

    public function firstClick()
    {
        $this->isloading = true;
        $this->dispatch('getSAPInvoice');
    }

    #[On('aftergetSAPTraits')]
    public function updatedisloading()
    {
        sleep(2);
        return redirect()->route('report.reportinvoicereturnsale');
    }
    #[On('getSAPInvoice')]
    public function getSAPInvoice()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '1000');
        try {
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $url = $setting->url;
            $whscode = $setting->wh_code;

            if ($this->isPeriod && !$this->isCheckedAll) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",0 \"cash\",0 \"card\",'' \"payment\",0 \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",0 \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", a.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"DocNum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", a.\"SlpCode\", a.\"CardCode\"",
                ]);
                $responseDetail = Http::post($url . '/api/search', [
                    "Select" => "b.\"ItemCode\" \"code\",b.\"Dscription\" \"name\",b.\"Price\" \"price\",b.\"Quantity\" \"qty\",b.\"LineTotal\" \"total_price\",a.\"SlpCode\" \"id_sales\",0 \"id_user\",a.\"DocNum\" \"invoice\",0 \"status\",case when b.\"Quantity\"*b.\"Price\"-b.\"LineTotal\">0 then 1 else 0 end \"disc\",case when b.\"Price\">b.\"LineTotal\"/b.\"Quantity\" then b.\"Price\" else b.\"LineTotal\"/b.\"Quantity\" end \"nprice\",c.\"CodeBars\" \"barcode\",'N' \"sandbox\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\", b.\"LineNum\" as \"linenum\", \"WhsCode\" as \"whs_code\", a.\"CANCELED\" as \"canceled\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"inner join oitm c on b.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and b.\"Quantity\" <> 0 and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by b.\"ItemCode\",b.\"Dscription\",b.\"Price\",a.\"SlpCode\",b.\"Quantity\",a.\"DocNum\",b.\"LineTotal\",c.\"CodeBars\", a.\"DocDate\", a.\"DocTime\", b.\"LineNum\", b.\"WhsCode\", a.\"CANCELED\""
                ]);
                $responsepayment = Http::post($url . '/api/search', [
                    "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",d.\"CashSum\" as \"cash\",d.\"TrsfrSum\" \"card\",case when d.\"CashSum\">0 and d.\"TrsfrSum\">0 then 'Multi' else (case when d.\"CashSum\">0 then 'Cash' else 'Card' end) end as \"payment\",d.\"CashSum\"+d.\"TrsfrSum\" as \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",d.\"CashSum\"+d.\"TrsfrSum\" as \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", b.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join rct2 c on a.\"DocEntry\"=c.\"DocEntry\" and a.\"ObjType\"=c.\"InvType\"inner join orct d on c.\"DocNum\"=d.\"DocNum\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"DocNum\",d.\"CashSum\",d.\"TrsfrSum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", b.\"SlpCode\", a.\"CardCode\"",
                ]);
            } elseif (!$this->isPeriod && $this->isCheckedAll) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",0 \"cash\",0 \"card\",'' \"payment\",0 \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",0 \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", a.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) group by a.\"DocNum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", a.\"SlpCode\", a.\"CardCode\"",
                ]);
                $responseDetail = Http::post($url . '/api/search', [
                    "Select" => "b.\"ItemCode\" \"code\",b.\"Dscription\" \"name\",b.\"Price\" \"price\",b.\"Quantity\" \"qty\",b.\"LineTotal\" \"total_price\",a.\"SlpCode\" \"id_sales\",0 \"id_user\",a.\"DocNum\" \"invoice\",0 \"status\",case when b.\"Quantity\"*b.\"Price\"-b.\"LineTotal\">0 then 1 else 0 end \"disc\",case when b.\"Price\">b.\"LineTotal\"/b.\"Quantity\" then b.\"Price\" else b.\"LineTotal\"/b.\"Quantity\" end \"nprice\",c.\"CodeBars\" \"barcode\",'N' \"sandbox\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\", b.\"LineNum\" as \"linenum\", \"WhsCode\" as \"whs_code\", a.\"CANCELED\" as \"canceled\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"inner join oitm c on b.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and b.\"Quantity\" <> 0 group by b.\"ItemCode\",b.\"Dscription\",b.\"Price\",a.\"SlpCode\",b.\"Quantity\",a.\"DocNum\",b.\"LineTotal\",c.\"CodeBars\", a.\"DocDate\", a.\"DocTime\", b.\"LineNum\", b.\"WhsCode\", a.\"CANCELED\""
                ]);
                $responsepayment = Http::post($url . '/api/search', [
                    "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",d.\"CashSum\" as \"cash\",d.\"TrsfrSum\" \"card\",case when d.\"CashSum\">0 and d.\"TrsfrSum\">0 then 'Multi' else (case when d.\"CashSum\">0 then 'Cash' else 'Card' end) end as \"payment\",d.\"CashSum\"+d.\"TrsfrSum\" as \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",d.\"CashSum\"+d.\"TrsfrSum\" as \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", b.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                    "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join rct2 c on a.\"DocEntry\"=c.\"DocEntry\" and a.\"ObjType\"=c.\"InvType\"inner join orct d on c.\"DocNum\"=d.\"DocNum\"",
                    "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) group by a.\"DocNum\",d.\"CashSum\",d.\"TrsfrSum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", b.\"SlpCode\", a.\"CardCode\"",
                ]);
            }


            if ($response->successful() && $responseDetail->successful() && $responsepayment->successful()) {
                $jsonData = $response->json();
                $jsonDataPayment = $responsepayment->json();
                $jsonDataDetail = $responseDetail->json();
                // dd($jsonData, $jsonDataPayment, $jsonDataDetail);

                $jsonDataCount = (int) count($jsonData);
                $this->countData = $jsonDataCount;

                if ($jsonData[0]['no'] !== 0) {
                    DB::table('Luv2_invoice_temp')->where('id_usersync', Auth::user()->id)->delete();
                    DB::table('Luv2_detailinvoice_temp')->where('id_usersync', Auth::user()->id)->delete();

                    if (!empty($jsonData)) {
                        $chunks = array_chunk($jsonData, 1000);

                        foreach ($chunks as $chunk) {
                            $insertData = [];
                            $maxId = Invoice::max('id');

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'id' => $maxId + 1,
                                    'id_usersync' => Auth::user()->id,
                                    'id_user' => $item['id_user'],
                                    'id_member' => null,
                                    'no' => $item['no'],
                                    'payment' => $item['payment'],
                                    'paid' => $item['paid'],
                                    'must_paid' => $item['must_paid'],
                                    'change' => $item['change'],
                                    'date' => $item['date'],
                                    'sync' => 'Y',
                                    'cardcode' => $item['cardcode'],
                                    'id_sales' => $item['id_sales'],
                                    'subtotal' => $item['subtotal'],
                                    'total_qty' => $item['total_qty'],
                                    'created_at' => $item['date'],
                                    'updated_at' => $item['date'],
                                    'note' => ($item['payment'] == 'Card' || $item['payment'] == 'Multi') ? json_encode([
                                        'type' =>  $item['payment'],
                                        'nama_bank' => '',
                                        'nama_pemegang_kartu' => '',
                                        'cash' => $item['cash'],
                                        'transfer' => $item['card'],
                                        'nomor_kartu' => '',
                                    ]) : null,
                                    'canceled' => $item['canceled'],
                                ];
                            }
                            DB::table('Luv2_invoice_temp')->insert($insertData);
                        }
                    }

                    if (!empty($jsonDataDetail)) {
                        $chunksDetail = array_chunk($jsonDataDetail, 1000);

                        foreach ($chunksDetail as $chunk) {
                            $insertData = [];

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'code' => $item['code'],
                                    'barcode' => $item['barcode'],
                                    'name' => $item['name'],
                                    'price' => $item['price'],
                                    'nprice' => $item['nprice'],
                                    'sandbox' => $item['sandbox'],
                                    'disc' => $item['disc'],
                                    'qty' => $item['qty'],
                                    'invoice' => $item['invoice'],
                                    'id_member' => null,
                                    'id_user' => $item['id_user'],
                                    'id_usersync' => Auth::user()->id,
                                    'id_sales' => $item['id_sales'],
                                    'total_price' => $item['total_price'],
                                    'created_at' => $item['date'],
                                    'updated_at' => $item['date'],
                                    'status' => $item['status'],
                                    'linenum' => $item['linenum'],
                                    'canceled' => $item['canceled'],
                                    'whs_code' => $item['whs_code'],
                                ];
                            }

                            DB::table('Luv2_detailinvoice_temp')->insert($insertData);
                        }
                    }
                    #insert invoice header
                    DB::statement("
                    INSERT INTO \"Luv2_invoice\" (\"id\", \"id_user\", \"id_member\", \"no\", \"payment\", \"paid\", \"must_paid\", \"change\", \"date\", \"created_at\", \"updated_at\", \"note\", \"canceled\", \"subtotal\", \"total_qty\", \"id_sales\", \"sync\", \"cardcode\") 
                    SELECT \"id\", \"id_user\", \"id_member\", \"no\", \"payment\", \"paid\", \"must_paid\", \"change\", \"date\", \"created_at\", \"updated_at\", \"note\", \"canceled\", \"subtotal\", \"total_qty\", \"id_sales\", \"sync\", \"cardcode\"
                    FROM \"Luv2_invoice_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_invoice\" WHERE \"Luv2_invoice\".\"no\" = \"Luv2_invoice_temp\".\"no\"
                    ) and \"Luv2_invoice_temp\".\"id_usersync\"='" . $userId . "' 
                    ");

                    #update invoice header
                    DB::statement("
                    UPDATE \"Luv2_invoice\"
                    SET \"canceled\"=\"Luv2_invoice_temp\".\"canceled\"
                    FROM \"Luv2_invoice_temp\"
                    WHERE \"Luv2_invoice_temp\".\"no\"=\"Luv2_invoice\".\"no\" and \"Luv2_invoice_temp\".\"canceled\" <> \"Luv2_invoice\".\"canceled\"
                    ");

                    DB::table('Luv2_invoice_temp')->where('id_usersync', Auth::user()->id)->delete();

                    if (!empty($jsonDataPayment)) {
                        $chunks = array_chunk($jsonDataPayment, 1000);

                        foreach ($chunks as $chunk) {
                            $insertData = [];
                            $maxId = Invoice::max('id');

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'id' => $maxId + 1,
                                    'id_usersync' => Auth::user()->id,
                                    'id_user' => $item['id_user'],
                                    'id_member' => null,
                                    'no' => $item['no'],
                                    'payment' => $item['payment'],
                                    'paid' => $item['paid'],
                                    'must_paid' => $item['must_paid'],
                                    'change' => $item['change'],
                                    'date' => $item['date'],
                                    'sync' => 'Y',
                                    'cardcode' => $item['cardcode'],
                                    'id_sales' => $item['id_sales'],
                                    'subtotal' => $item['subtotal'],
                                    'total_qty' => $item['total_qty'],
                                    'created_at' => $item['date'],
                                    'updated_at' => $item['date'],
                                    'note' => ($item['payment'] == 'Card' || $item['payment'] == 'Multi') ? json_encode([
                                        'type' =>  $item['payment'],
                                        'nama_bank' => '',
                                        'nama_pemegang_kartu' => '',
                                        'cash' => $item['cash'],
                                        'transfer' => $item['card'],
                                        'nomor_kartu' => '',
                                    ]) : null,
                                    'canceled' => $item['canceled'],
                                ];
                            }
                            DB::table('Luv2_invoice_temp')->insert($insertData);
                        }
                    }

                    #update invoice payment
                    DB::statement("
                    UPDATE \"Luv2_invoice\"
                    SET \"payment\"=\"Luv2_invoice_temp\".\"payment\", \"paid\"=\"Luv2_invoice_temp\".\"paid\", \"must_paid\"=\"Luv2_invoice_temp\".\"must_paid\", \"change\"=\"Luv2_invoice_temp\".\"change\", \"note\"=\"Luv2_invoice_temp\".\"note\"
                    FROM \"Luv2_invoice_temp\"
                    WHERE \"Luv2_invoice_temp\".\"no\"=\"Luv2_invoice\".\"no\" and (
                        \"Luv2_invoice_temp\".\"payment\" <> \"Luv2_invoice\".\"payment\" or 
                        \"Luv2_invoice_temp\".\"paid\" <> \"Luv2_invoice\".\"paid\" or
                        \"Luv2_invoice_temp\".\"must_paid\" <> \"Luv2_invoice\".\"must_paid\" or
                        \"Luv2_invoice_temp\".\"change\" <> \"Luv2_invoice\".\"change\" or
                        \"Luv2_invoice_temp\".\"note\" <> \"Luv2_invoice\".\"note\")
                    ");

                    #insert item trans
                    DB::statement("
                    INSERT INTO \"Luv2_item_trans\" (\"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\") 
                    SELECT \"whs_code\", \"invoice\", '13', case WHEN \"canceled\" = 'C' then \"qty\" else \"qty\" * -1 END, \"created_at\", \"canceled\", \"code\", \"linenum\"
                    FROM \"Luv2_detailinvoice_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item_trans\" WHERE \"Luv2_item_trans\".\"no_trans\" = \"Luv2_detailinvoice_temp\".\"invoice\" and \"Luv2_item_trans\".\"linenum\" = \"Luv2_detailinvoice_temp\".\"linenum\" and \"Luv2_item_trans\".\"tipe\"='13'
                    ) and \"Luv2_detailinvoice_temp\".\"id_usersync\"='" . $userId . "' 
                    ");

                    #insert detail
                    DB::statement("
                    INSERT INTO \"Luv2_detailinvoice\" (\"code\", \"barcode\", \"name\", \"price\", \"nprice\", \"sandbox\", \"disc\", \"qty\", \"invoice\", \"id_member\", \"id_user\", \"id_sales\", \"total_price\", \"created_at\", \"updated_at\", \"status\", \"linenum\") 
                    SELECT \"code\", \"barcode\", \"name\", \"price\", \"nprice\", \"sandbox\", \"disc\", \"qty\", \"invoice\", \"id_member\", \"id_user\", \"id_sales\", \"total_price\", \"created_at\", \"updated_at\", \"status\", \"linenum\"
                    FROM \"Luv2_detailinvoice_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_detailinvoice\" WHERE \"Luv2_detailinvoice\".\"invoice\" = \"Luv2_detailinvoice_temp\".\"invoice\" AND \"Luv2_detailinvoice\".\"code\" = \"Luv2_detailinvoice_temp\".\"code\" AND\"Luv2_detailinvoice\".\"status\" = \"Luv2_detailinvoice_temp\".\"status\" AND \"Luv2_detailinvoice\".\"linenum\" = \"Luv2_detailinvoice_temp\".\"linenum\"
                    ) and \"Luv2_detailinvoice_temp\".\"id_usersync\"='" . $userId . "' 
                    ");
                    $this->alert('success', 'Get data Invoice success', [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('getItem');
                } else {
                    $this->alert('info', 'There`s no Data Invoice', [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloading = false;
                }
            } else {
                $this->alert('info', 'No Connection to SAP Server', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isloading = false;
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('getSAPInvoice');
            } else {
                throw $e;
            }
        }
    }



    #[On('filterSAPInvoice')]
    public function getSAPInvoiceFilter()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '1000');

        try {
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $url = $setting->url;
            $whscode = $setting->wh_code;

            $response = Http::post($url . '/api/search', [
                "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",0 \"cash\",0 \"card\",'' \"payment\",0 \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",0 \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", a.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"",
                "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"DocNum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", a.\"SlpCode\", a.\"CardCode\"",
            ]);
            $responseDetail = Http::post($url . '/api/search', [
                "Select" => "b.\"ItemCode\" \"code\",b.\"Dscription\" \"name\",b.\"Price\" \"price\",b.\"Quantity\" \"qty\",b.\"LineTotal\" \"total_price\",a.\"SlpCode\" \"id_sales\",0 \"id_user\",a.\"DocNum\" \"invoice\",0 \"status\",case when b.\"Quantity\"*b.\"Price\"-b.\"LineTotal\">0 then 1 else 0 end \"disc\",case when b.\"Price\">b.\"LineTotal\"/b.\"Quantity\" then b.\"Price\" else b.\"LineTotal\"/b.\"Quantity\" end \"nprice\",c.\"CodeBars\" \"barcode\",'N' \"sandbox\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\", b.\"LineNum\" as \"linenum\", \"WhsCode\" as \"whs_code\", a.\"CANCELED\" as \"canceled\"",
                "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\"inner join oitm c on b.\"ItemCode\"=c.\"ItemCode\"",
                "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and b.\"Quantity\" <> 0 and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by b.\"ItemCode\",b.\"Dscription\",b.\"Price\",a.\"SlpCode\",b.\"Quantity\",a.\"DocNum\",b.\"LineTotal\",c.\"CodeBars\", a.\"DocDate\", a.\"DocTime\", b.\"LineNum\", b.\"WhsCode\", a.\"CANCELED\""
            ]);
            $responsepayment = Http::post($url . '/api/search', [
                "Select" => "0 as \"id_user\",a.\"DocNum\" as \"no\",d.\"CashSum\" as \"cash\",d.\"TrsfrSum\" \"card\",case when d.\"CashSum\">0 and d.\"TrsfrSum\">0 then 'Multi' else (case when d.\"CashSum\">0 then 'Cash' else 'Card' end) end as \"payment\",d.\"CashSum\"+d.\"TrsfrSum\" as \"paid\",0 as \"change\",concat(concat(TO_VARCHAR(a.\"DocDate\", 'YYYY-MM-DD '),case when length(to_varchar(a.\"DocTime\"))=3 then concat('0',concat(left(to_varchar(a.\"DocTime\"),1),concat(':',right(to_varchar(a.\"DocTime\"),2)))) else concat(left(to_varchar(a.\"DocTime\"),2),concat(':',right(to_varchar(a.\"DocTime\"),2))) end),':00') as \"date\",'' as \"no_inv\",d.\"CashSum\"+d.\"TrsfrSum\" as \"must_paid\", a.\"CANCELED\" as \"canceled\", SUM(b.\"Quantity\") as \"total_qty\", SUM(b.\"Quantity\" * \"Price\") as \"subtotal\", b.\"SlpCode\" as \"id_sales\", a.\"CardCode\" as \"cardcode\"",
                "From" => "oinv a inner join inv1 b on a.\"DocEntry\"=b.\"DocEntry\" inner join rct2 c on a.\"DocEntry\"=c.\"DocEntry\" and a.\"ObjType\"=c.\"InvType\"inner join orct d on c.\"DocNum\"=d.\"DocNum\"",
                "Where" => "b.\"WhsCode\"='" . $whscode . "' and (a.\"Comments\" not like '" . $whscode . "/%' or a.\"Comments\" is NULL) and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"DocNum\",d.\"CashSum\",d.\"TrsfrSum\",a.\"DocDate\",a.\"DocTime\",a.\"CANCELED\", b.\"SlpCode\", a.\"CardCode\"",
            ]);

            if ($response->successful() && $responseDetail->successful() && $responsepayment->successful()) {
                $jsonData = $response->json();
                $jsonDataPayment = $responsepayment->json();
                $jsonDataDetail = $responseDetail->json();

                if (empty($jsonData) || $jsonData[0]['no'] == 0) {
                    $this->Gagal();
                } else {
                    $this->Berhasil($jsonData, $jsonDataPayment, $jsonDataDetail);
                }
            } else {
                $this->alert('info', 'Unable to connect to SAP Server.', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isloading = false;
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('getSAPInvoiceFilter');
            } else {
                throw $e;
            }
        }
    }




    #[On('getItem')]
    public function sapGetItem()
    {
        if ($this->isPeriod && !$this->isCheckedAll) {
            $this->getItemwithUDFandFilter();
        } elseif (!$this->isPeriod && $this->isCheckedAll) {
            $this->getItemwithUDF();
        }
    }

    public function Berhasil($jsonData, $jsonDataPayment, $jsonDataDetail)
    {
        $userId = Auth::user()->id;
        DB::table('Luv2_invoice_temp')->where('id_usersync', Auth::user()->id)->delete();
        DB::table('Luv2_detailinvoice_temp')->where('id_usersync', Auth::user()->id)->delete();

        if (!empty($jsonData)) {
            $chunks = array_chunk($jsonData, 1000);

            foreach ($chunks as $chunk) {
                $insertData = [];
                $maxId = Invoice::max('id');

                foreach ($chunk as $item) {
                    $insertData[] = [
                        'id' => $maxId + 1,
                        'id_usersync' => Auth::user()->id,
                        'id_user' => $item['id_user'],
                        'id_member' => null,
                        'no' => $item['no'],
                        'payment' => $item['payment'],
                        'paid' => $item['paid'],
                        'must_paid' => $item['must_paid'],
                        'change' => $item['change'],
                        'date' => $item['date'],
                        'sync' => 'Y',
                        'cardcode' => $item['cardcode'],
                        'id_sales' => $item['id_sales'],
                        'subtotal' => $item['subtotal'],
                        'total_qty' => $item['total_qty'],
                        'created_at' => $item['date'],
                        'updated_at' => $item['date'],
                        'note' => ($item['payment'] == 'Card' || $item['payment'] == 'Multi') ? json_encode([
                            'type' =>  $item['payment'],
                            'nama_bank' => '',
                            'nama_pemegang_kartu' => '',
                            'cash' => $item['cash'],
                            'transfer' => $item['card'],
                            'nomor_kartu' => '',
                        ]) : null,
                        'canceled' => $item['canceled'],
                    ];
                }
                DB::table('Luv2_invoice_temp')->insert($insertData);
            }
        }

        if (!empty($jsonDataDetail)) {
            $chunksDetail = array_chunk($jsonDataDetail, 1000);

            foreach ($chunksDetail as $chunk) {
                $insertData = [];

                foreach ($chunk as $item) {
                    $insertData[] = [
                        'code' => $item['code'],
                        'barcode' => $item['barcode'],
                        'name' => $item['name'],
                        'price' => $item['price'],
                        'nprice' => $item['nprice'],
                        'sandbox' => $item['sandbox'],
                        'disc' => $item['disc'],
                        'qty' => $item['qty'],
                        'invoice' => $item['invoice'],
                        'id_member' => null,
                        'id_user' => $item['id_user'],
                        'id_usersync' => Auth::user()->id,
                        'id_sales' => $item['id_sales'],
                        'total_price' => $item['total_price'],
                        'created_at' => $item['date'],
                        'updated_at' => $item['date'],
                        'status' => $item['status'],
                        'linenum' => $item['linenum'],
                        'canceled' => $item['canceled'],
                        'whs_code' => $item['whs_code'],
                    ];
                }

                DB::table('Luv2_detailinvoice_temp')->insert($insertData);
            }
        }

        #insert invoice header
        DB::statement("
                            INSERT INTO \"Luv2_invoice\" (\"id\", \"id_user\", \"id_member\", \"no\", \"payment\", \"paid\", \"must_paid\", \"change\", \"date\", \"created_at\", \"updated_at\", \"note\", \"canceled\", \"subtotal\", \"total_qty\", \"id_sales\", \"sync\", \"cardcode\") 
                            SELECT \"id\", \"id_user\", \"id_member\", \"no\", \"payment\", \"paid\", \"must_paid\", \"change\", \"date\", \"created_at\", \"updated_at\", \"note\", \"canceled\", \"subtotal\", \"total_qty\", \"id_sales\", \"sync\", \"cardcode\"
                            FROM \"Luv2_invoice_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_invoice\" WHERE \"Luv2_invoice\".\"no\" = \"Luv2_invoice_temp\".\"no\"
                            ) and \"Luv2_invoice_temp\".\"id_user\"='" . $userId . "' 
                            ");

        #update invoice header
        DB::statement("
                            UPDATE \"Luv2_invoice\"
                            SET \"canceled\"=\"Luv2_invoice_temp\".\"canceled\"
                            FROM \"Luv2_invoice_temp\"
                            WHERE \"Luv2_invoice_temp\".\"no\"=\"Luv2_invoice\".\"no\" and \"Luv2_invoice_temp\".\"canceled\" <> \"Luv2_invoice\".\"canceled\"
                            ");

        DB::table('Luv2_invoice_temp')->where('id_usersync', Auth::user()->id)->delete();

        if (!empty($jsonDataPayment)) {
            $chunks = array_chunk($jsonDataPayment, 1000);

            foreach ($chunks as $chunk) {
                $insertData = [];
                $maxId = Invoice::max('id');

                foreach ($chunk as $item) {
                    $insertData[] = [
                        'id' => $maxId + 1,
                        'id_usersync' => Auth::user()->id,
                        'id_user' => $item['id_user'],
                        'id_member' => null,
                        'no' => $item['no'],
                        'payment' => $item['payment'],
                        'paid' => $item['paid'],
                        'must_paid' => $item['must_paid'],
                        'change' => $item['change'],
                        'date' => $item['date'],
                        'sync' => 'Y',
                        'cardcode' => $item['cardcode'],
                        'id_sales' => $item['id_sales'],
                        'subtotal' => $item['subtotal'],
                        'total_qty' => $item['total_qty'],
                        'created_at' => $item['date'],
                        'updated_at' => $item['date'],
                        'note' => ($item['payment'] == 'Card' || $item['payment'] == 'Multi') ? json_encode([
                            'type' =>  $item['payment'],
                            'nama_bank' => '',
                            'nama_pemegang_kartu' => '',
                            'cash' => $item['cash'],
                            'transfer' => $item['card'],
                            'nomor_kartu' => '',
                        ]) : null,
                        'canceled' => $item['canceled'],
                    ];
                }
                DB::table('Luv2_invoice_temp')->insert($insertData);
            }
        }

        #update invoice payment
        DB::statement("
                            UPDATE \"Luv2_invoice\"
                            SET \"payment\"=\"Luv2_invoice_temp\".\"payment\", \"paid\"=\"Luv2_invoice_temp\".\"paid\", \"must_paid\"=\"Luv2_invoice_temp\".\"must_paid\", \"change\"=\"Luv2_invoice_temp\".\"change\", \"note\"=\"Luv2_invoice_temp\".\"note\"
                            FROM \"Luv2_invoice_temp\"
                            WHERE \"Luv2_invoice_temp\".\"no\"=\"Luv2_invoice\".\"no\" and (
                                \"Luv2_invoice_temp\".\"payment\" <> \"Luv2_invoice\".\"payment\" or 
                                \"Luv2_invoice_temp\".\"paid\" <> \"Luv2_invoice\".\"paid\" or
                                \"Luv2_invoice_temp\".\"must_paid\" <> \"Luv2_invoice\".\"must_paid\" or
                                \"Luv2_invoice_temp\".\"change\" <> \"Luv2_invoice\".\"change\" or
                                \"Luv2_invoice_temp\".\"note\" <> \"Luv2_invoice\".\"note\")
                            ");

        #insert item trans
        DB::statement("
                            INSERT INTO \"Luv2_item_trans\" (\"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\") 
                            SELECT \"whs_code\", \"invoice\", '13', case WHEN \"canceled\" = 'C' then \"qty\" else \"qty\" * -1 END, \"created_at\", \"canceled\", \"code\", \"linenum\"
                            FROM \"Luv2_detailinvoice_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_trans\" WHERE \"Luv2_item_trans\".\"no_trans\" = \"Luv2_detailinvoice_temp\".\"invoice\" and \"Luv2_item_trans\".\"linenum\" = \"Luv2_detailinvoice_temp\".\"linenum\" and \"Luv2_item_trans\".\"tipe\"='13'
                            ) and \"Luv2_detailinvoice_temp\".\"id_user\"='" . $userId . "'
                            ");

        #insert detail
        DB::statement("
                            INSERT INTO \"Luv2_detailinvoice\" (\"code\", \"barcode\", \"name\", \"price\", \"nprice\", \"sandbox\", \"disc\", \"qty\", \"invoice\", \"id_member\", \"id_user\", \"id_sales\", \"total_price\", \"created_at\", \"updated_at\", \"status\", \"linenum\") 
                            SELECT \"code\", \"barcode\", \"name\", \"price\", \"nprice\", \"sandbox\", \"disc\", \"qty\", \"invoice\", \"id_member\", \"id_user\", \"id_sales\", \"total_price\", \"created_at\", \"updated_at\", \"status\", \"linenum\"
                            FROM \"Luv2_detailinvoice_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_detailinvoice\" WHERE \"Luv2_detailinvoice\".\"invoice\" = \"Luv2_detailinvoice_temp\".\"invoice\" AND \"Luv2_detailinvoice\".\"code\" = \"Luv2_detailinvoice_temp\".\"code\" AND\"Luv2_detailinvoice\".\"status\" = \"Luv2_detailinvoice_temp\".\"status\" AND \"Luv2_detailinvoice\".\"linenum\" = \"Luv2_detailinvoice_temp\".\"linenum\"
                            ) and \"Luv2_detailinvoice_temp\".\"id_user\"='" . $userId . "'
                            ");

        $this->alert('success', 'Data Invoice successfully retrieved and processed.', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->dispatch('getItem');
        // // $this->isloading = false;
    }

    public function Gagal()
    {
        $this->alert('info', 'There are no Invoices available.', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->isloading = false;
    }

    
}
